/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.vbo.builders;

import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.io.IGLLoader;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.vbo.buffers.FloatVBO;
import org.jzy3d.plot3d.primitives.vbo.drawable.DrawableVBO;

public abstract class VBOBuilder
implements IGLLoader<DrawableVBO> {
    static Logger logger = Logger.getLogger(VBOBuilder.class);

    protected void fillWithCollection(DrawableVBO drawable, Collection<Coord3d> coordinates, ColorMapper colors, FloatBuffer vertices, IntBuffer indices, BoundingBox3d bounds) {
        drawable.setHasColorBuffer(colors != null);
        int size = 0;
        for (Coord3d c : coordinates) {
            indices.put(size++);
            this.putCoord(vertices, c);
            bounds.add(c);
            if (colors == null) continue;
            this.putColor(vertices, colors.getColor(c));
        }
        vertices.rewind();
        indices.rewind();
    }

    protected void fillWithCollection(DrawableVBO drawable, List<Coord3d> coordinates, FloatVBO vbo) {
        this.fillWithCollection(drawable, coordinates, vbo.getVertices(), vbo.getIndices(), vbo.getBounds());
    }

    protected void fillWithCollection(DrawableVBO drawable, List<Coord3d> coordinates, FloatVBO vbo, ColorMapper coloring) {
        this.fillWithCollection(drawable, coordinates, coloring, vbo.getVertices(), vbo.getIndices(), vbo.getBounds());
    }

    protected void fillWithCollection(DrawableVBO drawable, Collection<Coord3d> coordinates, FloatBuffer vertices, IntBuffer indices, BoundingBox3d bounds) {
        this.fillWithCollection(drawable, coordinates, null, vertices, indices, bounds);
    }

    protected void fillWithRandomBar(int n, DrawableVBO drawable, FloatBuffer vertices, IntBuffer indices, BoundingBox3d bounds, ColorMapper colors) {
        drawable.setHasColorBuffer(colors != null);
        int size = 0;
        for (int i = 0; i < n; ++i) {
            float z = (float)Math.random() * 100.0f;
            float y = (float)Math.random() * 1.0f;
            indices.put(size++);
            Coord3d c1 = new Coord3d(i, 0.0f, 0.0f);
            this.putCoord(vertices, c1);
            this.putColor(vertices, Color.RED);
            bounds.add(c1);
            indices.put(size++);
            Coord3d c2 = new Coord3d(i, y, z);
            this.putCoord(vertices, c2);
            this.putColor(vertices, Color.RED);
            bounds.add(c2);
        }
        vertices.rewind();
        indices.rewind();
    }

    protected void fillWithRandomBar(int n, DrawableVBO drawable, FloatVBO vbo, ColorMapper colors) {
        this.fillWithRandomBar(n, drawable, vbo.getVertices(), vbo.getIndices(), vbo.getBounds(), colors);
    }

    protected void putBar(FloatVBO vbo, int size, float x, float y, float z, Color color) {
        Coord3d c1 = new Coord3d(x, 0.0f, 0.0f);
        Coord3d c2 = new Coord3d(x, y, z);
        this.putPoint(vbo, size++, color, c1);
        this.putPoint(vbo, size++, color, c2);
    }

    protected void putPoint(FloatVBO vbo, int id, Color color, Coord3d coord) {
        vbo.getIndices().put(id);
        this.putCoord(vbo, coord);
        this.putColor(vbo, color);
        vbo.getBounds().add(coord);
    }

    protected void putCoord(FloatVBO vbo, Coord3d c) {
        vbo.getVertices().put(c.x);
        vbo.getVertices().put(c.y);
        vbo.getVertices().put(c.z);
    }

    protected void putCoord(FloatBuffer vertices, Coord3d c) {
        vertices.put(c.x);
        vertices.put(c.y);
        vertices.put(c.z);
    }

    protected void putColor(FloatVBO vbo, Color color) {
        vbo.getVertices().put(color.r);
        vbo.getVertices().put(color.g);
        vbo.getVertices().put(color.b);
    }

    protected void putColor(FloatBuffer vertices, Color color) {
        vertices.put(color.r);
        vertices.put(color.g);
        vertices.put(color.b);
    }

    protected FloatVBO initFloatVBO(DrawableVBO drawable, boolean hasNormal, boolean hasColor, int n, int dimension) {
        int geometrySize = this.computeGeometrySize(drawable);
        int verticeBufferSize = this.computeVerticeBufferSize(drawable.getGeometry(), n, dimension, geometrySize, hasNormal, hasColor);
        int indexBufferSize = this.computeIndexBufferSize(n, geometrySize, hasColor);
        logger.info((Object)(indexBufferSize + " " + verticeBufferSize));
        FloatVBO vbo = new FloatVBO(verticeBufferSize, indexBufferSize);
        return vbo;
    }

    private int computeIndexBufferSize(int n, int geometrySize, boolean hasColor) {
        return n * geometrySize;
    }

    protected int geometryTypeToMultiplier(int geometrySize) {
        if (geometrySize == 0) {
            return 1;
        }
        if (geometrySize == 1) {
            return 2;
        }
        if (geometrySize == 4) {
            return 3;
        }
        return 1;
    }

    protected FloatVBO initFloatVBO(DrawableVBO drawable, boolean hasNormal, boolean hasColor, int n) {
        return this.initFloatVBO(drawable, hasNormal, hasColor, n, 3);
    }

    protected FloatVBO initFloatVBO(DrawableVBO drawable, boolean hasColor, int n) {
        return this.initFloatVBO(drawable, false, hasColor, n, 3);
    }

    protected int computeVerticeBufferSize(int type, int n, int dim, int geometrySize, boolean hasNormal, boolean hasColor) {
        if (type == 1) {
            if (hasColor) {
                return n * (dim * 2 * 2) * geometrySize;
            }
            return n * (dim * 2) * geometrySize;
        }
        if (type == 3) {
            if (hasColor) {
                return n * (dim * 2) * geometrySize;
            }
            return n * dim * geometrySize;
        }
        if (hasColor) {
            return n * (dim * 2) * geometrySize;
        }
        if (hasNormal) {
            return n * (dim * 2) * geometrySize;
        }
        return n * dim * geometrySize;
    }

    protected int computeGeometrySize(DrawableVBO drawable) {
        if (drawable.getGeometry() == 0) {
            return 1;
        }
        if (drawable.getGeometry() == 1) {
            return 2;
        }
        if (drawable.getGeometry() == 4) {
            return 3;
        }
        return 2;
    }
}

