/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.lights;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.util.gl2.GLUT;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.lights.LightSwitch;

public class Light {
    protected int lightId;
    protected boolean enabled;
    protected Color ambiantColor;
    protected Color diffuseColor;
    protected Color specularColor;
    protected Coord3d position;
    protected float[] positionZero = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected boolean representationDisplayed;
    protected float representationRadius = 10.0f;
    protected static GLUT glut = new GLUT();
    protected static int lightCount;

    public static void resetCounter() {
        lightCount = 0;
    }

    public Light() {
        this(lightCount++, true);
    }

    public Light(int id) {
        this(id, true);
    }

    public Light(int id, boolean representationDisplayed) {
        this(id, true, true);
    }

    public Light(int id, boolean enabled, boolean representationDisplayed) {
        this.lightId = id;
        this.enabled = enabled;
        this.representationDisplayed = representationDisplayed;
        this.ambiantColor = Color.WHITE;
        this.diffuseColor = Color.WHITE;
        this.specularColor = Color.WHITE;
    }

    public void apply(GL gl, Coord3d scale) {
        if (this.enabled) {
            if (gl.isGL2()) {
                gl.getGL2().glMatrixMode(5888);
                gl.getGL2().glLoadIdentity();
                gl.getGL2().glTranslatef(this.position.x * scale.x, this.position.y * scale.y, this.position.z * scale.z);
                if (this.representationDisplayed) {
                    gl.glDisable(2896);
                    gl.getGL2().glColor3f(0.0f, 1.0f, 1.0f);
                    gl.getGL2().glPolygonMode(1032, 6913);
                    glut.glutSolidCube(this.representationRadius);
                    gl.glEnable(2896);
                }
                this.setGLLight(gl);
            } else {
                GLES2CompatUtils.glMatrixMode(5888);
                GLES2CompatUtils.glLoadIdentity();
                GLES2CompatUtils.glTranslatef(this.position.x * scale.x, this.position.y * scale.y, this.position.z * scale.z);
                if (this.representationDisplayed) {
                    gl.glDisable(2896);
                    GLES2CompatUtils.glColor3f(0.0f, 1.0f, 1.0f);
                    GLES2CompatUtils.glPolygonMode(1032, 6913);
                    glut.glutSolidCube(this.representationRadius);
                    gl.glEnable(2896);
                }
                this.setGLESLight(16384);
            }
        } else {
            gl.glDisable(2896);
        }
    }

    protected void setGLLight(GL gl) {
        LightSwitch.enable(gl, this.lightId);
        switch (this.lightId) {
            case 0: {
                this.setGLLight(gl, 16384);
                break;
            }
            case 1: {
                this.setGLLight(gl, 16385);
                break;
            }
            case 2: {
                this.setGLLight(gl, 16386);
                break;
            }
            case 3: {
                this.setGLLight(gl, 16387);
                break;
            }
            case 4: {
                this.setGLLight(gl, 16388);
                break;
            }
            case 5: {
                this.setGLLight(gl, 16389);
                break;
            }
            case 6: {
                this.setGLLight(gl, 16390);
                break;
            }
            case 7: {
                this.setGLLight(gl, 16391);
            }
        }
    }

    protected void setGLESLight() {
        switch (this.lightId) {
            case 0: {
                this.setGLESLight(16384);
                break;
            }
            case 1: {
                this.setGLESLight(16385);
                break;
            }
            case 2: {
                this.setGLESLight(16386);
                break;
            }
            case 3: {
                this.setGLESLight(16387);
                break;
            }
            case 4: {
                this.setGLESLight(16388);
                break;
            }
            case 5: {
                this.setGLESLight(16389);
                break;
            }
            case 6: {
                this.setGLESLight(16390);
                break;
            }
            case 7: {
                this.setGLESLight(16391);
            }
        }
    }

    protected void setGLESLight(int func) {
        GLES2CompatUtils.glLightfv(func, 4611, this.positionZero, 0);
        GLES2CompatUtils.glLightfv(func, 4608, this.ambiantColor.toArray(), 0);
        GLES2CompatUtils.glLightfv(func, 4609, this.diffuseColor.toArray(), 0);
        GLES2CompatUtils.glLightfv(func, 4610, this.specularColor.toArray(), 0);
    }

    protected void setGLLight(GL gl, int func) {
        gl.getGL2().glLightfv(func, 4611, this.positionZero, 0);
        gl.getGL2().glLightfv(func, 4608, this.ambiantColor.toArray(), 0);
        gl.getGL2().glLightfv(func, 4609, this.diffuseColor.toArray(), 0);
        gl.getGL2().glLightfv(func, 4610, this.specularColor.toArray(), 0);
    }

    public void setRepresentationDisplayed(boolean status) {
        this.representationDisplayed = status;
    }

    public boolean getRepresentationDisplayed() {
        return this.representationDisplayed;
    }

    public float getRepresentationRadius() {
        return this.representationRadius;
    }

    public void setRepresentationRadius(float representationRadius) {
        this.representationRadius = representationRadius;
    }

    public int getId() {
        return this.lightId;
    }

    public void setPosition(Coord3d position) {
        this.position = position;
    }

    public Coord3d getPosition() {
        return this.position;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Color getAmbiantColor() {
        return this.ambiantColor;
    }

    public void setAmbiantColor(Color ambiantColor) {
        this.ambiantColor = ambiantColor;
    }

    public Color getDiffuseColor() {
        return this.diffuseColor;
    }

    public void setDiffuseColor(Color diffuseColor) {
        this.diffuseColor = diffuseColor;
    }

    public Color getSpecularColor() {
        return this.specularColor;
    }

    public void setSpecularColor(Color specularColor) {
        this.specularColor = specularColor;
    }
}

