/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.plot3d.rendering.view.AWTRenderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class AWTImageRenderer3d
extends AWTRenderer3d {
    protected List<DisplayListener> listeners = new ArrayList<DisplayListener>();

    public AWTImageRenderer3d() {
    }

    public AWTImageRenderer3d(View view, boolean traceGL, boolean debugGL, GLU glu) {
        super(view, traceGL, debugGL, glu);
    }

    @Override
    public void display(GLAutoDrawable canvas) {
        GL gl = canvas.getGL();
        if (this.view != null) {
            this.view.clear(gl);
            this.view.render(gl, this.glu);
            BufferedImage image = this.makeScreenshotAsBufferedImage(gl);
            this.fireDisplay(image);
            if (this.doScreenshotAtNextDisplay) {
                this.doScreenshotAtNextDisplay = false;
            }
        }
    }

    protected BufferedImage makeScreenshotAsBufferedImage(GL gl) {
        AWTGLReadBufferUtil screenshot = this.makeScreenshot(gl);
        return screenshot.readPixelsToBufferedImage(gl, true);
    }

    private AWTGLReadBufferUtil makeScreenshot(GL gl) {
        AWTGLReadBufferUtil screenshot = new AWTGLReadBufferUtil(GLProfile.getGL2GL3(), true);
        screenshot.readPixels(gl, true);
        this.image = screenshot.getTextureData();
        return screenshot;
    }

    public AWTImageRenderer3d(View view, boolean traceGL, boolean debugGL) {
        super(view, traceGL, debugGL);
    }

    public void addDisplayListener(DisplayListener listener) {
        this.listeners.add(listener);
    }

    protected void fireDisplay(Object image) {
        for (DisplayListener listener : this.listeners) {
            listener.onDisplay(image);
        }
    }

    public AWTImageRenderer3d(View view) {
        super(view);
    }

    public static interface DisplayListener {
        public void onDisplay(Object var1);
    }
}

