/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.colors.Color;
import org.jzy3d.events.IViewIsVerticalEventListener;
import org.jzy3d.events.IViewLifecycleEventListener;
import org.jzy3d.events.IViewPointChangedListener;
import org.jzy3d.events.ViewIsVerticalEvent;
import org.jzy3d.events.ViewLifecycleEvent;
import org.jzy3d.events.ViewPointChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Rectangle;
import org.jzy3d.maths.Scale;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.scene.Graph;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.rendering.view.ViewportBuilder;
import org.jzy3d.plot3d.rendering.view.ViewportConfiguration;
import org.jzy3d.plot3d.rendering.view.ViewportMode;
import org.jzy3d.plot3d.rendering.view.modes.CameraMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewBoundMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;
import org.jzy3d.plot3d.transform.Transform;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class View {
    protected static Logger LOGGER = Logger.getLogger(View.class);
    protected Chart chart;
    protected GLU glu;
    public static float STRETCH_RATIO = 0.25f;
    protected boolean MAINTAIN_ALL_OBJECTS_IN_VIEW = false;
    protected boolean DISPLAY_AXE_WHOLE_BOUNDS = false;
    protected boolean axeBoxDisplayed = true;
    protected boolean squared = true;
    protected Camera cam;
    protected IAxe axe;
    protected Quality quality;
    protected Scene scene;
    protected ICanvas canvas;
    protected Scene annotations;
    protected Coord3d viewpoint;
    protected Coord3d center;
    protected Coord3d scaling;
    protected BoundingBox3d viewbounds;
    protected CameraMode cameraMode;
    protected ViewPositionMode viewmode;
    protected ViewBoundMode boundmode;
    protected Color bgColor = Color.BLACK;
    protected List<IViewPointChangedListener> viewPointChangedListeners;
    protected List<IViewIsVerticalEventListener> viewOnTopListeners;
    protected List<IViewLifecycleEventListener> viewLifecycleListeners;
    protected boolean wasOnTopAtLastRendering;
    protected static final float PI_div2 = 1.5707964f;
    public static final Coord3d DEFAULT_VIEW = new Coord3d(1.0471975511965976, 1.0471975511965976, 2000.0);
    protected boolean dimensionDirty = false;
    protected boolean viewDirty = false;
    protected static View current;
    protected BoundingBox3d initBounds;
    protected float factorViewPointDistance = 2.0f;
    protected boolean slave = false;
    protected SpaceTransformer spaceTransformer = new SpaceTransformer();

    public View(IChartComponentFactory factory, Scene scene, ICanvas canvas, Quality quality) {
        BoundingBox3d sceneBounds = this.getSceneGraphBounds(scene);
        this.viewpoint = DEFAULT_VIEW.clone();
        this.center = sceneBounds.getCenter();
        this.scaling = Coord3d.IDENTITY.clone();
        this.viewbounds = null;
        this.viewmode = ViewPositionMode.FREE;
        this.boundmode = ViewBoundMode.AUTO_FIT;
        this.cameraMode = CameraMode.ORTHOGONAL;
        this.axe = factory.newAxe(sceneBounds, this);
        this.cam = factory.newCamera(this.center);
        this.scene = scene;
        this.canvas = canvas;
        this.quality = quality;
        this.annotations = factory.newScene(false);
        this.viewOnTopListeners = new ArrayList<IViewIsVerticalEventListener>();
        this.viewPointChangedListeners = new ArrayList<IViewPointChangedListener>();
        this.viewLifecycleListeners = new ArrayList<IViewLifecycleEventListener>();
        this.wasOnTopAtLastRendering = false;
        this.glu = new GLU();
        this.scene.getGraph().getStrategy().setView(this);
        this.spaceTransformer = new SpaceTransformer();
        current = this;
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public boolean isSlave() {
        return this.slave;
    }

    public void setSlave(boolean slave) {
        this.slave = slave;
    }

    public void dispose() {
        this.axe.dispose();
        this.cam = null;
        this.viewOnTopListeners.clear();
        this.scene = null;
        this.canvas = null;
        this.quality = null;
    }

    public void shoot() {
        this.canvas.forceRepaint();
    }

    public void project() {
        GL gl = this.getCurrentGL();
        this.scene.getGraph().project(gl, this.glu, this.cam);
        this.getCurrentContext().release();
    }

    public Coord3d projectMouse(int x, int y) {
        GL gl = this.getCurrentGL();
        Coord3d p = this.cam.screenToModel(gl, this.glu, new Coord3d(x, y, 0.0f));
        this.getCurrentContext().release();
        return p;
    }

    public void rotate(Coord2d move) {
        this.rotate(move, true);
    }

    public void rotate(Coord2d move, boolean updateView) {
        Coord3d eye = this.getViewPoint();
        eye.x -= move.x;
        eye.y += move.y;
        this.setViewPoint(eye, updateView);
    }

    public void shift(float factor) {
        this.shift(factor, true);
    }

    public void shift(float factor, boolean updateView) {
        Scale current = this.getScale();
        Scale newScale = current.add(factor * current.getRange());
        this.setScale(newScale, updateView);
    }

    public void zoom(float factor) {
        this.zoom(factor, true);
    }

    public void zoom(float factor, boolean updateView) {
        Scale current = this.getScale();
        double range = current.getMax() - current.getMin();
        if (range <= 0.0) {
            return;
        }
        float center = (current.getMax() + current.getMin()) / 2.0f;
        float zmin = center + (current.getMin() - center) * factor;
        float zmax = center + (current.getMax() - center) * factor;
        Scale scale = null;
        if (zmin < zmax) {
            scale = new Scale(zmin, zmax);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            this.setScale(scale, updateView);
        }
    }

    public void zoomX(float factor) {
        this.zoomX(factor, true);
    }

    public void zoomX(float factor, boolean updateView) {
        double range = this.getBounds().getXmax() - this.getBounds().getXmin();
        if (range <= 0.0) {
            return;
        }
        float center = (this.getBounds().getXmax() + this.getBounds().getXmin()) / 2.0f;
        float min = center + (this.getBounds().getXmin() - center) * factor;
        float max = center + (this.getBounds().getXmax() - center) * factor;
        Scale scale = null;
        if (min < max) {
            scale = new Scale(min, max);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            BoundingBox3d bounds = this.getBounds();
            bounds.setXmin(scale.getMin());
            bounds.setXmax(scale.getMax());
            this.setBoundManual(bounds);
            if (updateView) {
                this.shoot();
            }
        }
    }

    public void zoomY(float factor) {
        this.zoomY(factor, true);
    }

    public void zoomY(float factor, boolean updateView) {
        double range = this.getBounds().getYmax() - this.getBounds().getYmin();
        if (range <= 0.0) {
            return;
        }
        float center = (this.getBounds().getYmax() + this.getBounds().getYmin()) / 2.0f;
        float min = center + (this.getBounds().getYmin() - center) * factor;
        float max = center + (this.getBounds().getYmax() - center) * factor;
        Scale scale = null;
        if (min < max) {
            scale = new Scale(min, max);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            BoundingBox3d bounds = this.getBounds();
            bounds.setYmin(scale.getMin());
            bounds.setYmax(scale.getMax());
            this.setBoundManual(bounds);
            if (updateView) {
                this.shoot();
            }
        }
    }

    public void zoomZ(float factor) {
        this.zoomZ(factor, true);
    }

    public void zoomZ(float factor, boolean updateView) {
        double range = this.getBounds().getZmax() - this.getBounds().getZmin();
        if (range <= 0.0) {
            return;
        }
        float center = (this.getBounds().getZmax() + this.getBounds().getZmin()) / 2.0f;
        float min = center + (this.getBounds().getZmin() - center) * factor;
        float max = center + (this.getBounds().getZmax() - center) * factor;
        Scale scale = null;
        if (min < max) {
            scale = new Scale(min, max);
        } else if (factor < 1.0f) {
            scale = new Scale(center, center);
        }
        if (scale != null) {
            BoundingBox3d bounds = this.getBounds();
            bounds.setZmin(scale.getMin());
            bounds.setZmax(scale.getMax());
            this.setBoundManual(bounds);
            if (updateView) {
                this.shoot();
            }
        }
    }

    public void setScale(Scale scale) {
        this.setScaleZ(scale, true);
    }

    public void setScale(Scale scale, boolean notify) {
        this.setScaleZ(scale, notify);
    }

    public void setScaleX(Scale scale) {
        this.setScaleX(scale, true);
    }

    public void setScaleX(Scale scale, boolean notify) {
        BoundingBox3d bounds = this.getBounds();
        bounds.setXmin(scale.getMin());
        bounds.setXmax(scale.getMax());
        this.setBoundManual(bounds);
        if (notify) {
            this.shoot();
        }
    }

    public void setScaleY(Scale scale) {
        this.setScaleY(scale, true);
    }

    public void setScaleY(Scale scale, boolean notify) {
        BoundingBox3d bounds = this.getBounds();
        bounds.setYmin(scale.getMin());
        bounds.setYmax(scale.getMax());
        this.setBoundManual(bounds);
        if (notify) {
            this.shoot();
        }
    }

    public void setScaleZ(Scale scale) {
        this.setScaleZ(scale, true);
    }

    public void setScaleZ(Scale scale, boolean notify) {
        BoundingBox3d bounds = this.getBounds();
        bounds.setZmin(scale.getMin());
        bounds.setZmax(scale.getMax());
        this.setBoundManual(bounds);
        if (notify) {
            this.shoot();
        }
    }

    public Scale getScale() {
        return new Scale(this.getBounds().getZmin(), this.getBounds().getZmax());
    }

    public void lookToBox(BoundingBox3d box) {
        if (box.isReset()) {
            return;
        }
        this.center = box.getCenter();
        this.axe.setAxe(box);
        this.viewbounds = box;
    }

    public Coord3d getCenter() {
        return this.center;
    }

    public BoundingBox3d getBounds() {
        return this.axe.getBoxBounds();
    }

    public ViewBoundMode getBoundsMode() {
        return this.boundmode;
    }

    public void setViewPositionMode(ViewPositionMode mode) {
        this.viewmode = mode;
    }

    public ViewPositionMode getViewMode() {
        return this.viewmode;
    }

    public void setViewPoint(Coord3d polar, boolean updateView) {
        this.viewpoint = polar;
        this.viewpoint.y = this.viewpoint.y < -1.5707964f ? -1.5707964f : this.viewpoint.y;
        float f = this.viewpoint.y = this.viewpoint.y > 1.5707964f ? 1.5707964f : this.viewpoint.y;
        if (updateView) {
            this.shoot();
        }
        this.fireViewPointChangedEvent(new ViewPointChangedEvent(this, polar));
    }

    public void setViewPoint(Coord3d polar) {
        this.setViewPoint(polar, true);
    }

    public Coord3d getViewPoint() {
        return this.viewpoint;
    }

    public Coord3d getLastViewScaling() {
        return this.scaling;
    }

    public void setAxe(IAxe ax) {
        this.axe = ax;
        this.updateBounds();
    }

    public IAxe getAxe() {
        return this.axe;
    }

    public boolean getSquared() {
        return this.squared;
    }

    public void setSquared(boolean status) {
        this.squared = status;
    }

    public boolean isAxeBoxDisplayed() {
        return this.axeBoxDisplayed;
    }

    public void setAxeBoxDisplayed(boolean axeBoxDisplayed) {
        this.axeBoxDisplayed = axeBoxDisplayed;
    }

    public void setBackgroundColor(Color color) {
        this.bgColor = color;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public Camera getCamera() {
        return this.cam;
    }

    public void setCameraMode(CameraMode mode) {
        this.cameraMode = mode;
    }

    public CameraMode getCameraMode() {
        return this.cameraMode;
    }

    public void setMaximized(boolean status) {
        if (status) {
            this.cam.setViewportMode(ViewportMode.STRETCH_TO_FILL);
        } else {
            this.cam.setViewportMode(ViewportMode.RECTANGLE_NO_STRETCH);
        }
    }

    public Scene getScene() {
        return this.scene;
    }

    public Rectangle getSceneViewportRectangle() {
        return this.cam.getRectangle();
    }

    public ICanvas getCanvas() {
        return this.canvas;
    }

    public Graph getAnnotations() {
        return this.annotations.getGraph();
    }

    public boolean addViewOnTopEventListener(IViewIsVerticalEventListener listener) {
        return this.viewOnTopListeners.add(listener);
    }

    public boolean removeViewOnTopEventListener(IViewIsVerticalEventListener listener) {
        return this.viewOnTopListeners.remove(listener);
    }

    protected void fireViewOnTopEvent(boolean isOnTop) {
        ViewIsVerticalEvent e = new ViewIsVerticalEvent(this);
        if (isOnTop) {
            for (IViewIsVerticalEventListener listener : this.viewOnTopListeners) {
                listener.viewVerticalReached(e);
            }
        } else {
            for (IViewIsVerticalEventListener listener : this.viewOnTopListeners) {
                listener.viewVerticalLeft(e);
            }
        }
    }

    public boolean addViewPointChangedListener(IViewPointChangedListener listener) {
        return this.viewPointChangedListeners.add(listener);
    }

    public boolean removeViewPointChangedListener(IViewPointChangedListener listener) {
        return this.viewPointChangedListeners.remove(listener);
    }

    protected void fireViewPointChangedEvent(ViewPointChangedEvent e) {
        for (IViewPointChangedListener vp : this.viewPointChangedListeners) {
            vp.viewPointChanged(e);
        }
    }

    public boolean addViewLifecycleChangedListener(IViewLifecycleEventListener listener) {
        return this.viewLifecycleListeners.add(listener);
    }

    public boolean removeViewLifecycleChangedListener(IViewLifecycleEventListener listener) {
        return this.viewLifecycleListeners.remove(listener);
    }

    protected void fireViewLifecycleHasInit(ViewLifecycleEvent e) {
        for (IViewLifecycleEventListener vp : this.viewLifecycleListeners) {
            vp.viewHasInit(e);
        }
    }

    protected void fireViewLifecycleWillRender(ViewLifecycleEvent e) {
        for (IViewLifecycleEventListener vp : this.viewLifecycleListeners) {
            vp.viewWillRender(e);
        }
    }

    public void setBoundMode(ViewBoundMode mode) {
        this.boundmode = mode;
        this.updateBounds();
    }

    public void updateBounds() {
        if (this.boundmode == ViewBoundMode.AUTO_FIT) {
            this.lookToBox(this.getSceneGraphBounds());
        } else if (this.boundmode == ViewBoundMode.MANUAL) {
            this.lookToBox(this.viewbounds);
        } else {
            throw new RuntimeException("Unknown bounds");
        }
        this.shoot();
    }

    protected BoundingBox3d getSceneGraphBounds() {
        return this.getSceneGraphBounds(this.scene);
    }

    protected BoundingBox3d getSceneGraphBounds(Scene scene) {
        return scene.getGraph().getBounds();
    }

    public void updateBoundsForceUpdate(boolean refresh) {
        this.lookToBox(this.getSceneGraphBounds());
        if (refresh) {
            this.shoot();
        }
    }

    public void setBoundManual(BoundingBox3d bounds) {
        this.boundmode = ViewBoundMode.MANUAL;
        this.lookToBox(bounds);
    }

    public GL getCurrentGL() {
        this.getCurrentContext().makeCurrent();
        return this.getCanvasAsGLAutoDrawable().getGL().getGL2();
    }

    public GLContext getCurrentContext() {
        GLAutoDrawable c = this.getCanvasAsGLAutoDrawable();
        GLContext context = c.getContext();
        return context;
    }

    protected GLAutoDrawable getCanvasAsGLAutoDrawable() {
        if (this.canvas instanceof GLAutoDrawable) {
            return (GLAutoDrawable)this.canvas;
        }
        if (this.canvas.getDrawable() instanceof GLAutoDrawable) {
            return (GLAutoDrawable)this.canvas.getDrawable();
        }
        throw new RuntimeException("Unexpected instance type : " + this.canvas.getClass().toString());
    }

    public void init(GL gl) {
        this.initQuality(gl);
        this.initLights(gl);
        this.initResources(gl);
        this.initBounds(this.scene, this.viewbounds, this.initBounds);
        this.fireViewLifecycleHasInit(null);
    }

    protected void initBounds(Scene scene, BoundingBox3d viewbounds, BoundingBox3d initBounds) {
        if (viewbounds == null) {
            if (initBounds == null) {
                this.setBoundManual(scene.getGraph().getBounds());
            } else {
                this.setBoundManual(initBounds);
            }
        } else {
            this.lookToBox(viewbounds);
        }
    }

    public BoundingBox3d getInitBounds() {
        return this.initBounds;
    }

    public void setInitBounds(BoundingBox3d initBounds) {
        this.initBounds = initBounds;
    }

    public void initQuality(GL gl) {
        if (this.quality.isDepthActivated()) {
            gl.glEnable(2929);
            gl.glDepthFunc(515);
        } else {
            gl.glDisable(2929);
        }
        gl.glBlendFunc(770, 771);
        if (this.quality.isAlphaActivated()) {
            gl.glEnable(3008);
            if (this.quality.isDisableDepthBufferWhenAlpha()) {
                gl.glDisable(2929);
            }
        } else {
            gl.glDisable(3008);
        }
        if (gl.isGL2()) {
            if (this.quality.isSmoothColor()) {
                gl.getGL2().glShadeModel(7425);
            } else {
                gl.getGL2().glShadeModel(7424);
            }
        }
        if (this.quality.isSmoothPolygon()) {
            gl.glEnable(2881);
            gl.glHint(3155, 4354);
        } else {
            gl.glDisable(2881);
        }
        if (this.quality.isSmoothLine()) {
            gl.glEnable(2848);
            gl.glHint(3154, 4354);
        } else {
            gl.glDisable(2848);
        }
        if (this.quality.isSmoothPoint()) {
            gl.glEnable(2832);
            gl.glHint(3153, 4354);
        } else {
            gl.glDisable(2832);
        }
    }

    public void initLights(GL gl) {
        this.initLights(gl, this.scene);
    }

    public void initLights(GL gl, Scene scene) {
        scene.getLightSet().init(gl);
        scene.getLightSet().enableLightIfThereAreLights(gl);
    }

    public void initResources(GL gl) {
        this.getScene().getGraph().mountAllGLBindedResources(gl);
    }

    public void clear(GL gl) {
        this.clearColorAndDepth(gl);
    }

    public void clearColorAndDepth(GL gl) {
        gl.glClearColor(this.bgColor.r, this.bgColor.g, this.bgColor.b, this.bgColor.a);
        gl.glClearDepth(1.0);
        if (this.slave) {
            return;
        }
        gl.glClear(16640);
    }

    public void render(GL gl, GLU glu) {
        this.fireViewLifecycleWillRender(null);
        this.renderBackground(gl, glu, 0.0f, 1.0f);
        this.renderScene(gl, glu);
        this.renderOverlay(gl);
        if (this.dimensionDirty) {
            this.dimensionDirty = false;
        }
        this.cam.show(gl, new Transform(new org.jzy3d.plot3d.transform.Scale(this.scaling)), this.scaling);
    }

    public void renderBackground(GL gl, GLU glu2, float f, float g) {
    }

    public void renderBackground(GL gl, GLU glu2, ViewportConfiguration backgroundViewPort) {
    }

    public void renderScene(GL gl, GLU glu) {
        this.renderScene(gl, glu, new ViewportConfiguration(this.canvas.getRendererWidth(), this.canvas.getRendererHeight()));
    }

    public void renderScene(GL gl, GLU glu, float left, float right) {
        ViewportConfiguration vc = ViewportBuilder.column(this.canvas.getRendererWidth(), this.canvas.getRendererHeight(), left, right);
        this.renderScene(gl, glu, vc);
    }

    public void renderScene(GL gl, GLU glu, ViewportConfiguration viewport) {
        this.updateQuality(gl);
        BoundingBox3d scaling = this.computeScaledViewBounds();
        this.updateCamera(gl, glu, viewport, scaling);
        this.renderAxeBox(gl, glu);
        this.renderSceneGraph(gl, glu);
        this.renderAnnotations(gl, glu, this.cam);
    }

    public void updateQuality(GL gl) {
        if (this.quality.isAlphaActivated()) {
            gl.glEnable(3042);
        } else {
            gl.glDisable(3042);
        }
    }

    protected Coord3d squarify() {
        return this.squarify(this.scene, this.boundmode, this.viewbounds, this.spaceTransformer);
    }

    protected Coord3d squarify(Scene scene, ViewBoundMode boundmode, BoundingBox3d viewbounds, SpaceTransformer spaceTransformer) {
        BoundingBox3d bounds;
        if (boundmode == ViewBoundMode.AUTO_FIT) {
            bounds = scene.getGraph().getBounds();
        } else if (boundmode == ViewBoundMode.MANUAL) {
            bounds = viewbounds;
        } else {
            throw new RuntimeException("Unknown bounds mode");
        }
        float xLen = 1.0f;
        float yLen = 1.0f;
        float zLen = 1.0f;
        float lmax = 1.0f;
        if (bounds != null) {
            Coord3d range = this.squarifyComputeBoundsRanges(bounds);
            xLen = range.x;
            yLen = range.y;
            zLen = range.z;
            lmax = Math.max(Math.max(xLen, yLen), zLen);
        }
        if (Float.isInfinite(xLen) || Float.isNaN(xLen) || xLen == 0.0f) {
            xLen = 1.0f;
        }
        if (Float.isInfinite(yLen) || Float.isNaN(yLen) || yLen == 0.0f) {
            yLen = 1.0f;
        }
        if (Float.isInfinite(zLen) || Float.isNaN(zLen) || zLen == 0.0f) {
            zLen = 1.0f;
        }
        if (Float.isInfinite(lmax) || Float.isNaN(lmax) || lmax == 0.0f) {
            lmax = 1.0f;
        }
        float xscale = (float)((double)lmax / (double)xLen);
        float yscale = (float)((double)lmax / (double)yLen);
        float zscale = (float)((double)lmax / (double)zLen);
        return new Coord3d(xscale, yscale, zscale);
    }

    protected Coord3d squarifyComputeBoundsRanges(BoundingBox3d bounds) {
        return bounds.getRange();
    }

    public BoundingBox3d computeScaledViewBounds() {
        this.scaling = this.computeSceneScaling();
        if (this.viewbounds == null) {
            this.viewbounds = new BoundingBox3d(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f);
        }
        BoundingBox3d boundsScaled = new BoundingBox3d();
        boundsScaled.add(this.viewbounds.scale(this.scaling));
        if (this.MAINTAIN_ALL_OBJECTS_IN_VIEW) {
            boundsScaled.add(this.getSceneGraphBounds().scale(this.scaling));
        }
        return boundsScaled;
    }

    public Coord3d computeSceneScaling() {
        return this.computeSceneScaling(this.scene, this.squared, this.boundmode, this.viewbounds, this.spaceTransformer);
    }

    public Coord3d computeSceneScaling(Scene scene, boolean squared, ViewBoundMode boundmode, BoundingBox3d viewbounds, SpaceTransformer spaceTransformer) {
        if (squared) {
            return this.squarify(scene, boundmode, viewbounds, spaceTransformer);
        }
        return Coord3d.IDENTITY.clone();
    }

    public void updateCamera(GL gl, GLU glu, ViewportConfiguration viewport, BoundingBox3d boundsScaled) {
        float sceneRadius = (float)boundsScaled.getRadius() * this.factorViewPointDistance;
        this.updateCamera(gl, glu, viewport, boundsScaled, sceneRadius);
    }

    public void updateCamera(GL gl, GLU glu, ViewportConfiguration viewport, BoundingBox3d bounds, float sceneRadiusScaled) {
        this.updateCamera(gl, glu, viewport, bounds, sceneRadiusScaled, this.viewmode, this.viewpoint, this.cam, this.cameraMode, this.factorViewPointDistance, this.center, this.scaling);
    }

    public void updateCamera(GL gl, GLU glu, ViewportConfiguration viewport, BoundingBox3d bounds, float sceneRadiusScaled, ViewPositionMode viewmode, Coord3d viewpoint, Camera cam, CameraMode cameraMode, float factorViewPointDistance, Coord3d center, Coord3d scaling) {
        viewpoint.z = sceneRadiusScaled * factorViewPointDistance;
        cam.setTarget(this.computeCameraTarget(center, scaling));
        cam.setUp(this.computeCameraUpAndTriggerEvents(viewpoint));
        cam.setEye(this.computeCameraEye(cam.getTarget(), viewmode, viewpoint));
        this.computeCameraRenderingSphereRadius(cam, gl, glu, viewport, bounds);
        cam.setViewPort(viewport);
        cam.shoot(gl, glu, cameraMode);
    }

    protected Coord3d computeCameraTarget() {
        return this.computeCameraTarget(this.center, this.scaling);
    }

    protected Coord3d computeCameraEye(Coord3d target) {
        return this.computeCameraEye(target, this.viewmode, this.viewpoint);
    }

    protected Coord3d computeCameraTarget(Coord3d center, Coord3d scaling) {
        return center.mul(scaling);
    }

    protected Coord3d computeCameraEye(Coord3d target, ViewPositionMode viewmode, Coord3d viewpoint) {
        if (viewmode == ViewPositionMode.FREE) {
            return this.computeCameraEyeFree(viewpoint, target);
        }
        if (viewmode == ViewPositionMode.TOP) {
            return this.computeCameraEyeTop(viewpoint, target);
        }
        if (viewmode == ViewPositionMode.PROFILE) {
            return this.computeCameraEyeProfile(viewpoint, target);
        }
        throw new RuntimeException("Unsupported ViewMode: " + (Object)((Object)viewmode));
    }

    protected Coord3d computeCameraEyeProfile(Coord3d viewpoint, Coord3d target) {
        Coord3d eye = viewpoint;
        eye.y = 0.0f;
        eye = eye.cartesian().add(target);
        return eye;
    }

    protected Coord3d computeCameraEyeTop(Coord3d viewpoint, Coord3d target) {
        Coord3d eye = viewpoint;
        eye.x = -1.5707964f;
        eye.y = 1.5707964f;
        eye = eye.cartesian().add(target);
        return eye;
    }

    protected Coord3d computeCameraEyeFree(Coord3d viewpoint, Coord3d target) {
        return viewpoint.cartesian().add(target);
    }

    protected Coord3d computeCameraUpAndTriggerEvents() {
        return this.computeCameraUpAndTriggerEvents(this.viewpoint);
    }

    protected Coord3d computeCameraUpAndTriggerEvents(Coord3d viewpoint) {
        Coord3d up;
        if (Math.abs(viewpoint.y) == 1.5707964f) {
            up = this.computeCameraUp();
            if (!this.wasOnTopAtLastRendering) {
                this.wasOnTopAtLastRendering = true;
                this.fireViewOnTopEvent(true);
            }
        } else {
            up = new Coord3d(0.0f, 0.0f, 1.0f);
            if (this.wasOnTopAtLastRendering) {
                this.wasOnTopAtLastRendering = false;
                this.fireViewOnTopEvent(false);
            }
        }
        return up;
    }

    protected Coord3d computeCameraUp() {
        Coord2d direction = new Coord2d(this.viewpoint.x, this.viewpoint.z).cartesian();
        Coord3d up = this.viewpoint.y > 0.0f ? new Coord3d(-direction.x, -direction.y, 0.0f) : new Coord3d(direction.x, direction.y, 0.0f);
        return up;
    }

    protected void computeCameraRenderingSphereRadius(Camera cam, GL gl, GLU glu, ViewportConfiguration viewport, BoundingBox3d bounds) {
        if (this.viewmode == ViewPositionMode.TOP) {
            float xdiam = bounds.getXRange().getRange();
            float ydiam = bounds.getYRange().getRange();
            float radius = Math.max(xdiam, ydiam) / 2.0f;
            cam.setRenderingSphereRadius(radius);
            this.correctCameraPositionForIncludingTextLabels(gl, glu, viewport);
        } else {
            cam.setRenderingSphereRadius((float)bounds.getRadius());
        }
    }

    protected void correctCameraPositionForIncludingTextLabels(GL gl, GLU glu, ViewportConfiguration viewport) {
    }

    protected void renderAxeBox(GL gl, GLU glu) {
        this.renderAxeBox(gl, glu, this.axe, this.scene, this.cam, this.scaling, this.axeBoxDisplayed);
    }

    protected void renderAxeBox(GL gl, GLU glu, IAxe axe, Scene scene, Camera camera, Coord3d scaling, boolean axeBoxDisplayed) {
        if (axeBoxDisplayed) {
            this.glModelView(gl);
            scene.getLightSet().disable(gl);
            axe.setScale(scaling);
            axe.draw(gl, glu, camera);
            scene.getLightSet().enableLightIfThereAreLights(gl);
        }
    }

    protected void glModelView(GL gl) {
        if (gl.isGL2()) {
            gl.getGL2().glMatrixMode(5888);
        } else {
            GLES2CompatUtils.glMatrixMode(5888);
        }
    }

    public void renderSceneGraph(GL gl, GLU glu) {
        this.renderSceneGraph(gl, glu, true);
    }

    public void renderSceneGraph(GL gl, GLU glu, boolean light) {
        this.renderSceneGraph(gl, glu, light, this.cam, this.scene, this.scaling);
    }

    public void renderSceneGraph(GL gl, GLU glu, boolean light, Camera camera, Scene scene, Coord3d scaling) {
        if (light) {
            scene.getLightSet().apply(gl, scaling);
        }
        Transform transform = new Transform(new org.jzy3d.plot3d.transform.Scale(scaling));
        scene.getGraph().setTransform(transform);
        scene.getGraph().draw(gl, glu, camera);
    }

    public void renderOverlay(GL gl) {
        this.renderOverlay(gl, new ViewportConfiguration(this.canvas));
    }

    public void renderOverlay(GL gl, ViewportConfiguration viewportConfiguration) {
    }

    public void renderAnnotations(GL gl, GLU glu, Camera camera) {
        Transform transform = new Transform(new org.jzy3d.plot3d.transform.Scale(this.scaling));
        this.annotations.getGraph().setTransform(transform);
        this.annotations.getGraph().draw(gl, glu, camera);
    }

    public static View current() {
        return current;
    }

    public SpaceTransformer getSpaceTransformer() {
        return this.spaceTransformer;
    }

    public void setSpaceTransformer(SpaceTransformer transformer) {
        this.spaceTransformer = transformer;
    }
}

