/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.AbstractTextRenderer;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

public class TextBillboardRenderer
extends AbstractTextRenderer
implements ITextRenderer {
    private static int charHeight = 13;
    private static int charWidth = 8;
    private static int charOffset = 2;
    private static byte[][] ascii = new byte[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 24, 24, 0, 0, 24, 24, 24, 24, 24, 24, 24}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 54, 54, 54}, {0, 0, 0, 102, 102, -1, 102, 102, -1, 102, 102, 0, 0}, {0, 0, 24, 126, -1, 27, 31, 126, -8, -40, -1, 126, 24}, {0, 0, 14, 27, -37, 110, 48, 24, 12, 118, -37, -40, 112}, {0, 0, 127, -58, -49, -40, 112, 112, -40, -52, -52, 108, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 28, 12, 14}, {0, 0, 12, 24, 48, 48, 48, 48, 48, 48, 48, 24, 12}, {0, 0, 48, 24, 12, 12, 12, 12, 12, 12, 12, 24, 48}, {0, 0, 0, 0, -103, 90, 60, -1, 60, 90, -103, 0, 0}, {0, 0, 0, 24, 24, 24, -1, -1, 24, 24, 24, 0, 0}, {0, 0, 48, 24, 28, 28, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0}, {0, 0, 0, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 96, 96, 48, 48, 24, 24, 12, 12, 6, 6, 3, 3}, {0, 0, 60, 102, -61, -29, -13, -37, -49, -57, -61, 102, 60}, {0, 0, 126, 24, 24, 24, 24, 24, 24, 24, 120, 56, 24}, {0, 0, -1, -64, -64, 96, 48, 24, 12, 6, 3, -25, 126}, {0, 0, 126, -25, 3, 3, 7, 126, 7, 3, 3, -25, 126}, {0, 0, 12, 12, 12, 12, 12, -1, -52, 108, 60, 28, 12}, {0, 0, 126, -25, 3, 3, 7, -2, -64, -64, -64, -64, -1}, {0, 0, 126, -25, -61, -61, -57, -2, -64, -64, -64, -25, 126}, {0, 0, 48, 48, 48, 48, 24, 12, 6, 3, 3, 3, -1}, {0, 0, 126, -25, -61, -61, -25, 126, -25, -61, -61, -25, 126}, {0, 0, 126, -25, 3, 3, 3, 127, -25, -61, -61, -25, 126}, {0, 0, 0, 56, 56, 0, 0, 56, 56, 0, 0, 0, 0}, {0, 0, 48, 24, 28, 28, 0, 0, 28, 28, 0, 0, 0}, {0, 0, 6, 12, 24, 48, 96, -64, 96, 48, 24, 12, 6}, {0, 0, 0, 0, -1, -1, 0, -1, -1, 0, 0, 0, 0}, {0, 0, 96, 48, 24, 12, 6, 3, 6, 12, 24, 48, 96}, {0, 0, 24, 0, 0, 24, 24, 12, 6, 3, -61, -61, 126}, {0, 0, 63, 96, -49, -37, -45, -35, -61, 126, 0, 0, 0}, {0, 0, -61, -61, -61, -61, -1, -61, -61, -61, 102, 60, 24}, {0, 0, -2, -57, -61, -61, -57, -2, -57, -61, -61, -57, -2}, {0, 0, 126, -25, -64, -64, -64, -64, -64, -64, -64, -25, 126}, {0, 0, -4, -50, -57, -61, -61, -61, -61, -61, -57, -50, -4}, {0, 0, -1, -64, -64, -64, -64, -4, -64, -64, -64, -64, -1}, {0, 0, -64, -64, -64, -64, -64, -64, -4, -64, -64, -64, -1}, {0, 0, 126, -25, -61, -61, -49, -64, -64, -64, -64, -25, 126}, {0, 0, -61, -61, -61, -61, -61, -1, -61, -61, -61, -61, -61}, {0, 0, 126, 24, 24, 24, 24, 24, 24, 24, 24, 24, 126}, {0, 0, 124, -18, -58, 6, 6, 6, 6, 6, 6, 6, 6}, {0, 0, -61, -58, -52, -40, -16, -32, -16, -40, -52, -58, -61}, {0, 0, -1, -64, -64, -64, -64, -64, -64, -64, -64, -64, -64}, {0, 0, -61, -61, -61, -61, -61, -61, -37, -1, -1, -25, -61}, {0, 0, -57, -57, -49, -49, -33, -37, -5, -13, -13, -29, -29}, {0, 0, 126, -25, -61, -61, -61, -61, -61, -61, -61, -25, 126}, {0, 0, -64, -64, -64, -64, -64, -2, -57, -61, -61, -57, -2}, {0, 0, 63, 110, -33, -37, -61, -61, -61, -61, -61, 102, 60}, {0, 0, -61, -58, -52, -40, -16, -2, -57, -61, -61, -57, -2}, {0, 0, 126, -25, 3, 3, 7, 126, -32, -64, -64, -25, 126}, {0, 0, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, -1}, {0, 0, 126, -25, -61, -61, -61, -61, -61, -61, -61, -61, -61}, {0, 0, 24, 60, 60, 102, 102, -61, -61, -61, -61, -61, -61}, {0, 0, -61, -25, -1, -1, -37, -37, -61, -61, -61, -61, -61}, {0, 0, -61, 102, 102, 60, 60, 24, 60, 60, 102, 102, -61}, {0, 0, 24, 24, 24, 24, 24, 24, 60, 60, 102, 102, -61}, {0, 0, -1, -64, -64, 96, 48, 126, 12, 6, 3, 3, -1}, {0, 0, 60, 48, 48, 48, 48, 48, 48, 48, 48, 48, 60}, {0, 3, 3, 6, 6, 12, 12, 24, 24, 48, 48, 96, 96}, {0, 0, 60, 12, 12, 12, 12, 12, 12, 12, 12, 12, 60}, {0, 0, 0, 0, 0, 0, 0, 0, 0, -61, 102, 60, 24}, {-1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 56, 48, 112}, {0, 0, 127, -61, -61, 127, 3, -61, 126, 0, 0, 0, 0}, {0, 0, -2, -61, -61, -61, -61, -2, -64, -64, -64, -64, -64}, {0, 0, 126, -61, -64, -64, -64, -61, 126, 0, 0, 0, 0}, {0, 0, 127, -61, -61, -61, -61, 127, 3, 3, 3, 3, 3}, {0, 0, 127, -64, -64, -2, -61, -61, 126, 0, 0, 0, 0}, {0, 0, 48, 48, 48, 48, 48, -4, 48, 48, 48, 51, 30}, {126, -61, 3, 3, 127, -61, -61, -61, 126, 0, 0, 0, 0}, {0, 0, -61, -61, -61, -61, -61, -61, -2, -64, -64, -64, -64}, {0, 0, 24, 24, 24, 24, 24, 24, 24, 0, 0, 24, 0}, {56, 108, 12, 12, 12, 12, 12, 12, 12, 0, 0, 12, 0}, {0, 0, -58, -52, -8, -16, -40, -52, -58, -64, -64, -64, -64}, {0, 0, 126, 24, 24, 24, 24, 24, 24, 24, 24, 24, 120}, {0, 0, -37, -37, -37, -37, -37, -37, -2, 0, 0, 0, 0}, {0, 0, -58, -58, -58, -58, -58, -58, -4, 0, 0, 0, 0}, {0, 0, 124, -58, -58, -58, -58, -58, 124, 0, 0, 0, 0}, {-64, -64, -64, -2, -61, -61, -61, -61, -2, 0, 0, 0, 0}, {3, 3, 3, 127, -61, -61, -61, -61, 127, 0, 0, 0, 0}, {0, 0, -64, -64, -64, -64, -64, -32, -2, 0, 0, 0, 0}, {0, 0, -2, 3, 3, 126, -64, -64, 127, 0, 0, 0, 0}, {0, 0, 28, 54, 48, 48, 48, 48, -4, 48, 48, 48, 0}, {0, 0, 126, -58, -58, -58, -58, -58, -58, 0, 0, 0, 0}, {0, 0, 24, 60, 60, 102, 102, -61, -61, 0, 0, 0, 0}, {0, 0, -61, -25, -1, -37, -61, -61, -61, 0, 0, 0, 0}, {0, 0, -61, 102, 60, 24, 60, 102, -61, 0, 0, 0, 0}, {-64, 96, 96, 48, 24, 60, 102, 102, -61, 0, 0, 0, 0}, {0, 0, -1, 96, 48, 24, 12, 6, -1, 0, 0, 0, 0}, {0, 0, 15, 24, 24, 24, 56, -16, 56, 24, 24, 24, 15}, {24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24}, {0, 0, -16, 24, 24, 24, 28, 15, 28, 24, 24, 24, -16}, {0, 0, 0, 0, 0, 0, 6, -113, -15, 96, 0, 0, 0}};
    private static byte[] nonascii = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    @Override
    public void drawSimpleText(GL gl, GLU glu, Camera cam, String s, Coord3d position, Color color) {
        this.glRaster(gl, position, color);
        this.printString(gl, s, Halign.RIGHT, Valign.GROUND);
    }

    public void drawText(GL gl, String s, Coord3d position, Halign halign, Valign valign, Color color) {
    }

    @Override
    public BoundingBox3d drawText(GL gl, GLU glu, Camera cam, String s, Coord3d position, Halign halign, Valign valign, Color color, Coord2d screenOffset, Coord3d sceneOffset) {
        this.glRaster(gl, position, color);
        BillBoardSize dims = this.printString(gl, s, halign, valign);
        BoundingBox3d txtBounds = this.computeTextBounds(gl, glu, cam, position, dims);
        return txtBounds;
    }

    public void glRaster(GL gl, Coord3d position, Color color) {
        if (gl.isGL2()) {
            gl.getGL2().glColor3f(color.r, color.g, color.b);
            gl.getGL2().glRasterPos3f(position.x, position.y, position.z);
        } else {
            GLES2CompatUtils.glColor3f(color.r, color.g, color.b);
            GLES2CompatUtils.glRasterPos3f(position.x, position.y, position.z);
        }
    }

    public BoundingBox3d computeTextBounds(GL gl, GLU glu, Camera cam, Coord3d position, BillBoardSize dims) {
        Coord3d posScreen = cam.modelToScreen(gl, glu, position);
        Coord3d botLeft = new Coord3d();
        Coord3d topRight = new Coord3d();
        botLeft.x = posScreen.x + dims.xoffset;
        botLeft.y = posScreen.y + dims.yoffset;
        botLeft.z = posScreen.z;
        topRight.x = botLeft.x + dims.width;
        topRight.y = botLeft.y + dims.height;
        topRight.z = botLeft.z;
        BoundingBox3d txtBounds = new BoundingBox3d();
        txtBounds.add(cam.screenToModel(gl, glu, botLeft));
        txtBounds.add(cam.screenToModel(gl, glu, topRight));
        return txtBounds;
    }

    private BillBoardSize printString(GL gl, String s, Halign halign, Valign valign) {
        byte[] acodes = s.getBytes();
        int nchar = s.length();
        float xorig = 0.0f;
        float yorig = 2.0f;
        float xmove = charWidth + charOffset;
        float ymove = 0.0f;
        if (halign != Halign.RIGHT) {
            if (halign == Halign.CENTER) {
                xorig = (float)nchar * xmove / 2.0f;
            } else if (halign == Halign.LEFT) {
                xorig = (float)nchar * xmove;
            } else {
                throw new IllegalArgumentException("Horizontal alignement constant unknown: " + (Object)((Object)halign));
            }
        }
        if (valign == Valign.TOP) {
            yorig = 0.0f;
        } else if (valign != Valign.GROUND) {
            if (valign == Valign.CENTER) {
                yorig = charHeight / 2;
            } else if (valign == Valign.BOTTOM) {
                yorig = charHeight;
            } else {
                throw new IllegalArgumentException("Vertical alignement constant unknown: " + (Object)((Object)valign));
            }
        }
        gl.glPixelStorei(3317, 1);
        for (int c = 0; c < acodes.length; ++c) {
            int idx = acodes[c] - 32;
            if (idx < 0 || idx > ascii.length) {
                this.glBitmap(gl, charWidth, charHeight, xorig, yorig, xmove, ymove, nonascii, 0);
                continue;
            }
            this.glBitmap(gl, charWidth, charHeight, xorig, yorig, xmove, ymove, ascii[idx], 0);
        }
        return new BillBoardSize(xmove * (float)nchar, charHeight, -xorig, -yorig);
    }

    private void glBitmap(GL gl, int charWidth2, int charHeight2, float xorig, float yorig, float xmove, float ymove, byte[] nonascii2, int i) {
        if (gl.isGL2()) {
            gl.getGL2().glBitmap(charWidth, charHeight, xorig, yorig, xmove, ymove, nonascii, 0);
        } else {
            GLES2CompatUtils.glBitmap(charWidth, charHeight, xorig, yorig, xmove, ymove, nonascii, 0);
        }
    }

    private class BillBoardSize {
        float width;
        float height;
        float xoffset;
        float yoffset;

        BillBoardSize(float width, float height, float xoffset, float yoffset) {
            this.width = width;
            this.height = height;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }
    }
}

