/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import org.apache.log4j.Logger;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.AbstractTextRenderer;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

public class TextBitmapRenderer
extends AbstractTextRenderer
implements ITextRenderer {
    protected static Logger LOGGER = Logger.getLogger(TextBitmapRenderer.class);
    protected static GLUT glut = new GLUT();
    protected int fontHeight;
    protected int font;

    public TextBitmapRenderer() {
        this(Font.Helvetica_10);
    }

    public TextBitmapRenderer(Font font) {
        this(font.code, font.height);
    }

    public TextBitmapRenderer(int font, int fontSize) {
        this.font = font;
        this.fontHeight = fontSize;
    }

    @Override
    public void drawSimpleText(GL gl, GLU glu, Camera cam, String s, Coord3d position, Color color) {
        if (gl.isGL2()) {
            gl.getGL2().glColor3f(color.r, color.g, color.b);
            gl.getGL2().glRasterPos3f(position.x, position.y, position.z);
        } else {
            GLES2CompatUtils.glColor3f(color.r, color.g, color.b);
            GLES2CompatUtils.glRasterPos3f(position.x, position.y, position.z);
        }
        glut.glutBitmapString(this.font, s);
    }

    @Override
    public BoundingBox3d drawText(GL gl, GLU glu, Camera cam, String text, Coord3d position, Halign halign, Valign valign, Color color, Coord2d screenOffset, Coord3d sceneOffset) {
        Coord3d posReal;
        this.color(gl, color);
        Coord3d posScreen = cam.modelToScreen(gl, glu, position);
        float strlen = glut.glutBitmapLength(this.font, text);
        float x = this.computeXWithAlign(halign, posScreen, strlen, 0.0f);
        float y = this.computeYWithAlign(valign, posScreen, 0.0f);
        Coord3d posScreenShifted = new Coord3d(x + screenOffset.x, y + screenOffset.y, posScreen.z);
        try {
            posReal = cam.screenToModel(gl, glu, posScreenShifted);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("TextBitmap.drawText(): could not process text position: " + posScreen + " " + posScreenShifted));
            return new BoundingBox3d();
        }
        this.glRasterPos(gl, sceneOffset, posReal);
        glut.glutBitmapString(this.font, text);
        return this.computeTextBounds(gl, glu, cam, posScreenShifted, strlen);
    }

    public void glRasterPos(GL gl, Coord3d sceneOffset, Coord3d posReal) {
        if (gl.isGL2()) {
            gl.getGL2().glRasterPos3f(posReal.x + sceneOffset.x, posReal.y + sceneOffset.y, posReal.z + sceneOffset.z);
        } else {
            GLES2CompatUtils.glRasterPos3f(posReal.x + sceneOffset.x, posReal.y + sceneOffset.y, posReal.z + sceneOffset.z);
        }
    }

    public BoundingBox3d computeTextBounds(GL gl, GLU glu, Camera cam, Coord3d posScreenShifted, float strlen) {
        Coord3d botLeft = new Coord3d();
        Coord3d topRight = new Coord3d();
        botLeft.x = posScreenShifted.x;
        botLeft.y = posScreenShifted.y;
        botLeft.z = posScreenShifted.z;
        topRight.x = botLeft.x + strlen;
        topRight.y = botLeft.y + (float)this.fontHeight;
        topRight.z = botLeft.z;
        BoundingBox3d txtBounds = new BoundingBox3d();
        txtBounds.add(cam.screenToModel(gl, glu, botLeft));
        txtBounds.add(cam.screenToModel(gl, glu, topRight));
        return txtBounds;
    }

    public void color(GL gl, Color color) {
        if (gl.isGL2()) {
            gl.getGL2().glColor3f(color.r, color.g, color.b);
        } else {
            GLES2CompatUtils.glColor3f(color.r, color.g, color.b);
        }
    }

    public float computeYWithAlign(Valign valign, Coord3d posScreen, float y) {
        if (valign == Valign.TOP) {
            y = posScreen.y;
        } else if (valign == Valign.GROUND) {
            y = posScreen.y;
        } else if (valign == Valign.CENTER) {
            y = posScreen.y - (float)(this.fontHeight / 2);
        } else if (valign == Valign.BOTTOM) {
            y = posScreen.y - (float)this.fontHeight;
        }
        return y;
    }

    public float computeXWithAlign(Halign halign, Coord3d posScreen, float strlen, float x) {
        if (halign == Halign.RIGHT) {
            x = posScreen.x;
        } else if (halign == Halign.CENTER) {
            x = posScreen.x - strlen / 2.0f;
        } else if (halign == Halign.LEFT) {
            x = posScreen.x - strlen;
        }
        return x;
    }

    public static enum Font {
        Helvetica_10(6, 10),
        Helvetica_12(7, 12),
        Helvetica_18(8, 18),
        TimesRoman_10(4, 10),
        TimesRoman_24(5, 24);

        protected int code;
        protected int height;

        private Font(int code, int height) {
            this.code = code;
            this.height = height;
        }
    }
}

