/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.ui.editors;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jzy3d.maths.Range;

public class Coord3dEditor
extends JPanel {
    protected JSlider[] sliders = new JSlider[3];
    private static final long serialVersionUID = 3090387949522460142L;

    public Coord3dEditor(String name, Range xscale, Range yscale, Range zscale) {
        this.setLayout(new GridLayout(4, 1));
        this.sliders[0] = this.createSlider("X", (int)xscale.getMin(), (int)xscale.getMax());
        this.sliders[1] = this.createSlider("Y", (int)yscale.getMin(), (int)yscale.getMax());
        this.sliders[2] = this.createSlider("Z", (int)zscale.getMin(), (int)zscale.getMax());
        this.add(new JLabel(name));
        this.add(this.sliders[0]);
        this.add(this.sliders[1]);
        this.add(this.sliders[2]);
    }

    protected JSlider createSlider(String title, int min, int max) {
        if (min == max) {
            min = -1;
            max = 2;
        }
        JSlider slider = new JSlider();
        slider.setMinimum(min);
        slider.setMaximum(max);
        slider.setMajorTickSpacing((max - min) / 5);
        slider.setMinorTickSpacing(max - min);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        return slider;
    }

    public JSlider getSlider(int i) {
        return this.sliders[i];
    }
}

