/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.utils;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LoggerUtils {
    public static void maximal() {
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)new ConsoleAppender((Layout)LoggerUtils.makeConsoleLayout()));
        LoggerUtils.level(Level.INFO);
    }

    public static void minimal() {
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)new ConsoleAppender((Layout)LoggerUtils.makeConsoleLayout()));
        LoggerUtils.level(Level.ERROR);
    }

    private static PatternLayout makeConsoleLayout() {
        return new PatternLayout("%-5p [%t][%c]: %m%n");
    }

    public static void minimalDated() {
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%-5p [%t][%c][%d{HH:mm:ss}]: %m%n")));
        LoggerUtils.level(Level.ERROR);
    }

    public static void level(Level level) {
        Logger root = Logger.getRootLogger();
        Logger pkgLogger = root.getLoggerRepository().getLogger("com.jzy3d");
        pkgLogger.setLevel(level);
    }

    public static void setFileLogger(String file) throws IOException {
        Logger root = Logger.getRootLogger();
        root.addAppender((Appender)new FileAppender((Layout)LoggerUtils.makeConsoleLayout(), new File(file).getAbsolutePath(), false));
    }
}

