/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioMetaData;
import ddf.minim.AudioSource;
import ddf.minim.Minim;
import ddf.minim.Playable;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioRecordingStream;

public class AudioPlayer
extends AudioSource
implements Playable {
    private AudioRecordingStream recording;
    private AudioOut output;

    public AudioPlayer(AudioRecordingStream audioRecordingStream, AudioOut audioOut) {
        super(audioOut);
        this.recording = audioRecordingStream;
        this.output = audioOut;
        this.output.setAudioStream(audioRecordingStream);
    }

    @Override
    public void play() {
        this.recording.play();
    }

    @Override
    public void play(int n) {
        this.cue(n);
        this.play();
    }

    @Override
    public void pause() {
        this.recording.pause();
    }

    @Override
    public void rewind() {
        this.cue(0);
    }

    @Override
    public void loop(int n) {
        this.recording.loop(n);
    }

    @Override
    public void loop() {
        this.recording.loop(-1);
    }

    @Override
    public int loopCount() {
        return this.recording.getLoopCount();
    }

    @Override
    public int length() {
        return this.recording.getMillisecondLength();
    }

    @Override
    public int position() {
        return this.recording.getMillisecondPosition();
    }

    @Override
    public void cue(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.length()) {
            n = this.length();
        }
        this.recording.setMillisecondPosition(n);
    }

    @Override
    public void skip(int n) {
        int n2 = this.position() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.length()) {
            n2 = this.length();
        }
        Minim.debug("AudioPlayer.skip: skipping " + n + " milliseconds, new position is " + n2);
        this.recording.setMillisecondPosition(n2);
    }

    @Override
    public boolean isLooping() {
        return this.recording.getLoopCount() != 0;
    }

    @Override
    public boolean isPlaying() {
        return this.recording.isPlaying();
    }

    @Override
    public AudioMetaData getMetaData() {
        return this.recording.getMetaData();
    }

    @Override
    public void setLoopPoints(int n, int n2) {
        this.recording.setLoopPoints(n, n2);
    }

    @Override
    public void close() {
        this.recording.close();
        super.close();
    }
}

