/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.analysis;

import org.jzy3d.analysis.IAnalysis;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.ChartLauncher;
import org.jzy3d.chart.Settings;
import org.jzy3d.maths.Rectangle;
import org.jzy3d.utils.LoggerUtils;

public class AnalysisLauncher {
    protected static String DEFAULT_CANVAS_TYPE = "awt";
    protected static Rectangle DEFAULT_WINDOW = new Rectangle(200, 200, 600, 600);

    public static void open(IAnalysis demo) throws Exception {
        LoggerUtils.minimal();
        AnalysisLauncher.open(demo, DEFAULT_WINDOW);
    }

    public static void open(IAnalysis demo, Rectangle rectangle) throws Exception {
        Settings.getInstance().setHardwareAccelerated(true);
        demo.init();
        Chart chart = demo.getChart();
        System.out.println(demo.getPitch());
        System.out.println("------------------------------------");
        ChartLauncher.instructions();
        ChartLauncher.openChart(chart, rectangle, demo.getName());
    }

    public static void openStatic(IAnalysis demo) throws Exception {
        AnalysisLauncher.openStatic(demo, DEFAULT_WINDOW);
    }

    public static void openStatic(IAnalysis demo, Rectangle rectangle) throws Exception {
        Settings.getInstance().setHardwareAccelerated(true);
        demo.init();
        Chart chart = demo.getChart();
        ChartLauncher.openStaticChart(chart, rectangle, demo.getName());
        ChartLauncher.screenshot(demo.getChart(), "./data/screenshots/" + demo.getName() + ".png");
    }
}

