/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.bridge.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jzy3d.chart.Chart;
import org.jzy3d.ui.LookAndFeel;

public class ChartGroupWindow
extends JFrame {
    private static final long serialVersionUID = 7519209038396190502L;

    public ChartGroupWindow(Chart ... charts) {
        this(Arrays.asList(charts));
    }

    public ChartGroupWindow(Collection<? extends Chart> charts) {
        LookAndFeel.apply();
        this.setGridLayout(charts);
        this.windowExitListener();
        this.pack();
        this.setVisible(true);
        this.setBounds(new Rectangle(10, 10, 800, 600));
    }

    private void setGridLayout(Collection<? extends Chart> charts) {
        this.setLayout(new GridLayout(charts.size(), 1));
        for (Chart chart : charts) {
            this.addChartToGridLayout(chart);
        }
    }

    public void addChartToGridLayout(Chart chart) {
        JPanel chartPanel = new JPanel(new BorderLayout());
        chartPanel.add((Component)((Object)chart.getCanvas()), "Center");
        this.add(chartPanel);
    }

    public void windowExitListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChartGroupWindow.this.dispose();
                System.exit(0);
            }
        });
    }
}

