/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.mouse.camera;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.mouse.AWTMouseUtilities;
import org.jzy3d.maths.Coord2d;

public class AWTCameraMouseController
extends AbstractCameraController
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    public AWTCameraMouseController() {
    }

    public AWTCameraMouseController(Chart chart) {
        this.register(chart);
        this.addSlaveThreadController(chart.getFactory().newCameraThreadController(chart));
    }

    @Override
    public void register(Chart chart) {
        super.register(chart);
        chart.getCanvas().addMouseController(this);
    }

    @Override
    public void dispose() {
        for (Chart chart : this.targets) {
            chart.getCanvas().removeMouseController(this);
        }
        super.dispose();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.handleSlaveThread(e)) {
            return;
        }
        this.prevMouse.x = this.x(e);
        this.prevMouse.y = this.y(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Coord2d mouse = this.xy(e);
        if (AWTMouseUtilities.isLeftDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse).div(100.0f);
            this.rotate(move);
        } else if (AWTMouseUtilities.isRightDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse);
            if (move.y != 0.0f) {
                this.shift(move.y / 500.0f);
            }
        }
        this.prevMouse = mouse;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.stopThreadController();
        float factor = 1.0f + (float)e.getWheelRotation() / 10.0f;
        this.zoomZ(factor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public boolean handleSlaveThread(MouseEvent e) {
        if (AWTMouseUtilities.isDoubleClick(e) && this.threadController != null) {
            this.threadController.start();
            return true;
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        return false;
    }

    public Coord2d xy(MouseEvent e) {
        return new Coord2d(this.x(e), this.y(e));
    }

    public int y(MouseEvent e) {
        return e.getY();
    }

    public int x(MouseEvent e) {
        return e.getX();
    }
}

