/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.colors;

import java.util.List;
import org.apache.log4j.Logger;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IColorMapperUpdatePolicy;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Statistics;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.rendering.ordering.AbstractOrderingStrategy;
import org.jzy3d.plot3d.rendering.scene.Graph;

public class OrderingStrategyScoreColorMapper
extends ColorMapper {
    static Logger logger = Logger.getLogger(OrderingStrategyScoreColorMapper.class);
    protected float off;
    protected Graph sceneGraph;
    protected IColorMapperUpdatePolicy policy;

    public OrderingStrategyScoreColorMapper(IColorMap colormap, IColorMapperUpdatePolicy policy, Graph sceneGraph, Color factor) {
        super(colormap, factor);
        this.sceneGraph = sceneGraph;
        this.policy = policy;
    }

    @Override
    public void preDraw(Object o) {
        super.preDraw(o);
        if (this.policy.acceptsPreDraw(o)) {
            this.doPreDraw();
        }
    }

    private void doPreDraw() {
        AbstractOrderingStrategy s = this.sceneGraph.getStrategy();
        List<AbstractDrawable> drawable = this.sceneGraph.getDecomposition();
        double[] scores = new double[this.getNumCoordinates(drawable, false)];
        int k = 0;
        for (AbstractDrawable d : drawable) {
            scores[k++] = s.score(d);
            if (!(d instanceof Polygon)) continue;
            Polygon p = (Polygon)d;
            for (Point pt : p.getPoints()) {
                scores[k++] = s.score(pt.getCoord());
            }
        }
        this.min = Statistics.min(scores);
        this.max = Statistics.max(scores);
        if (this.min == this.max) {
            logger.warn((Object)("min = max = " + this.min));
        }
    }

    protected int getNumCoordinates(List<AbstractDrawable> drawables, boolean onlyBaryCenter) {
        if (onlyBaryCenter) {
            return drawables.size();
        }
        int n = drawables.size();
        for (AbstractDrawable d : drawables) {
            if (!(d instanceof Polygon)) continue;
            Polygon p = (Polygon)d;
            n += p.size();
        }
        return n;
    }

    @Override
    public Color getColor(Coord3d coord) {
        AbstractOrderingStrategy s = this.sceneGraph.getStrategy();
        float score = (float)s.score(coord);
        Color out = this.colormap.getColor(this, 0.0, 0.0, score);
        if (this.factor != null) {
            out.mul(this.factor);
        }
        return out;
    }
}

