/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.algorithms.convexhull.algorithms;

import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.algorithms.convexhull.algorithms.ComputationalGeometry;
import org.jzy3d.maths.algorithms.convexhull.utils.IComparator;

public class RadialComparator
implements IComparator<Coord2d> {
    private Coord2d origin;

    public RadialComparator(Coord2d origin) {
        assert (origin != null);
        this.origin = origin;
    }

    @Override
    public int compare(Coord2d p1, Coord2d p2) {
        return RadialComparator.polarCompare(this.origin, p1, p2);
    }

    public void setOrigin(Coord2d newO) {
        this.origin = newO;
    }

    private static int polarCompare(Coord2d o, Coord2d p, Coord2d q) {
        double dxp = p.getX() - o.getX();
        double dyp = p.getY() - o.getY();
        double dxq = q.getX() - o.getX();
        double dyq = q.getY() - o.getY();
        int orient = ComputationalGeometry.computeOrientation(o, p, q);
        if (orient == 1) {
            return -1;
        }
        if (orient == -1) {
            return 1;
        }
        double op = dxp * dxp + dyp * dyp;
        double oq = dxq * dxq + dyq * dyq;
        if (op < oq) {
            return 1;
        }
        if (op > oq) {
            return -1;
        }
        return 0;
    }
}

