/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.doubles;

import org.jzy3d.maths.Coord3d;

public class Coord3D {
    public double x;
    public double y;
    public double z;

    public Coord3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord3D(Coord3d c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public Coord3D cartesian() {
        return new Coord3D(Math.cos(this.x) * Math.cos(this.y) * this.z, Math.sin(this.x) * Math.cos(this.y) * this.z, Math.sin(this.y) * this.z);
    }

    public Coord3D cartesianSelf() {
        this.x = Math.cos(this.x) * Math.cos(this.y) * this.z;
        this.y = Math.sin(this.x) * Math.cos(this.y) * this.z;
        this.z = Math.sin(this.y) * this.z;
        return this;
    }

    public Coord3D polar() {
        double r = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        if (d == 0.0 && this.z > 0.0) {
            return new Coord3D(0.0, 1.5707963267948966, r);
        }
        if (d == 0.0 && this.z <= 0.0) {
            return new Coord3D(0.0, -1.5707963267948966, r);
        }
        double a = Math.abs(this.x / d) < 1.0 ? Math.acos(this.x / d) * (double)(this.y > 0.0 ? 1 : -1) : (this.y == 0.0 && this.x > 0.0 ? 0.0 : (this.y == 0.0 && this.x < 0.0 ? Math.PI : 0.0));
        double e = Math.atan(this.z / d);
        return new Coord3D(a, e, r);
    }

    public Coord3D polarSelf() {
        this.z = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        double d = Math.sqrt(this.x * this.x + this.y * this.y);
        if (d == 0.0 && this.z > 0.0) {
            this.x = 0.0;
            this.y = 1.5707963267948966;
            return this;
        }
        if (d == 0.0 && this.z <= 0.0) {
            this.x = 0.0;
            this.y = -1.5707963267948966;
            return this;
        }
        this.x = Math.abs(this.x / d) < 1.0 ? Math.acos(this.x / d) * (double)(this.y > 0.0 ? 1 : -1) : (this.y == 0.0 && this.x > 0.0 ? 0.0 : (this.y == 0.0 && this.x < 0.0 ? Math.PI : 0.0));
        this.y = Math.atan(this.z / d);
        return this;
    }

    public Coord3D add(Coord3D c2) {
        return new Coord3D(this.x + c2.x, this.y + c2.y, this.z + c2.z);
    }

    public Coord3D add(double x, double y, double z) {
        return new Coord3D(this.x + x, this.y + y, this.z + z);
    }

    public Coord3D addSelf(Coord3d c2) {
        this.x += (double)c2.x;
        this.y += (double)c2.y;
        this.z += (double)c2.z;
        return this;
    }

    public Coord3D addSelf(float x, float y, float z) {
        this.x += (double)x;
        this.y += (double)y;
        this.z += (double)z;
        return this;
    }

    public Coord3D add(float value) {
        return new Coord3D(this.x + (double)value, this.y + (double)value, this.z + (double)value);
    }

    public Coord3D addSelf(float value) {
        this.x += (double)value;
        this.y += (double)value;
        this.z += (double)value;
        return this;
    }

    public Coord3D sub(Coord3D c2) {
        return new Coord3D(this.x - c2.x, this.y - c2.y, this.z - c2.z);
    }

    public Coord3D subSelf(Coord3D c2) {
        this.x -= c2.x;
        this.y -= c2.y;
        this.z -= c2.z;
        return this;
    }

    public Coord3D sub(double value) {
        return new Coord3D(this.x - value, this.y - value, this.z - value);
    }

    public Coord3D subSelf(double value) {
        this.x -= value;
        this.y -= value;
        this.z -= value;
        return this;
    }

    public Coord3D mul(Coord3D c2) {
        return new Coord3D(this.x * c2.x, this.y * c2.y, this.z * c2.z);
    }

    public Coord3D mul(double x, double y, double z) {
        return new Coord3D(this.x * x, this.y * y, this.z * z);
    }

    public Coord3D mul(double value) {
        return new Coord3D(this.x * value, this.y * value, this.z * value);
    }

    public void mulSelf(Coord3D c2) {
        this.x *= c2.x;
        this.y *= c2.y;
        this.z *= c2.z;
    }

    public Coord3D div(Coord3D c2) {
        return new Coord3D(this.x / c2.x, this.y / c2.y, this.z / c2.z);
    }

    public void divSelf(Coord3D c2) {
        this.x /= c2.x;
        this.y /= c2.y;
        this.z /= c2.z;
    }

    public Coord3D div(double value) {
        return new Coord3D(this.x / value, this.y / value, this.z / value);
    }

    public String toString() {
        return "x=" + this.x + " y=" + this.y + " z=" + this.z;
    }

    public Coord3d toCoord3d() {
        return new Coord3d(this.x, this.y, this.z);
    }

    public double[] toArray() {
        double[] array = new double[]{this.x, this.y, this.z};
        return array;
    }

    public int hashCode() {
        int prime = 31;
        long result = 1L;
        result = 31L * result + Double.doubleToLongBits(this.x);
        result = 31L * result + Double.doubleToLongBits(this.y);
        result = 31L * result + Double.doubleToLongBits(this.z);
        return (int)result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coord3d)) {
            return false;
        }
        Coord3d other = (Coord3d)obj;
        if (this.x != (double)other.x) {
            return false;
        }
        if (this.y != (double)other.y) {
            return false;
        }
        return this.z == (double)other.z;
    }
}

