/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.maths.Array;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.builder.Tessellator;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Shape;

public class OrthonormalTessellator
extends Tessellator {
    static Logger logger = Logger.getLogger(OrthonormalTessellator.class);
    protected float[] x;
    protected float[] y;
    protected float[][] z;
    protected int findxi;
    protected int findyj;

    @Override
    public AbstractComposite build(float[] x, float[] y, float[] z) {
        this.setData(x, y, z);
        Shape s = new Shape();
        s.add(this.getSquarePolygonsOnCoordinates());
        return s;
    }

    protected void setData(float[] x, float[] y, float[] z) {
        if (x.length != y.length || x.length != z.length) {
            throw new IllegalArgumentException("x, y, and z arrays must agree in length.");
        }
        this.x = this.unique(x);
        this.y = this.unique(y);
        this.z = new float[this.x.length][this.y.length];
        for (int i = 0; i < this.x.length; ++i) {
            for (int j = 0; j < this.y.length; ++j) {
                this.z[i][j] = Float.NaN;
            }
        }
        for (int p = 0; p < z.length; ++p) {
            boolean found = this.find(this.x, this.y, x[p], y[p]);
            if (!found) {
                throw new RuntimeException("it seems (x[p],y[p]) has not been properly stored into (this.x,this.y)");
            }
            this.z[this.findxi][this.findyj] = z[p];
        }
    }

    protected float[] unique(float[] data) {
        float[] copy = Array.clone(data);
        Arrays.sort(copy);
        int nunique = 0;
        float last = Float.NaN;
        for (int i = 0; i < copy.length; ++i) {
            if (Float.isNaN(copy[i])) {
                logger.info((Object)("Ignoring NaN value at " + i));
                continue;
            }
            if (copy[i] == last) continue;
            ++nunique;
            last = copy[i];
        }
        float[] result = new float[nunique];
        last = Float.NaN;
        int r = 0;
        for (int d = 0; d < copy.length; ++d) {
            if (Float.isNaN(copy[d])) {
                logger.info((Object)("Ignoring NaN value at " + d));
                continue;
            }
            if (copy[d] == last) continue;
            result[r] = copy[d];
            last = copy[d];
            ++r;
        }
        return result;
    }

    protected boolean find(float[] x, float[] y, float vx, float vy) {
        int xi = -1;
        int yj = -1;
        for (int i = 0; i < x.length; ++i) {
            if (x[i] != vx) continue;
            xi = i;
        }
        if (xi == -1) {
            return false;
        }
        for (int j = 0; j < y.length; ++j) {
            if (y[j] != vy) continue;
            yj = j;
        }
        if (yj == -1) {
            return false;
        }
        this.findxi = xi;
        this.findyj = yj;
        return true;
    }

    public List<AbstractDrawable> getSquarePolygonsOnCoordinates() {
        return this.getSquarePolygonsOnCoordinates(null, null);
    }

    public List<AbstractDrawable> getSquarePolygonsAroundCoordinates() {
        return this.getSquarePolygonsAroundCoordinates(null, null);
    }

    public List<AbstractDrawable> getSquarePolygonsOnCoordinates(ColorMapper cmap, Color colorFactor) {
        ArrayList<AbstractDrawable> polygons = new ArrayList<AbstractDrawable>();
        for (int xi = 0; xi < this.x.length - 1; ++xi) {
            for (int yi = 0; yi < this.y.length - 1; ++yi) {
                Point[] p = this.getRealQuadStandingOnPoint(xi, yi);
                if (!this.validZ(p)) continue;
                if (cmap != null) {
                    p[0].setColor(cmap.getColor(p[0].xyz));
                    p[1].setColor(cmap.getColor(p[1].xyz));
                    p[2].setColor(cmap.getColor(p[2].xyz));
                    p[3].setColor(cmap.getColor(p[3].xyz));
                }
                if (colorFactor != null) {
                    p[0].rgb.mul(colorFactor);
                    p[1].rgb.mul(colorFactor);
                    p[2].rgb.mul(colorFactor);
                    p[3].rgb.mul(colorFactor);
                }
                AbstractDrawable quad = this.newQuad(p);
                polygons.add(quad);
            }
        }
        return polygons;
    }

    public List<AbstractDrawable> getSquarePolygonsAroundCoordinates(ColorMapper cmap, Color colorFactor) {
        ArrayList<AbstractDrawable> polygons = new ArrayList<AbstractDrawable>();
        for (int xi = 1; xi < this.x.length - 1; ++xi) {
            for (int yi = 1; yi < this.y.length - 1; ++yi) {
                Point[] p = this.getEstimatedQuadSurroundingPoint(xi, yi);
                if (!this.validZ(p)) continue;
                if (cmap != null) {
                    p[0].setColor(cmap.getColor(p[0].xyz));
                    p[1].setColor(cmap.getColor(p[1].xyz));
                    p[2].setColor(cmap.getColor(p[2].xyz));
                    p[3].setColor(cmap.getColor(p[3].xyz));
                }
                if (colorFactor != null) {
                    p[0].rgb.mul(colorFactor);
                    p[1].rgb.mul(colorFactor);
                    p[2].rgb.mul(colorFactor);
                    p[3].rgb.mul(colorFactor);
                }
                AbstractDrawable quad = this.newQuad(p);
                polygons.add(quad);
            }
        }
        return polygons;
    }

    protected Point[] getRealQuadStandingOnPoint(int xi, int yi) {
        Point[] p = new Point[]{new Point(new Coord3d(this.x[xi], this.y[yi], this.z[xi][yi])), new Point(new Coord3d(this.x[xi + 1], this.y[yi], this.z[xi + 1][yi])), new Point(new Coord3d(this.x[xi + 1], this.y[yi + 1], this.z[xi + 1][yi + 1])), new Point(new Coord3d(this.x[xi], this.y[yi + 1], this.z[xi][yi + 1]))};
        return p;
    }

    protected Point[] getEstimatedQuadSurroundingPoint(int xi, int yi) {
        Point[] p = new Point[]{new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi + 1] + this.z[xi - 1][yi] + this.z[xi][yi] + this.z[xi][yi + 1]) / 4.0f)), new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi] + this.z[xi - 1][yi - 1] + this.z[xi][yi - 1] + this.z[xi][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi][yi] + this.z[xi][yi - 1] + this.z[xi + 1][yi - 1] + this.z[xi + 1][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi][yi + 1] + this.z[xi][yi] + this.z[xi + 1][yi] + this.z[xi + 1][yi + 1]) / 4.0f))};
        return p;
    }

    protected boolean validZ(Point[] points) {
        for (Point p : points) {
            if (this.validZ(p)) continue;
            return false;
        }
        return true;
    }

    protected boolean validZ(Point p) {
        return !Float.isNaN(p.xyz.z);
    }

    protected AbstractDrawable newQuad(Point[] p) {
        Polygon quad = new Polygon();
        for (int pi = 0; pi < p.length; ++pi) {
            quad.add(p[pi]);
        }
        return quad;
    }
}

