/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.plot3d.builder.concrete.OrthonormalTessellator;
import org.jzy3d.plot3d.builder.concrete.RingTessellator;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.Shape;

public class RingExtrapolator
extends OrthonormalTessellator {
    protected float ringMax;
    protected ColorMapper cmap;
    protected Color factor;
    protected RingTessellator interpolator;

    public RingExtrapolator(float ringMax, ColorMapper cmap, Color factor) {
        this.ringMax = ringMax;
        this.cmap = cmap;
        this.factor = factor;
        this.interpolator = new RingTessellator(0.0f, ringMax, cmap, factor);
    }

    private RingExtrapolator() {
        throw new RuntimeException("Forbidden constructor!");
    }

    @Override
    public AbstractComposite build(float[] x, float[] y, float[] z) {
        this.setData(x, y, z);
        Shape s = new Shape();
        s.add(this.getExtrapolatedRingPolygons());
        return s;
    }

    public List<AbstractDrawable> getExtrapolatedRingPolygons() {
        float[] xbackup = this.x;
        float[] ybackup = this.y;
        float[][] zbackup = this.z;
        float step = this.x[1] - this.x[0];
        int nstep = this.x.length;
        int ENLARGE = 2;
        int required = (int)Math.ceil((this.ringMax * 2.0f - step * (float)nstep) / step);
        int n = required = required < 0 ? ENLARGE : required + ENLARGE;
        if (required > 0) {
            this.extrapolate(required);
        }
        this.interpolator.x = this.x;
        this.interpolator.y = this.y;
        this.interpolator.z = this.z;
        List<AbstractDrawable> polygons = this.interpolator.getInterpolatedRingPolygons();
        this.x = xbackup;
        this.y = ybackup;
        this.z = zbackup;
        return polygons;
    }

    public void extrapolate(int n) {
        float[] xnew = new float[this.x.length + n * 2];
        float[] ynew = new float[this.y.length + n * 2];
        float[][] znew = new float[this.x.length + n * 2][this.y.length + n * 2];
        float xmin = this.x[0];
        float xmax = this.x[this.x.length - 1];
        float xgap = this.x[1] - this.x[0];
        float ymin = this.y[0];
        float ymax = this.y[this.y.length - 1];
        float ygap = this.y[1] - this.y[0];
        for (int i = 0; i < xnew.length; ++i) {
            if (i < n) {
                xnew[i] = xmin - (float)(n - i) * xgap;
            } else if (i >= n && i < this.x.length + n) {
                xnew[i] = this.x[i - n];
            } else if (i >= this.x.length + n) {
                xnew[i] = xmax + (float)(i - (this.x.length + n) + 1) * xgap;
            }
            for (int j = 0; j < ynew.length; ++j) {
                if (j < n) {
                    ynew[j] = ymin - (float)(n - j) * ygap;
                    znew[i][j] = Float.NaN;
                    continue;
                }
                if (j >= n && j < this.y.length + n) {
                    ynew[j] = this.y[j - n];
                    if (i >= n && i < this.x.length + n) {
                        znew[i][j] = this.z[i - n][j - n];
                        continue;
                    }
                    znew[i][j] = Float.NaN;
                    continue;
                }
                if (j < this.y.length + n) continue;
                ynew[j] = ymax + (float)(j - (this.y.length + n) + 1) * ygap;
                znew[i][j] = Float.NaN;
            }
        }
        float olddiameter = xgap * (float)this.x.length / 2.0f;
        float newdiameter = xgap * (float)(this.x.length - 1 + n * 2) / 2.0f;
        olddiameter *= olddiameter;
        newdiameter *= newdiameter;
        int xmiddle = (xnew.length - 1) / 2;
        int ymiddle = (ynew.length - 1) / 2;
        for (int i = xmiddle; i < xnew.length; ++i) {
            for (int j = ymiddle; j < ynew.length; ++j) {
                float sqrad = xnew[i] * xnew[i] + ynew[j] * ynew[j];
                if (sqrad < olddiameter) continue;
                if (sqrad < newdiameter && sqrad >= olddiameter) {
                    int xopp = i - 2 * (i - xmiddle);
                    int yopp = j - 2 * (j - ymiddle);
                    znew[i][j] = this.getExtrapolatedZ(znew, i, j);
                    znew[xopp][j] = this.getExtrapolatedZ(znew, xopp, j);
                    znew[i][yopp] = this.getExtrapolatedZ(znew, i, yopp);
                    znew[xopp][yopp] = this.getExtrapolatedZ(znew, xopp, yopp);
                    continue;
                }
                znew[i][j] = Float.NaN;
            }
        }
        this.x = xnew;
        this.y = ynew;
        this.z = znew;
    }

    private float getExtrapolatedZ(float[][] grid, int currentXi, int currentYi) {
        int left = currentXi - 1 > 0 ? currentXi - 1 : currentXi;
        int right = currentXi + 1 < grid.length ? currentXi + 1 : currentXi;
        int bottom = currentYi - 1 > 0 ? currentYi - 1 : currentYi;
        int up = currentYi + 1 < grid[0].length ? currentYi + 1 : currentYi;
        float cumval = 0.0f;
        int nval = 0;
        for (int u = left; u <= right; ++u) {
            for (int v = bottom; v <= up; ++v) {
                if (Float.isNaN(grid[u][v])) continue;
                cumval += grid[u][v];
                ++nval;
            }
        }
        if (nval > 0) {
            return cumval / (float)nval;
        }
        return Float.NaN;
    }
}

