/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.rendering.view.Camera;

public class ColoredWireframePolygon
extends Polygon {
    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (this.mapper != null) {
            this.mapper.preDraw(this);
        }
        if (this.facestatus) {
            this.applyPolygonModeFill(gl);
            if (this.wfstatus && this.polygonOffsetFillEnable) {
                this.polygonOffseFillEnable(gl);
            }
            this.callPointsForFace(gl);
            if (this.wfstatus && this.polygonOffsetFillEnable) {
                this.polygonOffsetFillDisable(gl);
            }
        }
        if (this.wfstatus) {
            this.applyPolygonModeLine(gl);
            if (this.polygonOffsetFillEnable) {
                this.polygonOffsetLineEnable(gl);
            }
            this.callPointForWireframe(gl);
            if (this.polygonOffsetFillEnable) {
                this.polygonOffsetLineDisable(gl);
            }
        }
        if (this.mapper != null) {
            this.mapper.postDraw(this);
        }
        this.doDrawBounds(gl, glu, cam);
    }

    protected void polygonOffsetLineEnable(GL gl) {
        if (gl.isGL2GL3()) {
            gl.glEnable(10754);
            gl.glPolygonOffset(this.polygonOffsetFactor, this.polygonOffsetUnit);
        }
    }

    protected void polygonOffsetLineDisable(GL gl) {
        if (gl.isGL2GL3()) {
            gl.glDisable(10754);
        }
    }

    @Override
    public void callPointsForWireframeGL2(GL gl) {
        gl.glLineWidth(this.wfwidth);
        Color c = this.wfcolor;
        this.begin(gl);
        for (Point p : this.points) {
            if (this.mapper != null) {
                c = this.mapper.getColor(p.getCoord().z);
            }
            this.colorGL2(gl, c);
            this.vertexGL2(gl, p.xyz);
        }
        this.end(gl);
    }
}

