/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class Point
extends AbstractDrawable
implements ISingleColorable {
    public Coord3d xyz;
    public Color rgb;
    public float width;

    public Point() {
        this(Coord3d.ORIGIN, Color.WHITE, 1.0f);
    }

    public Point(Coord3d xyz) {
        this(xyz, Color.WHITE, 1.0f);
    }

    public Point(Coord3d xyz, Color rgb) {
        this(xyz, rgb, 1.0f);
    }

    public Point(Coord3d xyz, Color rgb, float width) {
        this.bbox = new BoundingBox3d();
        this.setData(xyz);
        this.setWidth(width);
        this.setColor(rgb);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glPointSize(this.width);
            gl.getGL2().glBegin(0);
            gl.getGL2().glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            this.vertexGL2(gl, this.xyz);
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glPointSize(this.width);
            GLES2CompatUtils.glBegin(0);
            GLES2CompatUtils.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            this.vertexGLES2(this.xyz);
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        this.xyz = transform.compute(this.xyz);
    }

    public void setData(Coord3d xyz) {
        this.xyz = xyz;
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this);
    }

    @Override
    public void setColor(Color color) {
        this.rgb = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.rgb;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public double getDistance(Camera camera) {
        return this.xyz.distance(camera.getEye());
    }

    @Override
    public double getShortestDistance(Camera camera) {
        return this.xyz.distance(camera.getEye());
    }

    @Override
    public double getLongestDistance(Camera camera) {
        return this.xyz.distance(camera.getEye());
    }

    public Point clone() {
        Point p = new Point(this.xyz.clone(), this.rgb.clone());
        p.setWidth(this.width);
        return p;
    }

    @Override
    public String toString(int depth) {
        return Utils.blanks(depth) + "(Point) coord=" + this.xyz + ", color=" + this.rgb;
    }

    public Coord3d getCoord() {
        return this.xyz;
    }

    public void setCoord(Coord3d xyz) {
        this.xyz = xyz;
    }
}

