/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.List;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.axes.AxeAnnotation;
import org.jzy3d.plot3d.primitives.axes.IAxe;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeBase
implements IAxe {
    protected Coord3d scale;
    protected BoundingBox3d bbox;
    protected IAxeLayout layout;
    protected SpaceTransformer spaceTransformer;

    public AxeBase() {
        this.setAxe(new BoundingBox3d(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f));
        this.setScale(new Coord3d(1.0f, 1.0f, 1.0f));
    }

    public AxeBase(BoundingBox3d box) {
        this.setAxe(box);
        this.setScale(new Coord3d(1.0f, 1.0f, 1.0f));
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setAxe(BoundingBox3d box) {
        this.bbox = box;
    }

    @Override
    public void draw(GL gl, GLU glu, Camera camera) {
        if (gl.isGL2()) {
            gl.getGL2().glLoadIdentity();
            gl.getGL2().glScalef(this.scale.x, this.scale.y, this.scale.z);
            gl.getGL2().glLineWidth(2.0f);
            gl.getGL2().glBegin(1);
            gl.getGL2().glColor3f(1.0f, 0.0f, 0.0f);
            gl.getGL2().glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
            gl.getGL2().glVertex3f(this.bbox.getXmax(), 0.0f, 0.0f);
            gl.getGL2().glColor3f(0.0f, 1.0f, 0.0f);
            gl.getGL2().glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
            gl.getGL2().glVertex3f(0.0f, this.bbox.getYmax(), 0.0f);
            gl.getGL2().glColor3f(0.0f, 0.0f, 1.0f);
            gl.getGL2().glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
            gl.getGL2().glVertex3f(0.0f, 0.0f, this.bbox.getZmax());
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glLoadIdentity();
            GLES2CompatUtils.glScalef(this.scale.x, this.scale.y, this.scale.z);
            GLES2CompatUtils.glLineWidth(2.0f);
            GLES2CompatUtils.glBegin(1);
            GLES2CompatUtils.glColor3f(1.0f, 0.0f, 0.0f);
            GLES2CompatUtils.glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
            GLES2CompatUtils.glVertex3f(this.bbox.getXmax(), 0.0f, 0.0f);
            GLES2CompatUtils.glColor3f(0.0f, 1.0f, 0.0f);
            GLES2CompatUtils.glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
            GLES2CompatUtils.glVertex3f(0.0f, this.bbox.getYmax(), 0.0f);
            GLES2CompatUtils.glColor3f(0.0f, 0.0f, 1.0f);
            GLES2CompatUtils.glVertex3f(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
            GLES2CompatUtils.glVertex3f(0.0f, 0.0f, this.bbox.getZmax());
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    public void setScale(Coord3d scale) {
        this.scale = scale;
    }

    @Override
    public BoundingBox3d getBoxBounds() {
        return this.bbox;
    }

    @Override
    public Coord3d getCenter() {
        return new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin());
    }

    @Override
    public IAxeLayout getLayout() {
        return this.layout;
    }

    @Override
    public SpaceTransformer getSpaceTransformer() {
        return this.spaceTransformer;
    }

    @Override
    public void setSpaceTransformer(SpaceTransformer spaceTransformer) {
        this.spaceTransformer = spaceTransformer;
    }

    @Override
    public Coord3d getScale() {
        return this.scale;
    }

    @Override
    public List<AxeAnnotation> getAnnotations() {
        return null;
    }

    @Override
    public void setAnnotations(List<AxeAnnotation> annotations) {
    }

    @Override
    public BoundingBox3d getWholeBounds() {
        return this.bbox;
    }
}

