/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes.layout;

import org.jzy3d.colors.Color;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.providers.SmartTickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.DefaultDecimalTickRenderer;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;

public class AxeBoxLayout
implements IAxeLayout {
    protected boolean tickLineDisplayed = true;
    protected String xAxeLabel;
    protected String yAxeLabel;
    protected String zAxeLabel;
    protected boolean xAxeLabelDisplayed;
    protected boolean yAxeLabelDisplayed;
    protected boolean zAxeLabelDisplayed;
    protected double[] xTicks;
    protected double[] yTicks;
    protected double[] zTicks;
    protected ITickProvider xTickProvider;
    protected ITickProvider yTickProvider;
    protected ITickProvider zTickProvider;
    protected ITickRenderer xTickRenderer;
    protected ITickRenderer yTickRenderer;
    protected ITickRenderer zTickRenderer;
    protected Color xTickColor;
    protected Color yTickColor;
    protected Color zTickColor;
    protected boolean xTickLabelDisplayed;
    protected boolean yTickLabelDisplayed;
    protected boolean zTickLabelDisplayed;
    protected boolean faceDisplayed;
    protected Color quadColor;
    protected Color gridColor;
    protected double lastXmin = Double.NaN;
    protected double lastXmax = Double.NaN;
    protected double lastYmin = Double.NaN;
    protected double lastYmax = Double.NaN;
    protected double lastZmin = Double.NaN;
    protected double lastZmax = Double.NaN;
    protected Color mainColor;

    public AxeBoxLayout() {
        this.setXAxeLabel("X");
        this.setYAxeLabel("Y");
        this.setZAxeLabel("Z");
        this.setXAxeLabelDisplayed(true);
        this.setYAxeLabelDisplayed(true);
        this.setZAxeLabelDisplayed(true);
        this.setXTickProvider(new SmartTickProvider(5));
        this.setYTickProvider(new SmartTickProvider(5));
        this.setZTickProvider(new SmartTickProvider(6));
        this.setXTickRenderer(new DefaultDecimalTickRenderer(4));
        this.setYTickRenderer(new DefaultDecimalTickRenderer(4));
        this.setZTickRenderer(new DefaultDecimalTickRenderer(6));
        this.setFaceDisplayed(false);
        this.setXTickLabelDisplayed(true);
        this.setYTickLabelDisplayed(true);
        this.setZTickLabelDisplayed(true);
        this.setMainColor(Color.BLACK);
    }

    @Override
    public void setMainColor(Color color) {
        this.mainColor = color;
        this.setXTickColor(color);
        this.setYTickColor(color);
        this.setZTickColor(color);
        this.setGridColor(color);
        this.setQuadColor(color.negative());
    }

    @Override
    public Color getMainColor() {
        return this.mainColor;
    }

    @Override
    public double[] getXTicks(double min, double max) {
        this.lastXmin = min;
        this.lastXmax = max;
        this.xTicks = this.xTickProvider.generateTicks(min, max);
        return this.xTicks;
    }

    @Override
    public double[] getYTicks(double min, double max) {
        this.lastYmin = min;
        this.lastYmax = max;
        this.yTicks = this.yTickProvider.generateTicks(min, max);
        return this.yTicks;
    }

    @Override
    public double[] getZTicks(double min, double max) {
        this.lastZmin = min;
        this.lastZmax = max;
        this.zTicks = this.zTickProvider.generateTicks(min, max);
        return this.zTicks;
    }

    @Override
    public String getXAxeLabel() {
        return this.xAxeLabel;
    }

    @Override
    public void setXAxeLabel(String axeLabel) {
        this.xAxeLabel = axeLabel;
    }

    @Override
    public String getYAxeLabel() {
        return this.yAxeLabel;
    }

    @Override
    public void setYAxeLabel(String axeLabel) {
        this.yAxeLabel = axeLabel;
    }

    @Override
    public String getZAxeLabel() {
        return this.zAxeLabel;
    }

    @Override
    public void setZAxeLabel(String axeLabel) {
        this.zAxeLabel = axeLabel;
    }

    @Override
    public double[] getXTicks() {
        return this.xTicks;
    }

    @Override
    public double[] getYTicks() {
        return this.yTicks;
    }

    @Override
    public double[] getZTicks() {
        return this.zTicks;
    }

    @Override
    public ITickProvider getXTickProvider() {
        return this.xTickProvider;
    }

    @Override
    public void setXTickProvider(ITickProvider tickProvider) {
        this.xTickProvider = tickProvider;
        if (this.lastXmin != Double.NaN) {
            this.getXTicks(this.lastXmin, this.lastXmax);
        }
    }

    @Override
    public ITickProvider getYTickProvider() {
        return this.yTickProvider;
    }

    @Override
    public void setYTickProvider(ITickProvider tickProvider) {
        this.yTickProvider = tickProvider;
        if (this.lastYmin != Double.NaN) {
            this.getYTicks(this.lastYmin, this.lastYmax);
        }
    }

    @Override
    public ITickProvider getZTickProvider() {
        return this.zTickProvider;
    }

    @Override
    public void setZTickProvider(ITickProvider tickProvider) {
        this.zTickProvider = tickProvider;
        if (this.lastZmin != Double.NaN) {
            this.getZTicks(this.lastZmin, this.lastZmax);
        }
    }

    @Override
    public ITickRenderer getXTickRenderer() {
        return this.xTickRenderer;
    }

    @Override
    public void setXTickRenderer(ITickRenderer tickRenderer) {
        this.xTickRenderer = tickRenderer;
    }

    @Override
    public ITickRenderer getYTickRenderer() {
        return this.yTickRenderer;
    }

    @Override
    public void setYTickRenderer(ITickRenderer tickRenderer) {
        this.yTickRenderer = tickRenderer;
    }

    @Override
    public ITickRenderer getZTickRenderer() {
        return this.zTickRenderer;
    }

    @Override
    public void setZTickRenderer(ITickRenderer tickRenderer) {
        this.zTickRenderer = tickRenderer;
    }

    @Override
    public Color getXTickColor() {
        return this.xTickColor;
    }

    @Override
    public void setXTickColor(Color tickColor) {
        this.xTickColor = tickColor;
    }

    @Override
    public Color getYTickColor() {
        return this.yTickColor;
    }

    @Override
    public void setYTickColor(Color tickColor) {
        this.yTickColor = tickColor;
    }

    @Override
    public Color getZTickColor() {
        return this.zTickColor;
    }

    @Override
    public void setZTickColor(Color tickColor) {
        this.zTickColor = tickColor;
    }

    @Override
    public boolean isFaceDisplayed() {
        return this.faceDisplayed;
    }

    @Override
    public void setFaceDisplayed(boolean faceDisplayed) {
        this.faceDisplayed = faceDisplayed;
    }

    @Override
    public Color getQuadColor() {
        return this.quadColor;
    }

    @Override
    public void setQuadColor(Color quadColor) {
        this.quadColor = quadColor;
    }

    @Override
    public Color getGridColor() {
        return this.gridColor;
    }

    @Override
    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    @Override
    public boolean isXAxeLabelDisplayed() {
        return this.xAxeLabelDisplayed;
    }

    @Override
    public void setXAxeLabelDisplayed(boolean axeLabelDisplayed) {
        this.xAxeLabelDisplayed = axeLabelDisplayed;
    }

    @Override
    public boolean isYAxeLabelDisplayed() {
        return this.yAxeLabelDisplayed;
    }

    @Override
    public void setYAxeLabelDisplayed(boolean axeLabelDisplayed) {
        this.yAxeLabelDisplayed = axeLabelDisplayed;
    }

    @Override
    public boolean isZAxeLabelDisplayed() {
        return this.zAxeLabelDisplayed;
    }

    @Override
    public void setZAxeLabelDisplayed(boolean axeLabelDisplayed) {
        this.zAxeLabelDisplayed = axeLabelDisplayed;
    }

    @Override
    public boolean isXTickLabelDisplayed() {
        return this.xTickLabelDisplayed;
    }

    @Override
    public void setXTickLabelDisplayed(boolean tickLabelDisplayed) {
        this.xTickLabelDisplayed = tickLabelDisplayed;
    }

    @Override
    public boolean isYTickLabelDisplayed() {
        return this.yTickLabelDisplayed;
    }

    @Override
    public void setYTickLabelDisplayed(boolean tickLabelDisplayed) {
        this.yTickLabelDisplayed = tickLabelDisplayed;
    }

    @Override
    public boolean isZTickLabelDisplayed() {
        return this.zTickLabelDisplayed;
    }

    @Override
    public void setZTickLabelDisplayed(boolean tickLabelDisplayed) {
        this.zTickLabelDisplayed = tickLabelDisplayed;
    }

    @Override
    public boolean isTickLineDisplayed() {
        return this.tickLineDisplayed;
    }

    @Override
    public void setTickLineDisplayed(boolean tickLineDisplayed) {
        this.tickLineDisplayed = tickLineDisplayed;
    }
}

