/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes.layout.providers;

import org.jzy3d.plot3d.primitives.axes.layout.providers.AbstractTickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;

public class RegularTickProvider
extends AbstractTickProvider
implements ITickProvider {
    protected int steps;

    public RegularTickProvider() {
        this(3);
    }

    public RegularTickProvider(int steps) {
        this.steps = steps;
    }

    @Override
    public double[] generateTicks(double min, double max, int steps) {
        double[] ticks = new double[steps];
        double step = (max - min) / (double)(steps - 1);
        ticks[0] = min;
        ticks[steps - 1] = max;
        for (int t = 1; t < steps - 1; ++t) {
            ticks[t] = min + (double)t * step;
        }
        return ticks;
    }

    @Override
    public int getDefaultSteps() {
        return this.steps;
    }
}

