/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.canvas;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.plot3d.pipelines.NotImplementedException;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.view.Renderer3d;
import org.jzy3d.plot3d.rendering.view.View;

public class OffscreenCanvas
implements ICanvas {
    protected View view;
    protected Renderer3d renderer;
    protected GLOffscreenAutoDrawable glpBuffer;
    protected GLCapabilities capabilities;

    public OffscreenCanvas(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilities capabilities, int width, int height) {
        this(factory, scene, quality, capabilities, width, height, false, false);
    }

    public OffscreenCanvas(IChartComponentFactory factory, Scene scene, Quality quality, GLCapabilities capabilities, int width, int height, boolean traceGL, boolean debugGL) {
        this.view = scene.newView(this, quality);
        this.renderer = factory.newRenderer(this.view, traceGL, debugGL);
        this.capabilities = capabilities;
        this.initBuffer(capabilities, width, height);
    }

    public void initBuffer(GLCapabilities capabilities, int width, int height) {
        GLProfile profile = capabilities.getGLProfile();
        capabilities.setDoubleBuffered(false);
        capabilities.setPBuffer(true);
        GLDrawableFactory factory = GLDrawableFactory.getFactory((GLProfile)profile);
        if (!factory.canCreateGLPbuffer(null, profile)) {
            throw new RuntimeException("No pbuffer support");
        }
        if (this.glpBuffer != null) {
            this.glpBuffer.removeGLEventListener((GLEventListener)this.renderer);
            this.glpBuffer.destroy();
        }
        this.glpBuffer = factory.createOffscreenAutoDrawable(factory.getDefaultDevice(), (GLCapabilitiesImmutable)capabilities, null, width, height);
        this.glpBuffer.addGLEventListener((GLEventListener)this.renderer);
    }

    @Override
    public void setPixelScale(float[] scale) {
        throw new NotImplementedException();
    }

    @Deprecated
    public GLOffscreenAutoDrawable getGlpBuffer() {
        return this.glpBuffer;
    }

    public GLOffscreenAutoDrawable getDrawable() {
        return this.glpBuffer;
    }

    @Override
    public void dispose() {
        this.glpBuffer.destroy();
        this.renderer = null;
        this.view = null;
    }

    @Override
    public void forceRepaint() {
        this.glpBuffer.display();
    }

    @Override
    public TextureData screenshot() {
        this.renderer.nextDisplayUpdateScreenshot();
        this.glpBuffer.display();
        return this.renderer.getLastScreenshot();
    }

    @Override
    public TextureData screenshot(File file) throws IOException {
        TextureData screen = this.screenshot();
        TextureIO.write((TextureData)screen, (File)file);
        return screen;
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public int getRendererWidth() {
        return this.renderer != null ? this.renderer.getWidth() : 0;
    }

    @Override
    public int getRendererHeight() {
        return this.renderer != null ? this.renderer.getHeight() : 0;
    }

    @Override
    public Renderer3d getRenderer() {
        return this.renderer;
    }

    @Override
    public String getDebugInfo() {
        GL gl = this.getView().getCurrentGL();
        StringBuffer sb = new StringBuffer();
        sb.append("Chosen GLCapabilities: " + this.glpBuffer.getChosenGLCapabilities() + "\n");
        sb.append("GL_VENDOR: " + gl.glGetString(7936) + "\n");
        sb.append("GL_RENDERER: " + gl.glGetString(7937) + "\n");
        sb.append("GL_VERSION: " + gl.glGetString(7938) + "\n");
        return sb.toString();
    }

    @Override
    public void addMouseController(Object o) {
    }

    @Override
    public void addKeyController(Object o) {
    }

    @Override
    public void removeMouseController(Object o) {
    }

    @Override
    public void removeKeyController(Object o) {
    }

    public GLCapabilities getCapabilities() {
        return this.capabilities;
    }
}

