/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;

public class ImageRenderer {
    public static void renderImage(GL gl, ByteBuffer image, int imageWidth, int imageHeight, int screenWidth, int screenHeight) {
        ImageRenderer.renderImage(gl, image, imageWidth, imageHeight, screenWidth, screenHeight, 0.75f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderImage(GL gl, ByteBuffer image, int imageWidth, int imageHeight, int screenWidth, int screenHeight, float z) {
        if (image == null) {
            return;
        }
        float xratio = 1.0f;
        float yratio = 1.0f;
        int xpict = 0;
        int ypict = 0;
        if (imageWidth < screenWidth) {
            xpict = (int)((float)screenWidth / 2.0f - (float)imageWidth / 2.0f);
        } else {
            xratio = (float)screenWidth / (float)imageWidth;
        }
        if (imageHeight < screenHeight) {
            ypict = (int)((float)screenHeight / 2.0f - (float)imageHeight / 2.0f);
        } else {
            yratio = (float)screenHeight / (float)imageHeight;
        }
        if (gl.isGL2()) {
            gl.getGL2().glPixelZoom(xratio, yratio);
            gl.getGL2().glRasterPos3f((float)xpict, (float)ypict, z);
            ByteBuffer byteBuffer = image;
            synchronized (byteBuffer) {
                gl.getGL2().glDrawPixels(imageWidth, imageHeight, 6408, 5121, (Buffer)image);
            }
        }
        GLES2CompatUtils.glPixelZoom(xratio, yratio);
        GLES2CompatUtils.glRasterPos3f(xpict, ypict, z);
        ByteBuffer byteBuffer = image;
        synchronized (byteBuffer) {
            GLES2CompatUtils.glDrawPixels(imageWidth, imageHeight, 6408, 5121, image);
        }
    }
}

