/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLPipelineFactory;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import org.jzy3d.plot3d.rendering.view.View;

public class Renderer3d
implements GLEventListener {
    protected GLU glu;
    protected View view;
    protected int width = 0;
    protected int height = 0;
    protected boolean doScreenshotAtNextDisplay = false;
    protected TextureData image = null;
    protected boolean traceGL = false;
    protected boolean debugGL = false;

    public Renderer3d(View view) {
        this(view, false, false);
    }

    public Renderer3d() {
        this(null, false, false);
    }

    public Renderer3d(View view, boolean traceGL, boolean debugGL) {
        this(view, traceGL, debugGL, new GLU());
    }

    public Renderer3d(View view, boolean traceGL, boolean debugGL, GLU glu) {
        this.view = view;
        this.traceGL = traceGL;
        this.debugGL = debugGL;
        this.glu = glu;
    }

    public void init(GLAutoDrawable canvas) {
        if (canvas != null && canvas.getGL() != null && canvas.getGL().getGL2() != null && this.view != null) {
            if (this.debugGL) {
                canvas.getGL().getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Debug", null, (GL)canvas.getGL(), null));
            }
            if (this.traceGL) {
                canvas.getGL().getContext().setGL(GLPipelineFactory.create((String)"com.jogamp.opengl.Trace", null, (GL)canvas.getGL(), (Object[])new Object[]{System.err}));
            }
            this.view.init(canvas.getGL());
        }
    }

    public void display(GLAutoDrawable canvas) {
        GL gl = canvas.getGL();
        if (this.view != null) {
            this.view.clear(gl);
            this.view.render(gl, this.glu);
            if (this.doScreenshotAtNextDisplay) {
                GLReadBufferUtil screenshot = new GLReadBufferUtil(false, false);
                screenshot.readPixels(gl, true);
                this.image = screenshot.getTextureData();
                this.doScreenshotAtNextDisplay = false;
            }
        }
    }

    public void reshape(GLAutoDrawable canvas, int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        if (this.view != null) {
            this.view.dimensionDirty = true;
            if (canvas != null) {
                GL2 gl = canvas.getGL().getGL2();
                this.view.clear((GL)gl);
                this.view.render((GL)gl, this.glu);
            }
        }
    }

    public void dispose(GLAutoDrawable arg0) {
        this.view = null;
        this.glu = null;
    }

    public void nextDisplayUpdateScreenshot() {
        this.doScreenshotAtNextDisplay = true;
    }

    public TextureData getLastScreenshot() {
        return this.image;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

