/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view.layout;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.jzy3d.chart.Chart;
import org.jzy3d.plot2d.rendering.CanvasAWT;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.legends.ILegend;
import org.jzy3d.plot3d.rendering.view.AWTView;
import org.jzy3d.plot3d.rendering.view.Renderer2d;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.ViewportBuilder;
import org.jzy3d.plot3d.rendering.view.ViewportConfiguration;
import org.jzy3d.plot3d.rendering.view.ViewportMode;
import org.jzy3d.plot3d.rendering.view.layout.IViewportLayout;

public class ColorbarViewportLayout
implements IViewportLayout {
    protected float screenSeparator = 1.0f;
    protected boolean hasMeta = true;
    protected Rectangle zone1 = new Rectangle(0, 0, 0, 0);
    protected Rectangle zone2 = new Rectangle(0, 0, 0, 0);
    protected ViewportConfiguration sceneViewPort;
    protected ViewportConfiguration backgroundViewPort;

    @Override
    public void update(Chart chart) {
        ICanvas canvas = chart.getCanvas();
        List<ILegend> list = this.getLegends(chart);
        this.computeSeparator(canvas, list);
        this.sceneViewPort = ViewportBuilder.column(canvas, 0.0f, this.screenSeparator);
        this.backgroundViewPort = new ViewportConfiguration(canvas);
    }

    public void computeSeparator(ICanvas canvas, List<ILegend> list) {
        boolean bl = this.hasMeta = list.size() > 0;
        if (this.hasMeta) {
            int minwidth = 0;
            for (ILegend data : list) {
                minwidth += data.getMinimumSize().width;
            }
            this.screenSeparator = (float)(canvas.getRendererWidth() - minwidth) / (float)canvas.getRendererWidth();
        } else {
            this.screenSeparator = 1.0f;
        }
    }

    @Override
    public void render(GL gl, GLU glu, Chart chart) {
        View view = chart.getView();
        view.renderBackground(gl, glu, this.backgroundViewPort);
        view.renderScene(gl, glu, this.sceneViewPort);
        this.renderLegends(gl, glu, chart);
        view.renderOverlay(gl, view.getCamera().getLastViewPort());
    }

    protected void renderLegends(GL gl, GLU glu, Chart chart) {
        if (this.hasMeta) {
            this.renderLegends(gl, glu, this.screenSeparator, 1.0f, this.getLegends(chart), chart.getCanvas());
        }
    }

    protected void renderLegends(GL gl, GLU glu, float left, float right, List<ILegend> data, ICanvas canvas) {
        float slice = (right - left) / (float)data.size();
        int k = 0;
        for (ILegend layer : data) {
            layer.setViewportMode(ViewportMode.STRETCH_TO_FILL);
            layer.setViewPort(canvas.getRendererWidth(), canvas.getRendererHeight(), left + slice * (float)k++, left + slice * (float)k);
            layer.render(gl, glu);
        }
    }

    public void showLayout(AWTView view) {
        Renderer2d layoutBorder = new Renderer2d(){
            CanvasAWT pencil = null;

            @Override
            public void paint(Graphics g) {
                if (this.pencil == null) {
                    this.pencil = new CanvasAWT((Graphics2D)g);
                }
                if (ColorbarViewportLayout.this.zone1.width > 0) {
                    this.pencil.drawRect(null, ColorbarViewportLayout.this.zone1.x, ColorbarViewportLayout.this.zone1.y, ColorbarViewportLayout.this.zone1.width, ColorbarViewportLayout.this.zone1.height, true);
                }
                if (ColorbarViewportLayout.this.zone2.width > 0) {
                    this.pencil.drawRect(null, ColorbarViewportLayout.this.zone2.x, ColorbarViewportLayout.this.zone2.y, ColorbarViewportLayout.this.zone2.width, ColorbarViewportLayout.this.zone2.height, true);
                }
            }
        };
        view.addRenderer2d(layoutBorder);
    }

    protected List<ILegend> getLegends(Chart chart) {
        return chart.getScene().getGraph().getLegends();
    }
}

