/*
 * Decompiled with CFR 0.152.
 */
package sbgc.adj_var_parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import sbgc.adj_var_parser.AdjVarSource;
import sbgc.service.DataInputStreamLE;
import sbgc.service.DataOutputStreamLE;

public class AdjVarData {
    public final ArrayList<AdjVarSource> sources = new ArrayList();
    public static final int LUT_BINARY_FORMAT_VER = 0;

    public AdjVarSource getOrAddSource(Integer srcId) {
        for (AdjVarSource src : this.sources) {
            if (src.id != srcId) continue;
            return src;
        }
        AdjVarSource src = new AdjVarSource(srcId);
        this.sources.add(src);
        return src;
    }

    public void write(DataOutputStreamLE out) throws Exception {
        out.writeByte(0);
        out.writeByte(this.sources.size());
        for (AdjVarSource src : this.sources) {
            src.write(out);
        }
    }

    public byte[] toByteArray() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStreamLE out = new DataOutputStreamLE(bos);
        this.write(out);
        return bos.toByteArray();
    }

    public static AdjVarData read(DataInputStreamLE in) throws Exception {
        AdjVarData data = new AdjVarData();
        int formatVer = in.readByte();
        int size = in.readByte();
        data.sources.ensureCapacity(size);
        for (int i = 0; i < size; ++i) {
            data.sources.add(AdjVarSource.read(in));
        }
        if (in.getInputStream().available() > 0) {
            throw new Exception("Binary data is corrupted or has incorrect format!");
        }
        return data;
    }

    public static AdjVarData fromByteArray(byte[] bytes) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStreamLE in = new DataInputStreamLE(bis);
        return AdjVarData.read(in);
    }
}

