/*
 * Decompiled with CFR 0.152.
 */
package sbgc.adj_var_parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sbgc.adj_var_parser.AdjVarData;
import sbgc.adj_var_parser.AdjVarParseException;
import sbgc.adj_var_parser.AdjVarPoint;
import sbgc.adj_var_parser.AdjVarSource;
import sbgc.adj_var_parser.AdjVarValue;
import sbgc.script_parser.script.ScriptCmdParam;
import sbgc.script_parser.utils.Utils;

public class AdjVarParser {
    public static AdjVarData parseFromString(String text) throws AdjVarParseException {
        return AdjVarParser.parseFromArray(text.split("\n"));
    }

    public static AdjVarData parseFromArray(String[] lines) throws AdjVarParseException {
        AdjVarData data = new AdjVarData();
        Pattern rowPattern = Pattern.compile("^\\s*(\\w+)\\s*\\(\\s*(-?\\d*\\.?\\d+(?:E-?\\d+)?)\\s*\\)\\s*\\:\\s*(.+)$", 2);
        Pattern varSplitPattern = Pattern.compile("\\s*\\,\\s*");
        Pattern varPattern = Pattern.compile("^([\\w\\.]+)(\\*?)\\s*\\(\\s*(-?\\d*\\.?\\d+(?:E-?\\d+)?)\\s*\\)", 2);
        Pattern skipLinePattern = Pattern.compile("^\\s*(?:\\#.*)?$");
        for (int line = 1; line <= lines.length; ++line) {
            try {
                String str = AdjVarParser.removeUTF8BOM(lines[line - 1]).trim();
                if (skipLinePattern.matcher(str).matches()) continue;
                Matcher matcher = rowPattern.matcher(str);
                if (matcher.matches()) {
                    String[] vars;
                    String srcName = matcher.group(1);
                    String srcValS = matcher.group(2);
                    String varsStr = matcher.group(3);
                    if (!Utils.isFloat(srcValS)) {
                        throw new Exception("Wrong value: " + srcValS);
                    }
                    float srcVal = Utils.toFloat(srcValS);
                    Integer srcId = AdjVarSource.srcNameToInteger(srcName);
                    AdjVarPoint point = new AdjVarPoint(srcVal, line);
                    for (String varStr : vars = varSplitPattern.split(varsStr)) {
                        float varVal;
                        Integer varId;
                        boolean isMult;
                        matcher = varPattern.matcher(varStr);
                        if (matcher.matches()) {
                            String varName = matcher.group(1);
                            isMult = matcher.group(2).equals("*");
                            String varValS = matcher.group(3);
                            varId = null;
                            varId = Utils.isInteger(varName) ? Integer.valueOf(Utils.toInteger(varName)) : ScriptCmdParam.adjVarNameToInteger(varName);
                            if (varId == null) {
                                throw new Exception("Unknown variable name: " + varName);
                            }
                            if (!Utils.isFloat(varValS)) {
                                throw new Exception("Wrong value for variable \"" + varName + "\": " + varValS);
                            }
                            varVal = Utils.toFloat(varValS);
                            if (isMult && varVal <= 0.0f) {
                                throw new Exception("Multiplier value in \"" + varName + "\" should be positive!");
                            }
                        } else {
                            throw new Exception("Wrong format \"" + varStr + "\"");
                        }
                        point.addVarValue(new AdjVarValue(varId, varVal, isMult));
                    }
                    AdjVarSource src = data.getOrAddSource(srcId);
                    src.addPoint(point);
                    continue;
                }
                throw new Exception("Wrong format");
            }
            catch (Exception e) {
                throw new AdjVarParseException(e, line);
            }
        }
        for (AdjVarSource src : data.sources) {
            if (src.points.size() != 1) continue;
            throw new AdjVarParseException("The number of data points for the signal source '" + AdjVarSource.srcIntegerToName(src.id) + "' should be more than one!", src.points.get((int)0).lineNum);
        }
        return data;
    }

    public static String dataToText(AdjVarData data) throws Exception {
        StringBuilder str = new StringBuilder();
        for (AdjVarSource src : data.sources) {
            String srcName = AdjVarSource.srcIntegerToName(src.id);
            for (AdjVarPoint point : src.points) {
                str.append(srcName + "(" + point.srcVal + "): ");
                for (AdjVarValue var : point.vars) {
                    str.append(var.getFullName() + "(" + var.varVal + "), ");
                }
                str.delete(str.length() - 2, str.length() - 1);
                str.append("\n");
            }
        }
        return str.toString();
    }

    private static String removeUTF8BOM(String s) {
        return s.replace("\ufeff", "");
    }
}

