/*
 * Decompiled with CFR 0.152.
 */
package sbgc.adj_var_parser;

import java.util.ArrayList;
import sbgc.adj_var_parser.AdjVarValue;

public class AdjVarPoint {
    public final float srcVal;
    public final int lineNum;
    public final ArrayList<AdjVarValue> vars = new ArrayList();
    public static final int VARS_NUM_MAX = 20;

    public AdjVarPoint(float srcVal, int lineNum) {
        this.srcVal = srcVal;
        this.lineNum = lineNum;
    }

    public void addVarValue(AdjVarValue val) throws Exception {
        if (this.vars.size() == 20) {
            throw new Exception("The maximum number of variables exceeded: 20");
        }
        this.vars.add(val);
    }

    public void compareVars(AdjVarPoint p) throws Exception {
        if (this.vars.size() != p.vars.size()) {
            throw new Exception("The set of variables at this point differs with the set of variables in a previous point!");
        }
        for (int i = 0; i < this.vars.size(); ++i) {
            AdjVarValue otherVar;
            AdjVarValue var = this.vars.get(i);
            if (var.typeEquals(otherVar = p.vars.get(i))) continue;
            throw new Exception("The variable at position " + (i + 1) + " (" + otherVar.getFullName() + ") does not match the variable in a previous point at the same position: (" + var.getFullName() + ")!");
        }
    }
}

