/*
 * Decompiled with CFR 0.152.
 */
package sbgc.adj_var_parser;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import sbgc.adj_var_parser.AdjVarPoint;
import sbgc.adj_var_parser.AdjVarValue;
import sbgc.object.Sprav;
import sbgc.script_parser.script.ScriptCmdParam;
import sbgc.script_parser.utils.Utils;
import sbgc.service.DataInputStreamLE;
import sbgc.service.DataOutputStreamLE;
import sbgc.utils.MathUtils;

public class AdjVarSource {
    public final int id;
    public final ArrayList<AdjVarPoint> points = new ArrayList();
    public static final int POINT_NUM_MAX = 1000;
    public static final int RC_MAX_VAL = 16384;
    public static final int RC_RANGE = 32768;
    public static final int RC_UNDEF = Short.MIN_VALUE;
    public static final Map<String, Integer> SIGNAL_SRC_NAMES = new LinkedHashMap<String, Integer>();
    public static final int SIGNAL_SOURCE_MOMENTUM_ROLL = 256;
    public static final int SIGNAL_SOURCE_MOMENTUM_PITCH = 257;
    public static final int SIGNAL_SOURCE_MOMENTUM_YAW = 258;
    public static final int SIGNAL_SOURCE_BAT_LEVEL = 259;

    public AdjVarSource(int id) {
        this.id = id;
    }

    public void addPoint(AdjVarPoint newPoint) throws Exception {
        if (this.points.isEmpty()) {
            this.points.add(newPoint);
        } else {
            int i;
            this.points.get(0).compareVars(newPoint);
            for (i = 0; i < this.points.size(); ++i) {
                if (this.points.get((int)i).srcVal == newPoint.srcVal) {
                    throw new Exception("Data point value doubles: " + newPoint.srcVal);
                }
                if (this.points.get((int)i).srcVal > newPoint.srcVal) break;
            }
            this.points.add(i, newPoint);
        }
    }

    public static int srcValToShort(int srcId, float val) throws Exception {
        if (srcId < 256) {
            val = srcId >= 84 && srcId <= 95 ? ((srcId & 1) == 0 ? (val *= 16384.0f) : val * 16384.0f * 2.0f - 16384.0f) : (srcId >= 96 && srcId < 99 ? MathUtils.wrap_angleDeg_180(val) * 91.022224f : (val *= 32.768f));
        }
        return Math.round(Math.max(-32767.0f, Math.min(val, 32767.0f)));
    }

    public static Float srcValFromShort(int srcId, int val) throws Exception {
        if (srcId < 256) {
            if (val != Short.MIN_VALUE) {
                if (srcId >= 84 && srcId <= 95) {
                    if ((srcId & 1) == 0) {
                        return new Float((float)Math.round((float)val * 0.0061035156f) / 100.0f);
                    }
                    return new Float((float)Math.round((float)(val + 16384) * 0.0030517578f) / 100.0f);
                }
                if (srcId >= 96 && srcId < 99) {
                    return new Float((float)val * 0.010986328f);
                }
                return new Float((float)Math.round((float)val * 0.30517578f) / 10.0f);
            }
            return null;
        }
        return new Float(val);
    }

    public void write(DataOutputStreamLE out) throws Exception {
        out.writeShort(this.id);
        out.writeShort(this.points.size());
        AdjVarPoint p = this.points.get(0);
        out.writeByte(p.vars.size());
        for (AdjVarValue var : p.vars) {
            out.writeByte(var.varId | (var.isMult ? 128 : 0));
        }
        for (AdjVarPoint point : this.points) {
            out.writeShort(AdjVarSource.srcValToShort(this.id, point.srcVal));
            for (AdjVarValue var : point.vars) {
                out.writeFloat(var.varVal);
            }
        }
    }

    public static AdjVarSource read(DataInputStreamLE in) throws Exception {
        int id = in.readShort();
        int pointsNum = in.readShort();
        if (pointsNum > 1000) {
            throw new Exception("Number of points (" + pointsNum + ") exceeds maximum (" + 1000 + ")");
        }
        int varsNum = in.readByte();
        if (varsNum > 20) {
            throw new Exception("Number of variables (" + varsNum + ") exceeds maximum (" + 20 + ")");
        }
        int[] varIds = new int[varsNum];
        for (int i = 0; i < varsNum; ++i) {
            varIds[i] = in.readByte();
        }
        AdjVarSource src = new AdjVarSource(id);
        src.points.ensureCapacity(pointsNum);
        for (int i = 0; i < pointsNum; ++i) {
            Float srcVal = AdjVarSource.srcValFromShort(id, in.readShort());
            AdjVarPoint point = new AdjVarPoint(srcVal != null ? srcVal.floatValue() : 0.0f, 0);
            point.vars.ensureCapacity(varsNum);
            for (int k = 0; k < varsNum; ++k) {
                float val = in.readFloat();
                point.vars.add(new AdjVarValue(varIds[k] & 0x7F, val, (varIds[k] & 0x80) != 0));
            }
            src.points.add(point);
        }
        return src;
    }

    public static Integer srcNameToInteger(String srcName) throws Exception {
        Integer srcId = null;
        if (Utils.isInteger(srcName)) {
            srcId = Utils.toInteger(srcName);
        } else {
            srcId = ScriptCmdParam.rcSrcNameToInteger(srcName);
            if (srcId == null) {
                srcId = SIGNAL_SRC_NAMES.get(srcName);
            }
        }
        if (srcId == null) {
            throw new Exception("Unknown signal source: " + srcName);
        }
        return srcId;
    }

    public static String srcIntegerToName(Integer srcId) {
        String srcName = ScriptCmdParam.rcSrcIntegerToName(srcId);
        if (srcName == null) {
            for (Map.Entry<String, Integer> entry : SIGNAL_SRC_NAMES.entrySet()) {
                if (srcId == null || !srcId.equals(entry.getValue())) continue;
                return entry.getKey();
            }
            srcName = Integer.toString(srcId);
        }
        return srcName;
    }

    public static ArrayList<Sprav> getSignalSourceList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        for (Map.Entry<String, Integer> entry : ScriptCmdParam.RC_SRC_NAMES.entrySet()) {
            list.add(new Sprav(entry.getValue(), entry.getKey()));
        }
        for (Map.Entry<String, Integer> entry : SIGNAL_SRC_NAMES.entrySet()) {
            list.add(new Sprav(entry.getValue(), entry.getKey()));
        }
        return list;
    }

    static {
        SIGNAL_SRC_NAMES.put("MOMENTUM_ROLL", 256);
        SIGNAL_SRC_NAMES.put("MOMENTUM_PITCH", 257);
        SIGNAL_SRC_NAMES.put("MOMENTUM_YAW", 258);
        SIGNAL_SRC_NAMES.put("BAT_LEVEL", 259);
    }
}

