/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import sbgc.bode_plot.BodeConfig;
import sbgc.bode_plot.Complex;
import sbgc.bode_plot.Extremum;

public class BodeResult
implements Cloneable {
    public static final int TYPE_SYSTEM_RESP = 1;
    public static final int TYPE_VECTOR_AMPLITUDE = 2;
    public int type = 1;
    private float[] phase;
    private float[] gain;
    private String name;
    private float[] gluePhase;
    private Complex[] response;
    private boolean visible = true;
    public int system = -1;
    public int axis = -1;
    public int sensor = -1;
    public int stimulus = -1;
    public int stimulus_gain = 0;
    public float startFreq = 1.0f;
    public float endFreq = 300.0f;
    ArrayList<BodeResult> subResultList = null;

    public boolean isPlant() {
        return (this.system & 4) > 0 && (this.system & 1) == 0;
    }

    public float[] getGluePhase() {
        return this.gluePhase;
    }

    public float getGluePhaseAtFreq(float freq) {
        float[] phase = this.getGluePhase();
        int i = (int)Math.floor(freq / 0.61035156f);
        float f1 = (float)i * 0.61035156f;
        return phase[i] + (phase[i + 1] - phase[i]) * (freq - f1) / 0.61035156f;
    }

    public void setGain(float[] gain) {
        this.gain = gain;
    }

    public void setPhase(float[] phaseList) {
        this.phase = phaseList;
        this.gluePhase = (float[])(this.phase != null ? BodeResult.unwrapPhase(this.phase) : null);
    }

    public static Complex[] getResponseAtFreq(Complex[] r, float[] freqArr) {
        int j;
        int idx;
        Complex[] resp = new Complex[1024];
        int prev_idx = -1;
        int first_idx = 0;
        Complex acc = null;
        double acc_mod = 0.0;
        int acc_cnt = 0;
        for (int i = 0; i < r.length && (idx = BodeResult.getIdxByFreq(freqArr[i] + 0.5f)) < resp.length; ++i) {
            if (idx == prev_idx && acc != null) {
                acc.inc(r[i]);
                acc_mod += r[i].abs();
                ++acc_cnt;
            } else {
                if (prev_idx >= 0) {
                    if (acc_cnt > 1) {
                        acc.setModule(acc_mod / (double)acc_cnt);
                    }
                    for (int j2 = prev_idx; j2 < idx; ++j2) {
                        resp[j2] = new Complex(acc);
                    }
                } else {
                    first_idx = idx;
                }
                acc = new Complex(r[i]);
                acc_mod = r[i].abs();
                acc_cnt = 1;
            }
            prev_idx = idx;
        }
        for (j = prev_idx; j < resp.length; ++j) {
            if (resp[j] != null) continue;
            resp[j] = new Complex(resp[j - 1]);
        }
        for (j = first_idx; j > 0; --j) {
            resp[j - 1] = resp[j];
        }
        return resp;
    }

    public void setResponseAtFreq(Complex[] r, float[] freqArr) {
        this.setResponse(BodeResult.getResponseAtFreq(r, freqArr));
    }

    public void setResponse(Complex[] r) {
        this.response = r;
        float[] new_gain = new float[r.length];
        float[] new_phase = new float[r.length];
        for (int i = 0; i < r.length; ++i) {
            double abs = r[i].abs();
            if (abs > 0.0) {
                new_gain[i] = 20.0f * (float)Math.log10(abs);
                new_phase[i] = (float)r[i].phase() * 57.29578f;
                continue;
            }
            new_gain[i] = Float.NaN;
            new_phase[i] = 0.0f;
        }
        this.setGain(new_gain);
        this.setPhase((float[])(this.hasPhase() ? new_phase : null));
    }

    public Complex[] getResponse() {
        return this.response;
    }

    public float[] smoothPhase() {
        this.gluePhase = BodeResult.calcGaussSmooth(this.gluePhase);
        return BodeResult.wrapPhase(this.gluePhase);
    }

    public float[] getGain() {
        return this.gain;
    }

    public static int getIdxByFreq(float freq) {
        return (int)Math.floor(freq / 0.61035156f);
    }

    public static float getValAtFreq(float freq, float[] values) {
        int i = BodeResult.getIdxByFreq(freq);
        float f1 = (float)i * 0.61035156f;
        return values[i] + (values[i + 1] - values[i]) * (freq - f1) / 0.61035156f;
    }

    public static Complex getValAtFreq(float freq, float freq_width, Complex[] values) {
        if (freq_width < 1.8310547f) {
            int i = BodeResult.getIdxByFreq(freq);
            float f1 = (float)i * 0.61035156f;
            return Complex.interpolate(values[i], values[i + 1], (freq - f1) / 0.61035156f);
        }
        int i1 = Math.max(0, BodeResult.getIdxByFreq(freq - freq_width / 2.0f));
        int i2 = Math.min(values.length, BodeResult.getIdxByFreq(freq + freq_width / 2.0f));
        Complex avg = new Complex();
        double mod_sum = 0.0;
        int cnt = 0;
        for (int i = i1; i < i2; ++i) {
            avg.inc(values[i]);
            mod_sum += values[i].abs();
            ++cnt;
        }
        if (cnt > 0) {
            avg.setModule(mod_sum / (double)cnt);
        }
        return avg;
    }

    public static float getFreqAtIndex(float i) {
        return i * 0.61035156f + 0.001f;
    }

    public float[] getPhase() {
        return this.phase;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static float[] calcGaussSmooth(float[] func) {
        float[] newPointList = new float[func.length];
        for (int i = 0; i < func.length; ++i) {
            newPointList[i] = BodeResult.calcSmoothPoint(func, i);
        }
        return newPointList;
    }

    private static float calcSmoothPoint(float[] func, int pos) {
        float sum = 0.0f;
        for (int i = 0; i < BodeConfig.gaussCoeff.length; ++i) {
            int idx = Math.min(pos + i, func.length - 1);
            sum += BodeConfig.gaussCoeff[i] * func[idx];
            if (i <= 0) continue;
            idx = Math.max(pos - i, 0);
            sum += BodeConfig.gaussCoeff[i] * func[idx];
        }
        return sum;
    }

    public static Extremum calcExtremum(float[] func) {
        float min = func[0];
        float max = func[0];
        for (float point : func) {
            if (Float.isNaN(point)) continue;
            if (point > max) {
                max = point;
                continue;
            }
            if (!(point < min)) continue;
            min = point;
        }
        return new Extremum(max, min);
    }

    public static List<Point2D.Float> calcPhaseCycling(float[] phaseFunc) {
        ArrayList<Point2D.Float> pointsList = new ArrayList<Point2D.Float>();
        float phaseWrapThreshold = 180.0f;
        for (int i = 0; i < phaseFunc.length - 1; ++i) {
            float pointsDiff = phaseFunc[i] - phaseFunc[i + 1];
            if (i > 0 && Math.abs(pointsDiff) > phaseWrapThreshold) {
                float newX = 0.0f;
                pointsList.add(new Point2D.Float(i, phaseFunc[i]));
                if (pointsDiff > 0.0f) {
                    newX = (phaseWrapThreshold - phaseFunc[i]) / (phaseFunc[i + 1] - phaseFunc[i]) * 1.0f + (float)(i + 1);
                    pointsList.add(new Point2D.Float(newX, phaseWrapThreshold));
                    pointsList.add(new Point2D.Float(newX, -phaseWrapThreshold));
                    continue;
                }
                newX = (phaseWrapThreshold + phaseFunc[i]) / (phaseFunc[i] - phaseFunc[i + 1]) * 1.0f + (float)(i + 1);
                pointsList.add(new Point2D.Float(newX, -phaseWrapThreshold));
                pointsList.add(new Point2D.Float(newX, phaseWrapThreshold));
                continue;
            }
            pointsList.add(new Point2D.Float(i, phaseFunc[i]));
        }
        return pointsList;
    }

    public static float[] unwrapPhase(float[] func) {
        float offset = 0.0f;
        float[] glueFunc = new float[func.length];
        for (int i = 0; i < func.length; ++i) {
            glueFunc[i] = func[i] + offset;
            if (i >= func.length - 1) continue;
            float diff = func[i + 1] - func[i];
            if (diff > 180.0f) {
                offset -= 360.0f;
                continue;
            }
            if (!(diff < -180.0f)) continue;
            offset += 360.0f;
        }
        return glueFunc;
    }

    private static float[] wrapPhase(float[] func) {
        float[] splitFunc = new float[func.length];
        for (int i = 0; i < func.length; ++i) {
            float x = (func[i] + 180.0f) % 360.0f;
            x = x >= 0.0f ? (x -= 180.0f) : (x += 180.0f);
            splitFunc[i] = x;
        }
        return splitFunc;
    }

    public static Float getCrossing(float[] func, float threshold) {
        for (int i = 0; i < func.length - 1; ++i) {
            if (!(func[i] > threshold) || !(func[i + 1] < threshold)) continue;
            return Float.valueOf(0.61035156f * ((float)i + (func[i] - threshold) / (func[i] - func[i + 1])));
        }
        return null;
    }

    public boolean canGetPhaseGainMargin() {
        return (this.system & 4) > 0 && (this.system & 1) > 0;
    }

    public BodeResult clone() {
        try {
            BodeResult copy = (BodeResult)super.clone();
            return copy;
        }
        catch (CloneNotSupportedException ignore) {
            return null;
        }
    }

    public void addSubResult(BodeResult subResult) {
        if (this.subResultList == null) {
            this.subResultList = new ArrayList();
        }
        this.subResultList.add(subResult);
    }

    public List<BodeResult> getSubResultList() {
        return this.subResultList;
    }

    public boolean hasPhase() {
        return this.type != 2;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public boolean isVisible() {
        return this.visible;
    }
}

