/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

public class Complex {
    public static final Complex complex0 = new Complex(0.0f, 0.0f);
    public static final Complex complex1 = new Complex(1.0f, 0.0f);
    private float re;
    private float im;

    public Complex(float real, float imag) {
        this.re = real;
        this.im = imag;
    }

    public Complex(Complex a) {
        this.re = a.re;
        this.im = a.im;
    }

    public Complex() {
        this.re = 0.0f;
        this.im = 0.0f;
    }

    public String toString() {
        if (this.im == 0.0f) {
            return this.re + "";
        }
        if (this.re == 0.0f) {
            return this.im + "i";
        }
        if (this.im < 0.0f) {
            return this.re + " - " + -this.im + "i";
        }
        return this.re + " + " + this.im + "i";
    }

    public double abs() {
        return Math.hypot(this.re, this.im);
    }

    public double pow2() {
        return this.re * this.re + this.im * this.im;
    }

    public double phase() {
        return Math.atan2(this.im, this.re);
    }

    public void inc(Complex b) {
        this.re += b.re;
        this.im += b.im;
    }

    public Complex plus(Complex b) {
        Complex a = this;
        float real = a.re + b.re;
        float imag = a.im + b.im;
        return new Complex(real, imag);
    }

    public Complex minus(Complex b) {
        Complex a = this;
        float real = a.re - b.re;
        float imag = a.im - b.im;
        return new Complex(real, imag);
    }

    public Complex times(Complex b) {
        return new Complex(this.re * b.re - this.im * b.im, this.re * b.im + this.im * b.re);
    }

    public Complex times(float alpha) {
        return new Complex(alpha * this.re, alpha * this.im);
    }

    public void mult(float val) {
        this.re *= val;
        this.im *= val;
    }

    public void mult(Complex b) {
        float real = this.re * b.re - this.im * b.im;
        this.im = this.re * b.im + this.im * b.re;
        this.re = real;
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public Complex reciprocal() {
        float scale = this.re * this.re + this.im * this.im;
        return new Complex(this.re / scale, -this.im / scale);
    }

    public float re() {
        return this.re;
    }

    public float im() {
        return this.im;
    }

    public Complex divides(Complex b) {
        return this.times(b.reciprocal());
    }

    public Complex divides(Float b) {
        return new Complex(this.re / b.floatValue(), this.im / b.floatValue());
    }

    public void div(Float b) {
        this.re /= b.floatValue();
        this.im /= b.floatValue();
    }

    public Complex exp() {
        return new Complex((float)(Math.exp(this.re) * Math.cos(this.im)), (float)(Math.exp(this.re) * Math.sin(this.im)));
    }

    public Complex sin() {
        return new Complex((float)(Math.sin(this.re) * Math.cosh(this.im)), (float)(Math.cos(this.re) * Math.sinh(this.im)));
    }

    public Complex cos() {
        return new Complex((float)(Math.cos(this.re) * Math.cosh(this.im)), (float)(-Math.sin(this.re) * Math.sinh(this.im)));
    }

    public Complex tan() {
        return this.sin().divides(this.cos());
    }

    public static Complex plus(Complex a, Complex b) {
        float real = a.re + b.re;
        float imag = a.im + b.im;
        Complex sum = new Complex(real, imag);
        return sum;
    }

    public static Complex interpolate(Complex c1, Complex c2, float rate) {
        Complex res = new Complex(c1.re + (c2.re - c1.re) * rate, c1.im + (c2.im - c1.im) * rate);
        res.setModule(c1.abs() + (c2.abs() - c1.abs()) * (double)rate);
        return res;
    }

    public void setModule(double new_mod) {
        double cur_mod = this.abs();
        if (cur_mod != 0.0) {
            this.mult((float)(new_mod / cur_mod));
        } else {
            this.re = (float)new_mod;
            this.im = 0.0f;
        }
    }

    public static void fillArr(Complex[] arr, Complex template) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = new Complex(template);
        }
    }
}

