/*
 * Decompiled with CFR 0.152.
 */
package sbgc.bode_plot;

import sbgc.bode_plot.Complex;
import sbgc.utils.LinearRegression;
import sbgc.utils.LogScale;

class ExtendedResp {
    static final float FREQ_RANGE_TO_EXTRAPOLATE = 10.0f;
    final LogScale freqLogScale;
    public final Complex[] resp;
    final float[] gain_ab;
    final Complex phase;

    public ExtendedResp(float startFreq, Complex[] resp, LogScale freqLogScale) {
        this.resp = resp;
        this.freqLogScale = freqLogScale;
        LinearRegression lr = new LinearRegression();
        this.phase = new Complex();
        int n_max = Math.max(2, (int)freqLogScale.to_log(10.0f));
        for (int n = 0; n < n_max; ++n) {
            lr.addData(n, LogScale.linear_to_dB2((float)resp[n].pow2()), 1.0f);
            this.phase.inc(resp[n]);
        }
        this.gain_ab = lr.calculate();
        this.phase.setModule(1.0);
    }
}

