/*
 * Decompiled with CFR 0.152.
 */
package sbgc.common;

import java.util.Date;
import sbgc.common.IFirmwareInfo;
import sbgc.object.Sprav;
import sbgc.service.upgrade.VersionImpl;

public class FirmwareInfoImpl
extends Sprav
implements IFirmwareInfo {
    public static final int FLAG_TEST = 1;
    public static final int FLAG_ENCODERS = 4;
    public static final int FLAG_TRIAL = 8;
    public static final int FLAG_LIMITED = 16;
    public static final int FLAG_EXPERIMENTAL = 32;
    private int version = -1;
    private int buildNumber;
    private int gui_version = -1;
    private String gui_url = null;
    private int versionId = -1;
    private String title = null;
    private String description = null;
    private Date regDate = null;
    private int flags = 0;

    public FirmwareInfoImpl(int version, int versionId, int buildNumber, String title, String description, Date regDate, int gui_version, String gui_url, int flags) {
        super(version, FirmwareInfoImpl.getVersionName(version, buildNumber));
        this.version = version;
        this.versionId = versionId;
        this.buildNumber = buildNumber;
        this.title = title;
        this.description = description;
        this.regDate = regDate;
        this.gui_version = gui_version;
        this.gui_url = gui_url;
        this.flags = flags;
    }

    public static String getVersionName(int ver, int buildNumber) {
        return new VersionImpl(ver, buildNumber).toString();
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public int getGUIVersion() {
        return this.gui_version;
    }

    @Override
    public String getGUIUrl() {
        return this.gui_url;
    }

    public void setVersionId(int versionId) {
        this.versionId = versionId;
    }

    @Override
    public int getVersionId() {
        return this.versionId;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setRegDate(Date regDate) {
        this.regDate = regDate;
    }

    @Override
    public Date getRegDate() {
        return this.regDate;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.title != null) {
            buf.append(this.title);
        } else {
            buf.append(FirmwareInfoImpl.getVersionName(this.version, this.buildNumber));
        }
        if (this.isBeta()) {
            buf.append(" [beta]");
        }
        if (this.isExperimental()) {
            buf.append(" [exp!]");
        }
        return buf.toString();
    }

    @Override
    public boolean isBeta() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isExperimental() {
        return (this.flags & 0x20) != 0;
    }
}

