/*
 * Decompiled with CFR 0.152.
 */
package sbgc.imu_calib;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jdesktop.application.ResourceMap;
import sbgc.imu_calib.ExtRefDataSample;
import sbgc.imu_calib.IExtRefSensorCalib;
import sbgc.imu_calib.SensorCalib;
import sbgc.object.BoardInfo;
import sbgc.object.IMUCalib;
import sbgc.service.CommandResponseListener;
import sbgc.service.RealtimeDataThread;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandDispatcher;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.DataLogger;
import sbgc.utils.Log;
import simplebgc_gui.DialogProgress;
import simplebgc_gui.SimpleBGC_GUIApp;

public abstract class AdvancedCalibBase
implements Runnable,
IProgressListener {
    protected static Log logger = null;
    public static ResourceMap resourceMap = null;
    public static final int CALIB_MODE_EXT_IMU_GYRO = 27;
    public static final int CALIB_MODE_EXT_IMU_ALIGN = 28;
    public static final int CALIB_MODE_ACC_GYRO_MULTIPOINT = 34;
    public static final int CALIB_ACTION_STOP = 0;
    public static final int CALIB_ACTION_START = 1;
    public static final int DATA_TIME_ERROR_MAX_MS = 100;
    public static final String LOG_DATA_TO_FILE = "advanced_calib.csv";
    public static final String LOAD_DATA_FROM_FILE = null;
    protected IExtRefSensorCalib extRefSensorCalibListener = null;
    protected ExtRefDataSample[] samples = null;
    IMUCalib imuCalib;
    protected int calibMode;
    protected DialogProgress progressDialog = null;

    protected AdvancedCalibBase(IExtRefSensorCalib extRefSensorCalibListener, IMUCalib imuCalib, int calibMode, int dataSamples) {
        if (resourceMap == null) {
            resourceMap = SimpleBGC_GUIApp.getResourceMap();
        }
        if (logger == null) {
            logger = Log.getLogger(AdvancedCalibBase.class.getName());
        }
        this.extRefSensorCalibListener = extRefSensorCalibListener;
        this.imuCalib = imuCalib;
        this.calibMode = calibMode;
        this.samples = new ExtRefDataSample[dataSamples];
        this.progressDialog = new DialogProgress((Frame)SimpleBGC_GUIApp.mainView.getFrame(), resourceMap.getString("title.ext_gyro_calib", new Object[0]));
    }

    public void start() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.info(String.format("Starting advanced calibration %d..", this.calibMode));
        boolean oldRTState = RealtimeDataThread.pause(true);
        this.progressDialog.showDialogNewThread();
        try {
            if (BoardInfo.isDebugMode() && LOAD_DATA_FROM_FILE != null) {
                BufferedReader reader = new BufferedReader(new FileReader(DataLogger.logFileByName(LOAD_DATA_FROM_FILE)));
                String headerLine = reader.readLine();
                this.samples = ExtRefDataSample.readFromFile(reader);
                for (int i = 0; i < this.samples.length; ++i) {
                    this.onSampleAdded(i);
                }
            } else {
                for (int n = 3; n > 0; --n) {
                    this.progressDialog.setState(false, "Calibration starts in " + n + " seconds..");
                    Thread.sleep(1000L);
                }
                SerialCommand cmd = new SerialCommand(115);
                cmd.writeByte(this.calibMode);
                cmd.writeByte(1);
                cmd.writeEmptyArr(18);
                if (!CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L)) {
                    throw new Exception("No confirmation on calibration command");
                }
                int sampleCnt = 0;
                int extSampleCntPrev = -1;
                int sampleCntErr = 0;
                int progress = 0;
                CommandResponseListener cmdDataListener = new CommandResponseListener(115);
                SerialCommandDispatcher.getInstance().addResponseListener(cmdDataListener);
                try {
                    while (sampleCnt < this.samples.length) {
                        try {
                            SerialCommand dataCmd = cmdDataListener.waitShort(3000L);
                            if (dataCmd == null) {
                                throw new Exception("Timeout waiting data, calibration interrupted.");
                            }
                            if (dataCmd.id == 115) {
                                ExtRefDataSample s = new ExtRefDataSample(dataCmd, this.calibMode);
                                if (s.isSampleMissed(extSampleCntPrev)) {
                                    ++sampleCntErr;
                                }
                                extSampleCntPrev = s.sampleCnt;
                                this.samples[sampleCnt] = s;
                                this.onSampleAdded(sampleCnt);
                                ++sampleCnt;
                            }
                            if (!this.progressDialog.onProgressChange(progress = sampleCnt * 100 / this.samples.length)) {
                                throw new Exception("Calibration interrupted by user.");
                            }
                            if (!this.progressDialog.isFinished()) continue;
                            this.samples = Arrays.copyOf(this.samples, sampleCnt);
                        }
                        catch (InterruptedException ignore) {
                            // empty catch block
                        }
                        break;
                    }
                }
                finally {
                    this.sendStopCalibCmd();
                    SerialCommandDispatcher.getInstance().removeResponseListener(cmdDataListener);
                }
                if (LOG_DATA_TO_FILE != null) {
                    try {
                        DataLogger dataLogger = new DataLogger(LOG_DATA_TO_FILE, false);
                        dataLogger.setHeader(this.getDataFields());
                        ExtRefDataSample.logToFile(this.samples, dataLogger);
                        dataLogger.finish();
                    }
                    catch (Exception e) {
                        logger.error("Failed to start data logging: " + e.toString());
                    }
                }
                if (sampleCntErr > 10 && !this.confirmWarningAndContinue(String.format("Missed data samples: %d.\nIt may lead to incorrect result.", sampleCntErr))) {
                    throw new Exception("Cancelled by user.");
                }
            }
            this.progressDialog.setAction("Computing calibration values..");
            this.progressDialog.showState(false);
            this.process();
        }
        catch (Exception e) {
            logger.error(e.toString());
            SimpleBGC_GUIApp.mainView.showErrorMessage("Calibration not finished: " + e.getMessage());
        }
        finally {
            this.progressDialog.onProgressFinish(true);
            RealtimeDataThread.pause(oldRTState);
        }
    }

    void sendStopCalibCmd() {
        try {
            SerialCommand cmd = new SerialCommand(115);
            cmd.writeByte(this.calibMode);
            cmd.writeByte(0);
            cmd.writeEmptyArr(18);
            SerialCommandProcessor.sendCommand(cmd);
        }
        catch (Exception ee) {
            logger.stackTrace(ee);
        }
    }

    abstract void process() throws Exception;

    abstract List<String> getDataFields();

    protected void onCalibrationFinished(final SensorCalib c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AdvancedCalibBase.this.extRefSensorCalibListener != null) {
                    AdvancedCalibBase.this.extRefSensorCalibListener.onExtRefSensorCalibFinished(c);
                }
            }
        });
    }

    @Override
    public void onProgressStart(String statusMsg, boolean modal) {
    }

    @Override
    public boolean onProgressChange(int val) {
        return this.progressDialog.onProgressChange(val);
    }

    @Override
    public void onProgressFinish(boolean isSuccess) {
        this.progressDialog.onProgressFinish(isSuccess);
    }

    public boolean confirmWarningAndContinue(String message) {
        return SimpleBGC_GUIApp.mainView.showConfirmDialog(message + "\nDo you want to continue?");
    }

    protected void onSampleAdded(int sampleIdx) throws Exception {
    }
}

