/*
 * Decompiled with CFR 0.152.
 */
package sbgc.imu_calib;

import java.util.Arrays;
import java.util.List;
import sbgc.imu_calib.AdvancedCalibBase;
import sbgc.imu_calib.ExtRefDataSample;
import sbgc.imu_calib.IExtRefSensorCalib;
import sbgc.imu_calib.SensorCalib;
import sbgc.imu_calib.SensorCalibOptimized;
import sbgc.object.IMUCalib;
import sbgc.optimizer.IOptimizable;
import sbgc.optimizer.IOptimizedParams;
import sbgc.optimizer.SimplexOptimizerImpl;
import sbgc.utils.MathUtils;

public class ExtGyroCalibration
extends AdvancedCalibBase
implements IOptimizable {
    public static final int DATA_SAMPLES_EXT_IMU_GYRO = 600;
    public static final float GYRO_NORMAL_THRESHOLD = 300.0f;

    public ExtGyroCalibration(IExtRefSensorCalib extRefSensorCalibListener, IMUCalib imuCalib, int calibMode) {
        super(extRefSensorCalibListener, imuCalib, calibMode, 600);
    }

    @Override
    List<String> getDataFields() {
        return Arrays.asList("int_gyro_x", "int_gyro_y", "int_gyro_z", "ext_gyro_x", "ext_gyro_y", "ext_gyro_z");
    }

    @Override
    void process() throws Exception {
        if (!ExtRefDataSample.checkSphereDistribution(this.samples, 300.0f)) {
            throw new Exception("Collected data has poor distribution by all axes! Try to repeat calibration with better distribution!");
        }
        SensorCalibOptimized c = new SensorCalibOptimized(SensorCalib.SensorType.GYRO);
        if (this.imuCalib != null) {
            c.loadIMUCalib(this.imuCalib);
        }
        SimplexOptimizerImpl optimizer = new SimplexOptimizerImpl(this, this, false, 2000, 0);
        optimizer.optimize(c);
        if (this.imuCalib != null) {
            c.saveIMUCalib(this.imuCalib);
        }
        this.onCalibrationFinished(c);
    }

    @Override
    public float cost_function(IOptimizedParams p, float progress) throws Exception {
        SensorCalib c = (SensorCalib)((Object)p);
        float[] int_calibrated = new float[3];
        float err = 0.0f;
        for (int i = 0; i < this.samples.length; ++i) {
            ExtRefDataSample s = this.samples[i];
            c.apply(s.int_data, int_calibrated);
            float weight = 0.1f + Math.min(s.ext_mod, 300.0f) * 0.003f;
            MathUtils.vector_dec(int_calibrated, s.ext_data);
            err += MathUtils.vector_pow2(int_calibrated) * weight;
        }
        return err / (float)this.samples.length;
    }

    @Override
    public void iteration_step(IOptimizedParams p, float progress) {
    }
}

