/*
 * Decompiled with CFR 0.152.
 */
package sbgc.imu_calib;

import java.io.BufferedReader;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import sbgc.service.SerialCommand;
import sbgc.utils.DataLogger;
import sbgc.utils.MathUtils;

public class ExtRefDataSample {
    public float[] int_data;
    public float[] ext_data;
    public int dt_us = 0;
    public float ext_mod;
    public int sampleCnt = -1;
    private static final DecimalFormat floatFormatter = new DecimalFormat("0.#####E0", new DecimalFormatSymbols(Locale.ENGLISH));
    public static final int DISTRIBUTION_CONE_NUM = 6;
    public static final float DISTRIBUTION_CONE_COS_ANGLE = 0.5f;

    public ExtRefDataSample() {
        this.int_data = new float[3];
        this.ext_data = new float[3];
    }

    public ExtRefDataSample(SerialCommand cmd, int calibType) throws Exception {
        this.int_data = cmd.readFloat3();
        this.ext_data = cmd.readFloat3();
        if (calibType == 34) {
            this.dt_us = cmd.readWordUnsigned();
        }
        if (cmd.getBytesAvailable() > 0) {
            this.sampleCnt = cmd.readByte();
        }
        this.ext_mod = MathUtils.vector_mod(this.ext_data);
    }

    public boolean isSampleMissed(int sampleCntPrev) {
        if (this.sampleCnt >= 0 && sampleCntPrev >= 0) {
            int delta = this.sampleCnt - sampleCntPrev;
            if (delta < 0) {
                delta += 256;
            }
            return delta != 1;
        }
        return false;
    }

    public static boolean checkSphereDistribution(ExtRefDataSample[] samples, float threshold) {
        float[][] cones = new float[6][];
        int coneNum = 0;
        for (int i = 0; i < samples.length; ++i) {
            ExtRefDataSample s = samples[i];
            if (!(s.ext_mod > threshold)) continue;
            boolean isFound = false;
            for (int c = 0; c < coneNum && !isFound; ++c) {
                if (!(MathUtils.vector_cos_angle(s.ext_data, cones[c]) > 0.5f)) continue;
                isFound = true;
            }
            if (isFound) continue;
            cones[coneNum++] = s.ext_data;
            if (coneNum < 6) continue;
            return true;
        }
        return false;
    }

    private static void appendFloatArr(StringBuffer s, float[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (s.length() > 0) {
                s.append(";");
            }
            s.append(floatFormatter.format(arr[i]));
        }
    }

    public String toCSVString() {
        StringBuffer s = new StringBuffer();
        ExtRefDataSample.appendFloatArr(s, this.int_data);
        ExtRefDataSample.appendFloatArr(s, this.ext_data);
        s.append(";");
        s.append(Integer.toString(this.dt_us));
        return s.toString();
    }

    public static void logToFile(ExtRefDataSample[] samples, DataLogger dataLogger) throws Exception {
        for (int i = 0; i < samples.length; ++i) {
            if (samples[i] == null) continue;
            dataLogger.logData(samples[i].toCSVString());
        }
    }

    public static ExtRefDataSample[] readFromFile(BufferedReader reader) throws Exception {
        String line;
        ArrayList<ExtRefDataSample> list = new ArrayList<ExtRefDataSample>();
        while ((line = reader.readLine()) != null) {
            String[] values = line.split(";");
            assert (values.length == 7);
            ExtRefDataSample s = new ExtRefDataSample();
            for (int i = 0; i < 6; ++i) {
                float val = Float.parseFloat(values[i]);
                if (i < 3) {
                    s.int_data[i] = val;
                    continue;
                }
                s.ext_data[i - 3] = val;
            }
            s.dt_us = Integer.parseInt(values[6]);
            list.add(s);
        }
        return list.toArray(new ExtRefDataSample[0]);
    }
}

