/*
 * Decompiled with CFR 0.152.
 */
package sbgc.imu_calib;

import java.util.Arrays;
import sbgc.object.IMUCalib;
import sbgc.utils.MathUtils;

public class SensorCalib
implements Cloneable {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public final SensorType sensorType;
    public float[] scale = new float[]{1.0f, 1.0f, 1.0f};
    public float[] bias = new float[3];
    public float[] orth_corr = new float[3];
    public float[] align_corr = new float[3];

    public SensorCalib(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    public void apply_orth_corr(float[] v) {
        v[1] = v[1] + v[0] * this.orth_corr[0];
        v[2] = v[2] + (v[0] * this.orth_corr[1] + v[1] * this.orth_corr[2]);
    }

    public void apply(float[] v, float[] res) {
        if (this.sensorType == SensorType.ACC) {
            MathUtils.vector_copy(res, v);
            this.apply_orth_corr(res);
            MathUtils.vector_dec(res, this.bias);
            for (int i = 0; i < 3; ++i) {
                int n = i;
                res[n] = res[n] * this.scale[i];
            }
            MathUtils.vector_rotate(res, this.align_corr);
        } else if (this.sensorType == SensorType.GYRO) {
            for (int i = 0; i < 3; ++i) {
                res[i] = v[i] * this.scale[i];
            }
            this.apply_orth_corr(res);
            MathUtils.vector_dec(res, this.bias);
            MathUtils.vector_rotate(res, this.align_corr);
        } else {
            throw new UnsupportedOperationException("Unknown sensor type: " + (Object)((Object)this.sensorType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIMUCalib(IMUCalib c) {
        IMUCalib iMUCalib = c;
        synchronized (iMUCalib) {
            for (int i = 0; i < 3; ++i) {
                if (this.sensorType == SensorType.GYRO) {
                    c.setGyroBias(i, this.bias[i]);
                    c.setGyroScale(i, this.scale[i]);
                    c.setGyroOrthCorrDeg(i, this.orth_corr[i] * 57.29578f);
                    continue;
                }
                if (this.sensorType != SensorType.ACC) continue;
                c.setAccBias(i, this.bias[i]);
                c.setAccScale(i, this.scale[i]);
                c.setAccOrthCorrDeg(i, this.orth_corr[i] * 57.29578f);
                c.setAccGyroAlignCorrDeg(i, this.align_corr[i] * 57.29578f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadIMUCalib(IMUCalib c) {
        IMUCalib iMUCalib = c;
        synchronized (iMUCalib) {
            for (int i = 0; i < 3; ++i) {
                if (this.sensorType == SensorType.GYRO) {
                    this.bias[i] = c.getGyroBias(i);
                    this.scale[i] = c.getGyroScale(i);
                    this.orth_corr[i] = c.getGyroOrthCorrDeg(i) * ((float)Math.PI / 180);
                    continue;
                }
                if (this.sensorType != SensorType.ACC) continue;
                this.bias[i] = c.getAccBias(i);
                this.scale[i] = c.getAccScale(i);
                this.orth_corr[i] = c.getAccOrthCorrDeg(i) * ((float)Math.PI / 180);
                this.align_corr[i] = c.getAccGyroAlignCorrDeg(i) * ((float)Math.PI / 180);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SensorCalib copy = (SensorCalib)super.clone();
        copy.scale = Arrays.copyOf(this.scale, this.scale.length);
        copy.bias = Arrays.copyOf(this.bias, this.bias.length);
        copy.orth_corr = Arrays.copyOf(this.orth_corr, this.orth_corr.length);
        copy.align_corr = Arrays.copyOf(this.align_corr, this.align_corr.length);
        return copy;
    }

    public String toString() {
        return String.format("scale: [%.4f,%.4f,%.4f], bias: [%.2f,%.2f,%.2f], non-orth: [%.2f,%.2f,%.2f], align: [%.2f,%.2f,%.2f]", Float.valueOf(this.scale[0]), Float.valueOf(this.scale[1]), Float.valueOf(this.scale[2]), Float.valueOf(this.bias[0]), Float.valueOf(this.bias[1]), Float.valueOf(this.bias[2]), Float.valueOf(this.orth_corr[0] * 57.29578f), Float.valueOf(this.orth_corr[1] * 57.29578f), Float.valueOf(this.orth_corr[2] * 57.29578f), Float.valueOf(this.align_corr[0] * 57.29578f), Float.valueOf(this.align_corr[1] * 57.29578f), Float.valueOf(this.align_corr[2] * 57.29578f));
    }

    public static enum SensorType {
        ACC,
        GYRO;

    }
}

