/*
 * Decompiled with CFR 0.152.
 */
package sbgc.imu_calib;

import sbgc.imu_calib.SensorCalib;
import sbgc.optimizer.IOptimizedParams;
import sbgc.utils.LogScale;

public class SensorCalibOptimized
extends SensorCalib
implements IOptimizedParams {
    public static final int OPTIMIZED_PARAMS_NUM = 12;
    public static final float DEFAULT_MAX_SCALE_DELTA = 0.1f;
    public static final float DEFAULT_MAX_BIAS = 100.0f;
    public static final float DEFAULT_MAX_ORTH_CORR_RAD = 0.08726646f;
    public static final float DEFAULT_MAX_ALIGN_CORR_RAD = 0.17453292f;
    public static final float GYRO_MAX_SCALE_DELTA = 0.05f;
    public static final float GYRO_MAX_BIAS = 200.0f;
    public static final int SCALE_IDX = 0;
    public static final int BIAS_IDX = 3;
    public static final int ORTH_CORR_IDX = 6;
    public static final int ALIGN_CORR_IDX = 9;
    LogScale[] params_log_scale = new LogScale[12];
    int optimizedParamsNum = 0;

    public SensorCalibOptimized(SensorCalib.SensorType sensorType) {
        this(sensorType, 0.1f, 100.0f, 0.08726646f, 0.17453292f);
    }

    public SensorCalibOptimized(SensorCalib.SensorType sensorType, float maxScaleDelta, float maxBias, float maxOrthCorr, float maxAlignCorr) {
        super(sensorType);
        for (int i = 0; i < 3; ++i) {
            if (maxScaleDelta > 0.0f) {
                this.params_log_scale[0 + i] = new LogScale(1.0f, 1.0f - maxScaleDelta, 1.0f + maxScaleDelta);
                ++this.optimizedParamsNum;
            }
            if (maxBias > 0.0f) {
                this.params_log_scale[3 + i] = new LogScale(1.0f, -maxBias, maxBias);
                ++this.optimizedParamsNum;
            }
            if (maxOrthCorr > 0.0f) {
                this.params_log_scale[6 + i] = new LogScale(1.0f, -maxOrthCorr, maxOrthCorr);
                ++this.optimizedParamsNum;
            }
            if (!(maxAlignCorr > 0.0f)) continue;
            this.params_log_scale[9 + i] = new LogScale(1.0f, -maxAlignCorr, maxAlignCorr);
            ++this.optimizedParamsNum;
        }
    }

    @Override
    public boolean applyConstraints() {
        return false;
    }

    @Override
    public int getOptimizedParamsNum() {
        return this.optimizedParamsNum;
    }

    @Override
    public void getNormalizedParams(float[] n_params) {
        int n_idx = 0;
        for (int idx = 0; idx < 12; ++idx) {
            if (this.params_log_scale[idx] == null) continue;
            float val = idx < 3 ? this.scale[idx] : (idx < 6 ? this.bias[idx - 3] : (idx < 9 ? this.orth_corr[idx - 6] : this.align_corr[idx - 9]));
            n_params[n_idx++] = this.params_log_scale[idx].to_log(val);
        }
    }

    @Override
    public void setNormalizedParams(float[] n_params, int update_n_idx) throws Exception {
        int n_idx = 0;
        for (int idx = 0; idx < 12; ++idx) {
            if (this.params_log_scale[idx] == null || update_n_idx >= 0 && update_n_idx != n_idx) continue;
            float val = this.params_log_scale[idx].from_log(n_params[n_idx++]);
            if (idx < 3) {
                this.scale[idx] = val;
                continue;
            }
            if (idx < 6) {
                this.bias[idx - 3] = val;
                continue;
            }
            if (idx < 9) {
                this.orth_corr[idx - 6] = val;
                continue;
            }
            this.align_corr[idx - 9] = val;
        }
    }

    @Override
    public boolean isParamEffective(int n_idx) {
        return true;
    }

    @Override
    public boolean increaseStability(float step) {
        return false;
    }
}

