/*
 * Decompiled with CFR 0.152.
 */
package sbgc.mavlink;

import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import sbgc.mavlink.CRC16_X25;
import sbgc.mavlink.IMavLinkCommandListener;
import sbgc.mavlink.MavLinkMessage;
import sbgc.service.IDataPort;
import sbgc.utils.Log;

public class MavLink {
    public static final int MAVLINK_STX_V1 = 254;
    public static final int MAVLINK_STX_V2 = 253;
    static final Log logger = Log.getLogger(MavLink.class.getName());
    IDataPort dataPort;
    IMavLinkCommandListener commandListener = null;
    int system_id = 0;
    int component_id = 0;
    int in_protocol = 0;
    int out_protocol = 2;
    int out_sequence_cnt = 0;
    int in_sequence_cnt = -1;
    long parse_err_cnt = 0L;
    long lost_packet_cnt = 0L;
    long receive_packet_cnt = 0L;
    long sent_packet_cnt = 0L;

    public MavLink(IDataPort dataPort) {
        this.setDataPort(dataPort);
    }

    public final synchronized void setDataPort(IDataPort _dataPort) {
        this.dataPort = _dataPort;
        if (this.dataPort != null) {
            try {
                this.dataPort.removeEventListener();
                this.dataPort.addEventListener(new SerialReader(this.dataPort.getInputStream()));
                this.dataPort.enableReceiveTimeout(500);
                this.in_sequence_cnt = -1;
            }
            catch (Exception e) {
                logger.stackTrace(e);
                this.dataPort = null;
            }
        }
    }

    public void setCommandListener(IMavLinkCommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public int getIn_protocol() {
        return this.in_protocol;
    }

    public long getParse_err_cnt() {
        return this.parse_err_cnt;
    }

    public int getOut_protocol() {
        return this.out_protocol;
    }

    public void setOut_protocol(int out_protocol) {
        this.out_protocol = out_protocol;
    }

    public int getComponent_id() {
        return this.component_id;
    }

    public void setComponent_id(int component_id) {
        this.component_id = component_id;
    }

    public int getSystem_id() {
        return this.system_id;
    }

    public void setSystem_id(int system_id) {
        this.system_id = system_id;
    }

    public long getLost_packet_cnt() {
        return this.lost_packet_cnt;
    }

    public long getReceive_packet_cnt() {
        return this.receive_packet_cnt;
    }

    public String getStats() {
        return "packets received: " + this.receive_packet_cnt + ", lost: " + this.lost_packet_cnt + ", sent: " + this.sent_packet_cnt + ", protocol ver: " + this.in_protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void send(MavLinkMessage msg) {
        block6: {
            msg.system_id = this.system_id;
            msg.component_id = this.component_id;
            msg.sequence_cnt = this.out_sequence_cnt++;
            logger.debug("MavLink OUT:" + msg.toString());
            try {
                if (this.dataPort != null && this.dataPort.isConnected()) {
                    IDataPort iDataPort = this.dataPort;
                    synchronized (iDataPort) {
                        byte[] data = msg.getBytes(this.out_protocol);
                        this.dataPort.sendData(data, 0, data.length);
                        ++this.sent_packet_cnt;
                        break block6;
                    }
                }
                logger.debug("dataPort is not connected, skip sending.");
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
        }
    }

    public class SerialReader
    implements SerialPortEventListener {
        final InputStream in;
        int[] buf = new int[9];
        MavLinkMessage in_msg = new MavLinkMessage(0);
        CRC16_X25 crc = new CRC16_X25();
        static final int PARSE_STATE_IDLE = 0;
        static final int PARSE_STATE_RESYNC = 1;
        int parse_state;

        public SerialReader(InputStream in) {
            this.in = in;
        }

        public void serialEvent(SerialPortEvent arg0) {
            try {
                while (this.in.available() > 0) {
                    int c = this.in.read();
                    if (c == 254 || c == 253) {
                        int cnt;
                        this.crc.init();
                        MavLink.this.in_protocol = c == 254 ? 1 : 2;
                        int need_bytes = MavLink.this.in_protocol == 2 ? 9 : 5;
                        for (int i = 0; i < need_bytes; ++i) {
                            this.buf[i] = this.in.read();
                            if (this.buf[i] < 0) {
                                logger.debug("Incomplete header: InputStream is closed.");
                                return;
                            }
                            this.crc.append(this.buf[i]);
                        }
                        int idx = 0;
                        int length = this.buf[idx++];
                        if (MavLink.this.in_protocol == 2) {
                            this.in_msg.incompat_flags = this.buf[idx++];
                            this.in_msg.compat_flags = this.buf[idx++];
                        }
                        this.in_msg.sequence_cnt = this.buf[idx++];
                        this.in_msg.system_id = this.buf[idx++];
                        this.in_msg.component_id = this.buf[idx++];
                        this.in_msg.id = this.buf[idx++];
                        if (MavLink.this.in_protocol == 2) {
                            int low = this.buf[idx++];
                            int high = this.buf[idx++] << 8;
                            this.in_msg.id |= low + high << 8;
                        }
                        this.in_msg.payload = new byte[length];
                        for (int len = 0; len < length; len += cnt) {
                            cnt = this.in.read(this.in_msg.payload, len, length - len);
                            if (cnt > 0) {
                                continue;
                            }
                            logger.debug("Incomplete payload: InputStream is closed.");
                            return;
                        }
                        int crc_in = this.in.read() + (this.in.read() << 8);
                        this.crc.append(this.in_msg.payload, 0, this.in_msg.payload.length);
                        Integer crc_extra = this.in_msg.get_crc_extra();
                        if (crc_extra != null) {
                            this.crc.append(crc_extra);
                        }
                        if (crc_extra == null || crc_in == this.crc.get()) {
                            logger.debug("MavLink IN: " + this.in_msg.toHeaderString());
                            ++MavLink.this.receive_packet_cnt;
                            if (MavLink.this.in_sequence_cnt != -1) {
                                MavLink.this.in_sequence_cnt = MavLink.this.in_sequence_cnt + 1 & 0xFF;
                                if (MavLink.this.in_sequence_cnt != this.in_msg.sequence_cnt) {
                                    logger.warn("Packet sequence out of sync: " + MavLink.this.in_sequence_cnt + " - " + this.in_msg.sequence_cnt);
                                    ++MavLink.this.lost_packet_cnt;
                                }
                            }
                            MavLink.this.in_sequence_cnt = this.in_msg.sequence_cnt;
                            if (MavLink.this.commandListener != null && MavLink.this.commandListener.onCommandReceived(this.in_msg)) {
                                logger.trace("MavLink #" + this.in_msg.id + " dispatched.");
                            }
                        } else {
                            logger.warn(String.format("wrong checksum for #%d: calculated '%h', received '%h'", this.in_msg.id, this.crc.get(), crc_in));
                            ++MavLink.this.parse_err_cnt;
                        }
                        this.parse_state = 0;
                        continue;
                    }
                    if (this.parse_state == 1) continue;
                    ++MavLink.this.parse_err_cnt;
                    this.parse_state = 1;
                }
            }
            catch (IOException e) {
                logger.warn("IO Exception: " + e.toString());
                ++MavLink.this.parse_err_cnt;
                this.parse_state = 1;
            }
            catch (Exception e) {
                logger.stackTrace(e);
            }
        }
    }
}

