/*
 * Decompiled with CFR 0.152.
 */
package sbgc.mavlink;

import java.util.HashMap;
import sbgc.mavlink.CRC16_X25;
import sbgc.service.SerialCommand;

public class MavLinkMessage {
    public static final int MSG_ID_HEARTBEAT = 0;
    public static final int MSG_ID_V2_EXTENSION = 248;
    public static final int MSG_ID_TUNNEL = 385;
    public static final int MAV_TYPE_GCS = 6;
    public static final int MAV_AUTOPILOT_INVALID = 8;
    static final HashMap<Integer, Integer> CRC_EXTRA = new HashMap();
    public int sequence_cnt;
    public int system_id;
    public int component_id;
    public int id;
    public byte[] payload = null;
    public int incompat_flags;
    public int compat_flags;

    public MavLinkMessage(int id) {
        this.id = id;
    }

    public String toHeaderString() {
        return "#" + this.id + "(" + this.system_id + "," + this.component_id + ")[" + (this.payload != null ? Integer.valueOf(this.payload.length) : "null") + "]";
    }

    public String toString() {
        return "#" + this.id + "(" + this.system_id + "," + this.component_id + ")[" + (this.payload != null ? SerialCommand.dumpBytes(this.payload, this.payload.length) : "null") + "]";
    }

    public Integer get_crc_extra() {
        return CRC_EXTRA.get(this.id);
    }

    public byte[] getBytes(int protocol) throws Exception {
        byte[] buf = new byte[(protocol == 2 ? 12 : 8) + this.payload.length];
        int i = 0;
        buf[i++] = (byte)(protocol == 2 ? 253 : 254);
        buf[i++] = (byte)this.payload.length;
        if (protocol == 2) {
            buf[i++] = (byte)this.incompat_flags;
            buf[i++] = (byte)this.compat_flags;
        }
        buf[i++] = (byte)this.sequence_cnt;
        buf[i++] = (byte)this.system_id;
        buf[i++] = (byte)this.component_id;
        buf[i++] = (byte)(this.id & 0xFF);
        if (protocol == 2) {
            buf[i++] = (byte)(this.id >> 8 & 0xFF);
            buf[i++] = (byte)(this.id >> 16 & 0xFF);
        }
        for (int j = 0; j < this.payload.length; ++j) {
            buf[i++] = this.payload[j];
        }
        CRC16_X25 crc = new CRC16_X25();
        crc.append(buf, 1, buf.length - 3);
        Integer crc_extra = this.get_crc_extra();
        if (crc_extra == null) {
            throw new Exception("CRC_EXTRA is not defined for #" + this.id);
        }
        crc.append(crc_extra);
        buf[i++] = (byte)(crc.get() & 0xFF);
        buf[i++] = (byte)(crc.get() >> 8 & 0xFF);
        return buf;
    }

    static {
        CRC_EXTRA.put(0, 50);
        CRC_EXTRA.put(248, 8);
        CRC_EXTRA.put(385, 147);
    }
}

