/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import sbgc.service.SerialCommand;

@XStreamAlias(value="adj-var-analog-cfg")
public class AdjVarAnalogCfg
implements Cloneable {
    public int src_ch = 0;
    public int var_id = 0;
    public boolean isMultType = false;
    public int min_val = 0;
    public int max_val = 255;
    public static final int ADJ_VAR_IDX_MASK = 127;
    public static final int ADJ_VAR_IDX_FLAG_MULTIPLIER = 128;

    public void readCfgCmd(SerialCommand cmd) throws IOException {
        this.src_ch = cmd.readByte();
        int idx = cmd.readByte();
        this.var_id = idx & 0x7F;
        this.isMultType = (idx & 0x80) != 0;
        this.min_val = cmd.readByte();
        this.max_val = cmd.readByte();
    }

    public void writeCfgCmd(SerialCommand cmd) throws IOException {
        cmd.writeByte(this.src_ch);
        cmd.writeByte(this.var_id | (this.isMultType ? 128 : 0));
        cmd.writeByte(this.min_val);
        cmd.writeByte(this.max_val);
    }

    public AdjVarAnalogCfg clone() throws CloneNotSupportedException {
        AdjVarAnalogCfg copy = (AdjVarAnalogCfg)super.clone();
        return copy;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AdjVarAnalogCfg)) {
            return false;
        }
        AdjVarAnalogCfg other = (AdjVarAnalogCfg)o;
        return this.src_ch == other.src_ch && this.var_id == other.var_id && this.min_val == other.min_val && this.max_val == other.max_val;
    }
}

