/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import sbgc.object.BoardParams;
import sbgc.utils.Settings;

public class AutoPIDCfg {
    public static final int FLAG_ROLL = 1;
    public static final int FLAG_PITCH = 2;
    public static final int FLAG_YAW = 4;
    public static final int FLAG_SEND_GUI = 8;
    public static final int FLAG_KEEP_CURRENT = 16;
    public static final int FLAG_TUNE_LPF = 32;
    public static final int FLAG_ALL_PROFILES = 64;
    public static final int CFG_FLAGS_DEFAULT = 63;
    public int flags = 0;
    public int gain = 127;
    public int stimulus_gain = 127;

    public void fromParams(BoardParams params) {
        this.flags = params.auto_pid_cfg;
        this.gain = params.auto_pid_precision;
        this.stimulus_gain = params.auto_pid_momentum;
    }

    public void toParams(BoardParams params) {
        params.auto_pid_cfg = this.flags;
        params.auto_pid_precision = this.gain;
        params.auto_pid_momentum = this.stimulus_gain;
    }

    public void loadFromSettings() {
        this.flags = Integer.parseInt(Settings.get("auto_pid.flags", Integer.toString(63)));
        this.gain = Integer.parseInt(Settings.get("auto_pid.gain", "127"));
        this.stimulus_gain = Integer.parseInt(Settings.get("auto_pid.stimulus_gain", "127"));
    }

    public void saveToSettings() {
        Settings.set("auto_pid.flags", Integer.toString(this.flags));
        Settings.set("auto_pid.gain", Integer.toString(this.gain));
        Settings.set("auto_pid.stimulus_gain", Integer.toString(this.stimulus_gain));
        Settings.save();
    }

    public boolean isRollSelected() {
        return (this.flags & 1) > 0;
    }

    public boolean isPitchSelected() {
        return (this.flags & 2) > 0;
    }

    public boolean isYawSelected() {
        return (this.flags & 4) > 0;
    }

    public boolean isAxisSelected(int axis) {
        return (this.flags & 1 << axis) > 0;
    }

    public void setAxis(int axis) {
        this.flags = this.flags & 0xFFFFFFF8 | 1 << axis;
    }

    public boolean isSendGUI() {
        return (this.flags & 8) > 0;
    }

    public boolean isStartFromCurrent() {
        return (this.flags & 0x10) > 0;
    }

    public boolean isTuneLPF() {
        return (this.flags & 0x20) > 0;
    }

    public boolean isAllProfiles() {
        return (this.flags & 0x40) > 0;
    }
}

