/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Arrays;
import sbgc.object.BoardParams;
import sbgc.service.SerialCommand;
import sbgc.utils.MathUtils;
import sbgc.utils.Settings;

public class AutoPIDCfg2
implements Cloneable {
    public static final int CUR_VERSION = 1;
    public static final int STARTUP_GAIN_ONLY = 1;
    public static final int STARTUP_ALL_PARAMS = 2;
    public static final int CMD_ACTION_START = 1;
    public static final int CMD_ACTION_START_SAVE = 2;
    public static final int CMD_ACTION_SAVE = 3;
    public static final int CMD_ACTION_STOP = 5;
    public static final int CMD_ACTION_READ = 6;
    public static final int CMD_FLAG_SEND_CONFIG = 1;
    public static final int G_FLAG_KEEP_CURRENT = 1;
    public static final int G_FLAG_ALL_PROFILES = 2;
    public static final int G_FLAG_TUNE_GAIN_ONLY = 4;
    public static final int G_FLAG_USE_STORED_RESP = 8;
    public static final int G_FLAG_AUTO_SAVE = 16;
    public static final int G_FLAG_STARTUP_ALL = 16384;
    public static final int G_FLAG_STARTUP_GAIN = 32768;
    public static final int G_FLAG_STARTUP_MASK = 49152;
    public static final int A_FLAG_ENABLED = 1;
    public static final int A_FLAG_TUNE_LPF = 2;
    public static final int A_FLAG_TUNE_NOTCH = 12;
    public static final float FREQ_RANGE_START_DEF = 1.0f;
    public static final float FREQ_RANGE_END_DEF = 300.0f;
    public int general_flags;
    public int rnd_seed_num;
    public int[] axis_flags = new int[3];
    public int[] gain = new int[3];
    public int[] stimulus_gain = new int[3];
    public int[] effective_freq = new int[3];
    public int[] problem_freq = new int[3];
    public float[] problem_margin = new float[3];
    public float freqFrom;
    public float freqTo;
    public int mult_pos_enabled;
    public int[] mult_pos_angles = new int[4];
    public int[] axis_reserved = new int[6];
    public int[] general_reserved = new int[12];
    public static final int RESPONSE_GC_NEW = 1;
    public static final int RESPONSE_GC_OLD = 2;
    public static final int RESPONSE_C_NEW = 4;
    public static final int RESPONSE_C_OLD = 8;
    @XStreamOmitField
    public boolean multiple_systems;
    @XStreamOmitField
    public int show_response;
    @XStreamOmitField
    public boolean allow_gain_variation;

    public AutoPIDCfg2(boolean isGUIMode) {
        this.setDefaultValues(isGUIMode);
    }

    public void setDefaultValues(boolean isGUIMode) {
        for (int axis = 0; axis < 3; ++axis) {
            this.axis_flags[axis] = 2;
            this.gain[axis] = 127;
            this.stimulus_gain[axis] = 1000;
            this.effective_freq[axis] = 20;
            this.problem_freq[axis] = 50;
            this.problem_margin[axis] = 5.0f;
        }
        this.general_flags = 3;
        this.multiple_systems = true;
        this.allow_gain_variation = false;
        this.show_response = 3;
        this.freqFrom = isGUIMode ? 1.0f : 5.0f;
        this.freqTo = 300.0f;
        this.rnd_seed_num = isGUIMode ? 50 : 0;
    }

    public void loadFromSettings() {
        this.show_response = Settings.getInt("auto_pid2.show_response", this.show_response);
        this.multiple_systems = Settings.is("auto_pid2.multiple_systems", true);
        this.allow_gain_variation = Settings.is("auto_pid2.allow_gain_variation", false);
        this.general_flags = Settings.getInt("auto_pid2.flags", this.general_flags);
        this.freqFrom = Settings.getFloat("auto_pid2.freq_from", this.freqFrom);
        this.freqTo = Settings.getFloat("auto_pid2.freq_to", this.freqTo);
        this.rnd_seed_num = Settings.getInt("auto_pid2.rnd_seed_num", this.rnd_seed_num);
        for (int axis = 0; axis < 3; ++axis) {
            String a_name = "auto_pid2." + BoardParams.getAxisName(axis) + ".";
            this.axis_flags[axis] = Settings.getInt(a_name + "flags", this.axis_flags[axis]);
            this.gain[axis] = Settings.getInt(a_name + "gain", this.gain[axis]);
            this.stimulus_gain[axis] = Settings.getInt(a_name + "stimulus_gain", this.stimulus_gain[axis]);
            this.effective_freq[axis] = Settings.getInt(a_name + "effective_freq", this.effective_freq[axis]);
            this.problem_freq[axis] = Settings.getInt(a_name + "problem_freq", this.problem_freq[axis]);
            this.problem_margin[axis] = Settings.getFloat(a_name + "problem_margin", this.problem_margin[axis]);
        }
    }

    public void saveToSettings() {
        Settings.set("auto_pid2.show_response", this.show_response);
        Settings.set("auto_pid2.multiple_systems", this.multiple_systems);
        Settings.set("auto_pid2.allow_gain_variation", this.allow_gain_variation);
        Settings.set("auto_pid2.flags", Integer.toString(this.general_flags));
        Settings.set("auto_pid2.freq_from", Float.toString(this.freqFrom));
        Settings.set("auto_pid2.freq_to", Float.toString(this.freqTo));
        Settings.set("auto_pid2.rnd_seed_num", this.rnd_seed_num);
        for (int axis = 0; axis < 3; ++axis) {
            String a_name = "auto_pid2." + BoardParams.getAxisName(axis) + ".";
            Settings.set(a_name + "flags", this.axis_flags[axis]);
            Settings.set(a_name + "gain", this.gain[axis]);
            Settings.set(a_name + "stimulus_gain", this.stimulus_gain[axis]);
            Settings.set(a_name + "effective_freq", this.effective_freq[axis]);
            Settings.set(a_name + "problem_freq", this.problem_freq[axis]);
            Settings.set(a_name + "problem_margin", this.problem_margin[axis]);
        }
        Settings.save();
    }

    public void enableAxis(int axis) {
        for (int i = 0; i < 3; ++i) {
            if (i == axis) {
                int n = i;
                this.axis_flags[n] = this.axis_flags[n] | 1;
                continue;
            }
            int n = i;
            this.axis_flags[n] = this.axis_flags[n] & 0xFFFFFFFE;
        }
    }

    public boolean isAxisSelected(int axis) {
        return (this.axis_flags[axis] & 1) > 0;
    }

    public boolean isStartFromCurrent() {
        return (this.general_flags & 1) > 0 || this.isGainOnly();
    }

    public boolean isTuneLPF(int axis) {
        return (this.axis_flags[axis] & 2) > 0 && !this.isGainOnly();
    }

    public int getNotchTunedNum(int axis) {
        return (this.axis_flags[axis] & 0xC) >> 2;
    }

    public void setNotchNum(int axis, int num) {
        int n = axis;
        this.axis_flags[n] = this.axis_flags[n] & 0xFFFFFFF3;
        if (num > 0 && num <= 3) {
            int n2 = axis;
            this.axis_flags[n2] = this.axis_flags[n2] | num << 2;
        }
    }

    public boolean isTuneNotch(int axis, int idx) {
        return idx < this.getNotchTunedNum(axis);
    }

    public boolean isAllProfiles() {
        return (this.general_flags & 2) > 0;
    }

    public boolean isUseStoredResp() {
        return (this.general_flags & 8) > 0;
    }

    public boolean isGainOnly() {
        return (this.general_flags & 4) > 0;
    }

    public boolean isAutoSave() {
        return (this.general_flags & 0x10) > 0;
    }

    boolean isRunAtStartup() {
        return (this.general_flags & 0xC000) > 0;
    }

    public void write(SerialCommand cmd) throws Exception {
        cmd.writeByte(1);
        for (int axis = 0; axis < 3; ++axis) {
            cmd.writeByte(this.axis_flags[axis]);
            cmd.writeByte(this.gain[axis]);
            cmd.writeWord(this.stimulus_gain[axis]);
            cmd.writeByte(this.effective_freq[axis]);
            cmd.writeByte(this.problem_freq[axis]);
            cmd.writeByte(Math.round(this.problem_margin[axis] * 10.0f));
            cmd.writeByteArr(this.axis_reserved);
        }
        cmd.writeWord(this.general_flags);
        cmd.writeByte(this.rnd_seed_num / 5);
        cmd.writeByte(MathUtils.constrain(Math.round(this.freqFrom * 10.0f), 0, 255));
        cmd.writeByte(MathUtils.constrain(Math.round(this.freqTo) / 2, 0, 255));
        cmd.writeByte(this.mult_pos_enabled);
        cmd.writeByteSignedArr(this.mult_pos_angles);
        cmd.writeByteArr(this.general_reserved);
    }

    public void read(SerialCommand cmd) throws Exception {
        int version = cmd.readByte();
        if (version > 0) {
            for (int axis = 0; axis < 3; ++axis) {
                this.axis_flags[axis] = cmd.readByte();
                this.gain[axis] = cmd.readByte();
                this.stimulus_gain[axis] = cmd.readWord();
                this.effective_freq[axis] = cmd.readByte();
                this.problem_freq[axis] = cmd.readByte();
                this.problem_margin[axis] = (float)cmd.readByte() * 0.1f;
                cmd.readByteArr(this.axis_reserved);
            }
            this.general_flags = cmd.readWordUnsigned();
            this.rnd_seed_num = cmd.readByte() * 5;
            this.freqFrom = (float)cmd.readByte() * 0.1f;
            this.freqTo = cmd.readByte() * 2;
            if (this.freqFrom == 0.0f || this.freqTo == 0.0f || this.freqFrom > this.freqTo) {
                this.freqFrom = 1.0f;
                this.freqFrom = 300.0f;
            }
            this.mult_pos_enabled = cmd.readByte();
            cmd.readByteSignedArr(this.mult_pos_angles);
            cmd.readByteArr(this.general_reserved);
        } else {
            this.setDefaultValues(false);
        }
    }

    public AutoPIDCfg2 clone() {
        AutoPIDCfg2 copy = null;
        try {
            copy = (AutoPIDCfg2)super.clone();
            copy.gain = Arrays.copyOf(this.gain, 3);
            copy.axis_flags = Arrays.copyOf(this.axis_flags, 3);
            copy.stimulus_gain = Arrays.copyOf(this.stimulus_gain, 3);
            copy.effective_freq = Arrays.copyOf(this.effective_freq, 3);
            copy.problem_freq = Arrays.copyOf(this.problem_freq, 3);
            copy.problem_margin = Arrays.copyOf(this.problem_margin, 3);
            copy.mult_pos_angles = Arrays.copyOf(this.mult_pos_angles, this.mult_pos_angles.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return copy;
    }
}

