/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import sbgc.object.BoardParams;
import sbgc.service.SerialCommand;
import sbgc.utils.DataLogger;

public class AutoPIDInfo {
    private static final DecimalFormat floatFormatter = new DecimalFormat("0.#####E0", new DecimalFormatSymbols(Locale.ENGLISH));
    public int[] P = new int[]{0, 0, 0};
    public int[] I = new int[]{0, 0, 0};
    public int[] D = new int[]{0, 0, 0};
    public int[] pid_gain = new int[]{0, 0, 0};
    public int[] lpf_freq = new int[]{0, 0, 0};
    public float[] error = new float[]{0.0f, 0.0f, 0.0f};
    public int[] d_lpf_freq = new int[]{0, 0, 0};
    public int iter_num;
    public int auto_momentum;

    public static AutoPIDInfo parse(SerialCommand cmd) throws Exception {
        AutoPIDInfo info = new AutoPIDInfo();
        cmd.readByteArr(info.P);
        cmd.readByteArr(info.I);
        cmd.readByteArr(info.D);
        cmd.readWordArr(info.lpf_freq);
        info.iter_num = cmd.readWordUnsigned();
        for (int i = 0; i < 3; ++i) {
            info.error[i] = cmd.readFloat();
            info.pid_gain[i] = cmd.readByte();
            cmd.skipBytes(5);
        }
        info.auto_momentum = cmd.readByte();
        cmd.readByteArr(info.d_lpf_freq);
        BoardParams.mult_arr(info.d_lpf_freq, 2);
        cmd.skipBytes(6);
        return info;
    }

    public static void log_header(DataLogger f) {
        ArrayList<String> h = new ArrayList<String>(30);
        h.add("ITER_NUM");
        for (int i = 0; i < 3; ++i) {
            String axis = BoardParams.getAxisName(i);
            h.add("P[" + axis + "]");
            h.add("I[" + axis + "]");
            h.add("D[" + axis + "]");
            h.add("LPF_FREQ[" + axis + "]");
            h.add("ERR[" + axis + "]");
            h.add("D_TERM_LPF_FREQ[" + axis + "]");
        }
        f.setHeader(h);
    }

    public void log_data(DataLogger f) {
        ArrayList<String> d = new ArrayList<String>(f.getHeader().size());
        d.add(Integer.toString(this.iter_num));
        for (int i = 0; i < 3; ++i) {
            d.add(Integer.toString(this.P[i]));
            d.add(Integer.toString(this.I[i]));
            d.add(Integer.toString(this.D[i]));
            d.add(Integer.toString(this.lpf_freq[i]));
            d.add(floatFormatter.format(this.error[i]));
            d.add(Integer.toString(this.d_lpf_freq[i]));
        }
        f.logData(d);
    }
}

