/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.util.zip.CRC32;

public class BackupData {
    public int formatVer;
    public int type;
    public int frwVer;
    public int boardVer;
    public byte[] reserved = new byte[32];
    public byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupData readFromFile(File f) throws Exception {
        try (FilterInputStream input = null;){
            Exception corruptedException = new Exception("Data is corrupted or wrong file is selected");
            input = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
            BackupData d = new BackupData();
            d.formatVer = ((DataInputStream)input).readByte();
            if (d.formatVer == 0 || d.formatVer > 1) {
                throw corruptedException;
            }
            d.type = ((DataInputStream)input).readByte();
            d.frwVer = ((DataInputStream)input).readShort();
            d.boardVer = ((DataInputStream)input).readShort();
            int dataLength = ((DataInputStream)input).readInt();
            if (dataLength > 1000000) {
                throw corruptedException;
            }
            long crcData = ((DataInputStream)input).readLong();
            for (int i = 0; i < d.reserved.length; ++i) {
                d.reserved[i] = ((DataInputStream)input).readByte();
            }
            d.data = new byte[dataLength];
            ((DataInputStream)input).read(d.data);
            CRC32 crc = new CRC32();
            crc.update(d.data);
            if (d.data.length != dataLength || crcData != crc.getValue()) {
                throw corruptedException;
            }
            BackupData backupData = d;
            return backupData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File f) throws Exception {
        try (FilterOutputStream output = null;){
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            ((DataOutputStream)output).writeByte(this.formatVer);
            ((DataOutputStream)output).writeByte(this.type);
            ((DataOutputStream)output).writeShort(this.frwVer);
            ((DataOutputStream)output).writeShort(this.boardVer);
            ((DataOutputStream)output).writeInt(this.data.length);
            CRC32 crc = new CRC32();
            crc.update(this.data);
            ((DataOutputStream)output).writeLong(crc.getValue());
            for (int i = 0; i < this.reserved.length; ++i) {
                ((DataOutputStream)output).writeByte(this.reserved[i]);
            }
            output.write(this.data);
        }
    }
}

