/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.log4j.Logger;
import sbgc.object.AdjVarInfo;
import sbgc.object.BoardParams;
import sbgc.object.ErrorInfo;
import sbgc.object.IMUDebugInfo;
import sbgc.object.Sprav;
import sbgc.service.SerialCommand;
import sbgc.service.upgrade.VersionFactory;
import sbgc.service.upgrade.VersionImpl;
import sbgc.ui.ParamsUIFactory;
import sbgc.ui.utils.Colored;
import sbgc.ui.utils.StatusBit;
import sbgc.utils.HexUtil;
import sbgc.utils.MathUtils;
import sbgc.utils.Settings;
import simplebgc_gui.SimpleBGC_GUIApp;

public class BoardInfo {
    static final Logger logger = Logger.getLogger((String)BoardParams.class.getName());
    public static final long BOARD_FEATURE_DEBUG_MODE = -1L;
    public static final long BOARD_FEATURE_3AXIS = 1L;
    public static final long BOARD_FEATURE_BAT_MONITORING = 2L;
    public static final long BOARD_FEATURE_ENCODERS = 4L;
    public static final long BOARD_FEATURE_BODE_TEST = 8L;
    public static final long BOARD_FEATURE_SCRIPTING = 16L;
    public static final long BOARD_FEATURE_CURRENT_SENSOR = 32L;
    public static final long BOARD_FEATURE_MAG_SENSOR = 64L;
    public static final long BOARD_FEATURE_ORDER_OF_AXES_LETUS = 128L;
    public static final long BOARD_FEATURE_IMU_EEPROM = 256L;
    public static final long BOARD_FEATURE_FRAME_IMU_EEPROM = 512L;
    public static final long BOARD_FEATURE_CAN_PORT = 1024L;
    public static final long BOARD_FEATURE_MOMENTUM = 2048L;
    public static final long BOARD_FEATURE_COGGING_CORRECTION = 4096L;
    public static final long BOARD_FEATURE_MOTOR4_CONTROL = 8192L;
    public static final long BOARD_FEATURE_ACC_AUTO_CALIB = 16384L;
    public static final long BOARD_FEATURE_EXTENDED_FAMILY = 32768L;
    public static final long BOARD_FEATURE_EXT_IMU = 65536L;
    public static final long BOARD_FEATURE_STATE_VARS = 262144L;
    public static final long BOARD_FEATURE_POWER_MANAGEMENT = 524288L;
    public static final long BOARD_FEATURE_GYRO_ADVANCED_CALIB = 0x100000L;
    public static final long BOARD_FEATURE_LIMITED_VERSION = 0x200000L;
    public static final long BOARD_FEATURE_REACTION = 0x400000L;
    public static final long BOARD_FEATURE_ENCODER_LUT = 0x800000L;
    public static final long BOARD_FEATURE_M_IMU_EXT_SENS = 0x1000000L;
    public static final long BOARD_FEATURE_MAVLINK_V2 = 0x2000000L;
    public static final long BOARD_FEATURE_SERIAL_LINK = 0x4000000L;
    public static final long BOARD_FEATURE_UART3 = 0x8000000L;
    public static final long BOARD_FEATURE_EXT_LICENSES = 0x10000000L;
    public static final long BOARD_FEATURE_SERVO_MODE = 0x20000000L;
    public static final long BOARD_FEATURE_RETRACTED_POSITION = 0x40000000L;
    public static final long BOARD_FEATURE_GPS_IMU_SPLIT = 0x80000000L;
    public static final long L32 = 0x100000000L;
    public static final long BOARD_FEATURE_PLUS_VER = 0x100000000L;
    public static final long BOARD_FEATURE_SHAKE_GENERATOR = 0x200000000L;
    public static final long BOARD_FEATURE_EXT_MOTORS = 0x400000000L;
    public static final long BOARD_FEATURE_QUAT_CONTROL = 0x800000000L;
    public static final long BOARD_FEATURE_ADC4 = 0x1000000000L;
    public static final long BOARD_FEATURE_AUTO_PID = 0x2000000000L;
    public static final long BOARD_FEATURE_EXT_POWER_SWITCH = 0x4000000000L;
    public static final long BOARD_FEATURE_PID_ENCODERS = 0x8000000000L;
    public static final long BOARD_FEATURE_IMU_ENCODER = 0x10000000000L;
    public static final int CONNECTION_FLAG_USB = 1;
    public static final int PROFILE_NAME_SIZE = 48;
    public static final int EEPROM_PAGE_SIZE = 64;
    public static final int CMD_DATA_SIZE = 255;
    public static final int PROFILE_SET_SLOT_NUM = 5;
    public static final int PROFILE_SET_SLOT_BACKUP = 6;
    public static final String[] MODULE_NAMES = new String[]{"Unknown module", "IMU sensor - main", "IMU sensor - frame", "CAN_Drv#1", "CAN_Drv#2", "CAN_Drv#3", "CAN_Drv#4", "CAN_Drv#5", "CAN_Drv#6", "CAN_Drv#7", "GPS_IMU", "CAN_HUB_GNSS", "CAN_HUB1", "CAN_HUB2"};
    public static final int IMU_MODEL_CAN_IMU = 1;
    public static final int IMU_MODEL_CAN_IMU_via_i2c = 2;
    public static final int IMU_MODEL_icm_20608 = 3;
    public static final int IMU_MODEL_mpu_6050 = 4;
    public static final int IMU_MODEL_GPS_IMU_via_CAN = 5;
    public static final int IMU_MODEL_icm_42688 = 5;
    public static final String[] IMU_MODEL_NAMES = new String[]{"undefined", "CAN_IMU (CAN)", "CAN_IMU (I2C)", "ICM-2060x", "MPU-6050", "GPS_IMU (CAN)", "ICM-42688-P"};
    public static final int CMD_CAN_DRV_STATE_DATA_SIZE = 36;
    public static final int FLAG1_DEBUG_MODE = 1;
    public static final int FLAG1_UPSIDE_DOWN_MODE = 2;
    public static final int M_IMU_EXT_TYPE_GPS_IMU = 1;
    public static final int CYCLE_TIME_US = 800;
    public static final int SAMPLING_FREQ_HZ = 1250;
    public static final int FRW_VER_AUTO_PID2 = 2731;
    public static final int FRW_VER_EXT_PID_RANGE = 2731;
    public static final int PID_V1 = 1;
    public static final int PID_V1_EXT = 2;
    public static final int PID_V1_EXT_NEW = 3;
    public static final int PID_V3 = 4;
    public static final Sprav[] SERIAL_PORTS = new Sprav[]{new Sprav(1, "UART1"), new Sprav(2, "RC_serial"), new Sprav(3, "UART2"), new Sprav(4, "USB VCP / UART3")};
    public static final HashMap<Integer, String> BOARD_VER_NAMES = new HashMap();
    public static final String[] EXT_LIC_TYPE_LIST;
    public static final int HW_FLAG_ONE_WIRE_CRYPTO = 1;
    public static final String[] HW_FLAGS_NAMES;
    public static final String[] POWER_STATE_MOT_FLAGS_NAMES;
    public static final String[] POWER_STATE_SYS_FLAGS_NAMES;
    public static final HashMap<Integer, String> SYSTEM_POWER_STATE;
    public static final String[] CAN_BUS_ERROR_FLAGS_NAMES;
    public static final float DEG_SEC_GYRO_SCALE = 16.384f;
    public static final int CALIB_MODE_EXT_GAIN = 1;
    public static final int CALIB_MODE_SET_ANGLE_AND_SAVE = 2;
    public static final int CALIB_MODE_POLES = 3;
    public static final int CALIB_MODE_ACC = 4;
    public static final int CALIB_MODE_GYRO = 5;
    public static final int CALIB_MODE_ENCODER_OFFSET = 6;
    public static final int CALIB_MODE_ENCODER_FLD_OFFSET = 7;
    public static final int CALIB_MODE_AUTO_PID = 8;
    public static final int CALIB_MODE_BODE_TEST = 9;
    public static final int CALIB_MODE_GYRO_TEMP = 10;
    public static final int CALIB_MODE_ACC_TEMP = 11;
    public static final int CALIB_MODE_MAG = 12;
    public static final int CALIB_MODE_SET_ANGLE = 13;
    public static final int CALIB_MODE_MOTOR_MAG_LINK = 15;
    public static final int CALIB_MODE_SEARCH_LIMITS = 16;
    public static final int CALIB_MODE_SET_OPERATION_POS = 17;
    public static final int CALIB_MODE_IMU_ORIENTATION_CORR = 18;
    public static final int CALIB_MODE_TIMELAPSE = 19;
    public static final int CALIB_MODE_MOMENTUM = 20;
    public static final int CALIB_MODE_MOMENTUM_AUTO = 21;
    public static final int CALIB_MODE_COGGING = 22;
    public static final int CALIB_MODE_ACC_EXT_REF = 23;
    public static final int CALIB_MODE_SAFE_STOP = 24;
    public static final int CALIB_MODE_ACC_SPHERE = 25;
    public static final int CALIB_MODE_EXT_IMU_GYRO = 27;
    public static final int CALIB_MODE_EXT_IMU_ALIGN = 28;
    public static final int CALIB_MODE_ACC_GYRO_MULTIPOINT = 34;
    public static final int CALIB_MODE_ENCODER_LUT = 35;
    public static final int CALIB_MODE_WRITE_PARAMS = 36;
    public static final int CALIB_MODE_CUR_SENS = 37;
    public static final int CALIB_MODE_MOVE_HOME_MOTORS = 38;
    public static final int CALIB_MODE_ENCODER_INT = 39;
    public static final int CALIB_MODE_VIBRATION_TEST = 40;
    public static final int CALIB_MODE_RETRACTED_POSITION = 41;
    public static final int CALIB_MODE_RETRACTED_POSITION_RC_CONTROL = 42;
    private static BoardInfo curBoardInfo;
    public int boardVer = 0;
    private int frwVer = 0;
    private int buildNumber = 0;
    private int frwVerShow = 0;
    public long frwVerPartner = 0L;
    public int frwVerBranchBase = 0;
    public int state_flags1 = 0;
    public long boardFeatures = 0L;
    public byte[] deviceId = null;
    public byte[] mcuId = null;
    public int connectionFlags = 0;
    public int eeprom_size = 0;
    public int flash_size = 0;
    public int[] scriptSize = null;
    public int profile_set_slots = 0;
    public int profile_set_active_slot = 0;
    public int[] imu_ext_model = new int[]{0, 0};
    public int[] imu_ext_info = new int[]{0, 0};
    public int hw_flags = 0;
    public String[] profileNames = null;
    public static boolean html_enabled;
    public int[] imu_calib_info = new int[]{0, 0};
    public int can_drv_limit1;
    public int can_drv_limit2;
    public AdjVarInfo[] adjVarsInfo = null;
    static StatusBit[] INT_DRV_STATUS_BITS;
    static final String[] RLS_Aksim2_Errors;
    static final String[] RLS_Aksim2_CalibStatus;

    public static synchronized BoardInfo getBoardInfo() {
        return curBoardInfo;
    }

    public static synchronized void setBoardInfo(BoardInfo info) {
        logger.debug((Object)"BoardInfo is set to null");
        curBoardInfo = info;
    }

    public int getBoardVersion() {
        return this.boardVer;
    }

    public String getDeviceId() {
        return this.deviceId != null ? HexUtil.toHex(this.deviceId) : "unknown";
    }

    public String getMcuId() {
        return this.mcuId != null ? HexUtil.toHex(this.mcuId) : "unknown";
    }

    public static synchronized BoardInfo parse(SerialCommand cmd) throws IOException {
        if (cmd.id == 86) {
            BoardInfo info = new BoardInfo();
            info.boardVer = cmd.readByte();
            info.setFrwVer(cmd.readWordUnsigned());
            info.state_flags1 = cmd.readByte();
            info.boardFeatures = cmd.readWordUnsigned();
            info.connectionFlags = cmd.readByte();
            info.frwVerPartner = cmd.readDWordUnsigned();
            info.boardFeatures |= (long)cmd.readWordUnsigned() << 16;
            int tmp = cmd.readByte();
            info.imu_ext_model[0] = tmp & 0xF;
            info.imu_ext_info[0] = tmp & 0xF0;
            tmp = cmd.readByte();
            info.imu_ext_model[1] = tmp & 0xF;
            info.imu_ext_info[1] = tmp & 0xF0;
            info.buildNumber = cmd.readByte();
            info.frwVerBranchBase = cmd.readWordUnsigned();
            cmd.checkFinished();
            curBoardInfo = info;
        } else if (cmd.id == 20) {
            if (curBoardInfo != null) {
                BoardInfo.curBoardInfo.deviceId = cmd.readBytes(9);
                BoardInfo.curBoardInfo.mcuId = cmd.readBytes(12);
                BoardInfo.curBoardInfo.eeprom_size = (int)cmd.readDWordUnsigned();
                BoardInfo.curBoardInfo.scriptSize = new int[BoardInfo.getScriptSlotsNum()];
                cmd.readWordArr(BoardInfo.curBoardInfo.scriptSize, 0, 5);
                BoardInfo.curBoardInfo.profile_set_slots = cmd.readByte();
                BoardInfo.curBoardInfo.profile_set_active_slot = cmd.readByte();
                BoardInfo.curBoardInfo.flash_size = cmd.readByte() * 16;
                BoardInfo.curBoardInfo.imu_calib_info = cmd.readByteArr(2);
                if (BoardInfo.curBoardInfo.scriptSize.length == 10) {
                    cmd.readWordArr(BoardInfo.curBoardInfo.scriptSize, 5, 5);
                } else {
                    cmd.skipBytes(10);
                }
                BoardInfo.curBoardInfo.hw_flags = cmd.readWordUnsigned();
                BoardInfo.curBoardInfo.boardFeatures |= cmd.readDWordUnsigned() << 32;
                BoardInfo.curBoardInfo.can_drv_limit1 = cmd.readByte();
                BoardInfo.curBoardInfo.can_drv_limit2 = cmd.readByte();
                cmd.skipBytes(11);
                cmd.checkFinished();
            } else {
                throw new IOException("Command CMD_BOARD_INFO_3 can't be parsed before CMD_BOARD_INFO!");
            }
        }
        return curBoardInfo;
    }

    public String toString() {
        return "boardVer: " + this.boardVer + ", frwVer: " + this.frwVer + (this.frwVer != this.frwVerBranchBase ? " (based on " + this.frwVerBranchBase + ")" : "") + ", deviceId: " + Arrays.toString(this.deviceId);
    }

    public boolean hasExpansionBoard() {
        return (this.boardFeatures & 1L) > 0L;
    }

    public static boolean hasBatterryMonitoring() {
        return curBoardInfo != null && (BoardInfo.curBoardInfo.boardFeatures & 2L) > 0L;
    }

    public static int getNumProfiles() {
        return 5;
    }

    public void parseProfileNames(SerialCommand cmd) throws IOException {
        BoardParams params = BoardParams.getCurParams();
        this.profileNames = new String[BoardInfo.getNumProfiles()];
        for (int i = 0; i < this.profileNames.length; ++i) {
            try {
                this.profileNames[i] = new String(cmd.readBytes(48), "UTF-8").replace('\u0000', ' ').trim();
                logger.debug((Object)("Profile name" + i + ": '" + this.profileNames[i] + "' [" + HexUtil.toHex(this.profileNames[i].getBytes()) + "]"));
            }
            catch (Exception e) {
                logger.error((Object)("Error parsing profile name: " + e.toString()));
            }
            if (this.profileNames[i] == null || this.profileNames[i].equals("")) {
                this.profileNames[i] = null;
                continue;
            }
            if (params == null) continue;
            params.setProfileName(i, this.profileNames[i]);
        }
    }

    public SerialCommand formatProfileNamesCmd() throws Exception {
        if (this.profileNames != null) {
            SerialCommand cmd = new SerialCommand(29);
            for (int i = 0; i < this.profileNames.length; ++i) {
                byte[] buf;
                String name = this.profileNames[i];
                if (name == null) {
                    name = "";
                }
                if ((buf = name.getBytes("UTF-8")).length <= 48) {
                    cmd.write(buf);
                    for (int j = buf.length; j < 48; ++j) {
                        cmd.writeByte(0);
                    }
                    continue;
                }
                throw new Exception("Profile " + (i + 1) + " name is too long!");
            }
            return cmd;
        }
        throw new Exception("Saving profile names to board is not supported!");
    }

    public static boolean checkMinBoardVer(int ver) {
        return curBoardInfo != null && BoardInfo.curBoardInfo.boardVer >= ver;
    }

    public static boolean checkMinBaseFirmwareVer(int ver) {
        return curBoardInfo != null && curBoardInfo.getFrwVer() >= ver;
    }

    public static boolean checkMinPartnerFirmwareVer(int ver) {
        return curBoardInfo != null && curBoardInfo.getBaseFrwVer() >= ver;
    }

    public boolean _hasBoardFeature(long feature) {
        if (feature == -1L) {
            return BoardInfo.isDebugMode();
        }
        return (this.boardFeatures & feature) == feature;
    }

    public static boolean hasBoardFeature(long feature) {
        return curBoardInfo != null && curBoardInfo._hasBoardFeature(feature);
    }

    public static boolean hasExtendedParams() {
        return BoardInfo.checkMinBaseFirmwareVer(2420);
    }

    public static boolean hasExtendedParams2() {
        return BoardInfo.checkMinBaseFirmwareVer(2560);
    }

    public static boolean hasExtendedParams3() {
        return BoardInfo.checkMinBaseFirmwareVer(2664);
    }

    public static boolean hasAdjVars() {
        return BoardInfo.checkMinBaseFirmwareVer(2430);
    }

    public static boolean hasAdjVarsLUT() {
        return BoardInfo.checkMinBaseFirmwareVer(2625);
    }

    public static boolean hasCustomTune() {
        return BoardInfo.checkMinBaseFirmwareVer(2668);
    }

    public static boolean hasFilters() {
        return BoardInfo.checkMinBaseFirmwareVer(2420);
    }

    public static boolean hasScripting() {
        return BoardInfo.hasBoardFeature(16L);
    }

    public static boolean hasYawEncoder() {
        return BoardInfo.checkMinBaseFirmwareVer(2550);
    }

    public static boolean hasEncoders() {
        return BoardInfo.hasBoardFeature(4L);
    }

    public static boolean hasExtSensor() {
        return BoardInfo.hasBoardFeature(1024L) && BoardInfo.checkMinBaseFirmwareVer(2691);
    }

    public static boolean hasCanImuCfg() {
        return BoardInfo.hasBoardFeature(1024L) && BoardInfo.checkMinBaseFirmwareVer(2720);
    }

    public boolean canSaveProfileNames() {
        return this.profileNames != null;
    }

    public static boolean isDebugMode() {
        return curBoardInfo != null && (BoardInfo.curBoardInfo.state_flags1 & 1) > 0;
    }

    public void setProfileName(int profileId, String name) {
        if (this.profileNames != null && profileId >= 0 && profileId < this.profileNames.length) {
            this.profileNames[profileId] = name;
        }
    }

    public static boolean canBodeTest() {
        return BoardInfo.hasBoardFeature(8L);
    }

    public static boolean has_i2c_drv() {
        return BoardInfo.checkMinBaseFirmwareVer(2500);
    }

    public static boolean hasMagSensor() {
        return BoardInfo.hasBoardFeature(64L);
    }

    public static boolean hasOrderOfAxes() {
        return BoardInfo.checkMinBaseFirmwareVer(2555);
    }

    public static boolean hasMavlink() {
        return BoardInfo.checkMinBaseFirmwareVer(2593);
    }

    public static boolean hasConnectedModules() {
        return BoardInfo.hasBoardFeature(1024L);
    }

    public static boolean hasExtLicenses() {
        return BoardInfo.hasBoardFeature(0x10000000L);
    }

    public static boolean hasCANIdMap() {
        return BoardInfo.hasBoardFeature(1024L) && BoardInfo.checkMinBaseFirmwareVer(2650);
    }

    public static boolean hasCANDrvParams() {
        return BoardInfo.hasBoardFeature(1024L) && BoardInfo.checkMinBaseFirmwareVer(2650);
    }

    public static boolean hasSerialLinkParams() {
        return BoardInfo.hasBoardFeature(0x4000000L);
    }

    public static boolean hasReactionParams() {
        return BoardInfo.hasBoardFeature(0x400000L);
    }

    public static boolean hasExtraButtons() {
        return BoardInfo.checkMinBaseFirmwareVer(2684);
    }

    public static boolean hasSystemStat() {
        return BoardInfo.hasBoardFeature(1024L) && BoardInfo.checkMinBaseFirmwareVer(2687);
    }

    public static boolean hasAutoPID() {
        return BoardInfo.hasBoardFeature(0x2000000000L) || !BoardInfo.checkMinBaseFirmwareVer(2731);
    }

    public static boolean autoPID2() {
        return BoardInfo.checkMinBaseFirmwareVer(2731);
    }

    public static boolean hasAutoPID2() {
        return BoardInfo.hasAutoPID() && BoardInfo.autoPID2();
    }

    public static boolean hasPID_V3_support() {
        return BoardInfo.checkMinBaseFirmwareVer(2741);
    }

    public static boolean hasExtPIDRange() {
        return BoardInfo.checkMinBaseFirmwareVer(2731);
    }

    public static boolean hasLPF1() {
        return BoardInfo.checkMinBaseFirmwareVer(2741);
    }

    public static boolean hasAdvancedDebugVars() {
        return BoardInfo.checkMinBaseFirmwareVer(2720);
    }

    public static boolean hasPIDEncoders() {
        return BoardInfo.hasBoardFeature(0x8000000000L);
    }

    public static void showBoardInfo() {
        StringBuilder buf = new StringBuilder(500);
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        if (boardInfo != null) {
            buf.append("Device s/n: " + boardInfo.getDeviceId() + ", MCU s/n: " + boardInfo.getMcuId() + "\n");
            buf.append("Firmware ver.: " + new VersionImpl(boardInfo.getFrwVer(), boardInfo.getBuildNumber()).toString() + ", board ver.:" + BoardInfo.getBoardVerName(boardInfo.getBoardVersion()) + ", FLASH size: " + (boardInfo.flash_size > 0 ? boardInfo.flash_size + " Kb" : "unknown (need firmware upgrade to detect)") + ", EEPROM size: " + (boardInfo.eeprom_size > 0 ? boardInfo.eeprom_size + " byte" : "unknown") + "\n");
            if (boardInfo.hw_flags != 0) {
                buf.append("Hardware properties: " + BoardInfo.formatBitSet(boardInfo.hw_flags, HW_FLAGS_NAMES, "none") + "\n");
            }
            if (boardInfo._hasBoardFeature(0x10000000L)) {
                if (boardInfo.getBaseFrwVer() >= 2723) {
                    buf.append("CAN_DRV available licenses for stabilization: " + boardInfo.can_drv_limit1 + ", for auxiliary motors: " + boardInfo.can_drv_limit2 + "\n");
                } else {
                    buf.append("CAN_DRV available licenses: unknown (upgrade to 2.72.3 or later to get this information)\n");
                }
            } else {
                buf.append("CAN_DRV available licenses: unlimited\n");
            }
            buf.append("GUI ver.: " + SimpleBGC_GUIApp.version.toString() + "\n");
        }
        SimpleBGC_GUIApp.mainView.debugMessageSynced(buf.toString());
    }

    public static void parseCmdSytemState(SerialCommand cmd) throws Exception {
        StringBuilder buf = new StringBuilder(500);
        html_enabled = false;
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        BoardParams boardParams = BoardParams.getCurParams();
        try {
            int stack_flags;
            int error = cmd.readWordUnsigned();
            int assertLine = cmd.readWordUnsigned();
            String assertFile = new String(cmd.readBytes(32), "US-ASCII").replace('\u0000', ' ').trim();
            int comErrors = cmd.readWordUnsigned();
            for (int axis = 0; axis < 3; ++axis) {
                buf.append("Encoder[" + BoardParams.AXIS_NAME[axis] + "]\n");
                int type = cmd.readByte();
                int cfg = BoardParams.getCurParams().encoder_cfgs[axis];
                int[] enc_info = boardInfo.frwVerShow >= 2680 ? cmd.readByteArr(6) : cmd.readByteArr(4);
                BoardInfo.formatEncoderInfo(buf, type, cfg, enc_info);
                buf.append("\t read errors: " + cmd.readWordUnsigned() + "\n");
            }
            int pins = cmd.readByte();
            buf.append("INT. DRIVERS STATE: ");
            StatusBit.format_plain(buf, INT_DRV_STATUS_BITS, pins);
            buf.append("\n");
            buf.append("TIME SLOTS FREE (us): ");
            int time_slots = cmd.readByte();
            for (int i = 0; i < time_slots; ++i) {
                buf.append(i + 1 + ":" + cmd.readWord() + ", ");
            }
            buf.append("\n");
            int subError = cmd.readByte();
            int stack_size = cmd.readWordUnsigned();
            int stack_free_space = cmd.readWordUnsigned();
            if (stack_size > 0) {
                buf.append("STACK SIZE=" + stack_size + ", MAX.OCCUPIED=" + (stack_size - stack_free_space) + ", MIN.FREE SPACE=" + stack_free_space + "\n");
            }
            if (((stack_flags = cmd.readByte()) & 1) > 0) {
                buf.append("SYSTEM ERROR: STACK OVERFLOW!\n");
            }
            if ((stack_flags & 2) > 0) {
                buf.append("WARNING: STACK CRITICALLY LOW!\n");
            }
            buf.append("TEMPERATURE (C\u00b0): ");
            String[] TEMP_SENS_NAMES = new String[]{"MCU", "IMU", "F.IMU", "DRIVERS", "ROLL_M", "PITCH_M", "YAW_M"};
            for (int i = 0; i < 7; ++i) {
                byte temp = cmd.readByteSigned();
                buf.append(TEMP_SENS_NAMES[i] + "=" + temp + ", ");
            }
            buf.append("\n");
            ErrorInfo.setBoardError(error, subError);
            buf.append("Errors: [" + ErrorInfo.getCurError() + "-" + ErrorInfo.getCurSubError() + "] " + ErrorInfo.getCurErrors() + "\n");
            buf.append("assert_line: " + assertLine + "\n");
            buf.append("assert_file: " + assertFile + "\n");
            buf.append("COM errors: " + comErrors + "\n");
            int i2c_err_cnt = cmd.readWordUnsigned();
            if (i2c_err_cnt > 0) {
                buf.append("I2C errors: " + i2c_err_cnt + "; by device: ");
                for (int i = 0; i < 5; ++i) {
                    int addr = cmd.readByte();
                    int err_cnt = cmd.readWordUnsigned();
                    if (addr == 0) continue;
                    buf.append("0x" + Integer.toHexString(addr) + "=" + err_cnt + "; ");
                }
                buf.append("\n");
            } else {
                buf.append("I2C errors: none\n");
                cmd.skipBytes(15);
            }
            if (cmd.getBytesAvailable() >= 3) {
                buf.append("CAN bus errors: " + cmd.readWordUnsigned() + "\n");
                int flags = cmd.readByte();
                buf.append("CAN bus error flags: " + BoardInfo.formatBitSet(flags, CAN_BUS_ERROR_FLAGS_NAMES, "no") + "\n");
                if (cmd.getBytesAvailable() >= 26) {
                    IMUDebugInfo d = new IMUDebugInfo();
                    d.parseIMUDebugInfo(cmd);
                    d.formatIMUDebugInfo(buf);
                    buf.append("\n");
                }
                if (cmd.getBytesAvailable() >= 32) {
                    for (int i = 0; i < 4; ++i) {
                        long rx_overflow = cmd.readDWordUnsigned();
                        long tx_overflow = cmd.readDWordUnsigned();
                        if (i >= 3 && !BoardInfo.hasUART3()) continue;
                        String portName = BoardInfo.getSerialPortName(i + 1);
                        buf.append(String.format("%s RX buffer overflow: %d bytes\n", portName, rx_overflow));
                        buf.append(String.format("%s TX buffer overflow: %d bytes\n", portName, tx_overflow));
                    }
                }
                if (cmd.getBytesAvailable() >= 12) {
                    if (BoardInfo.hasBoardFeature(1024L)) {
                        int init_state = cmd.readByte();
                        int state = cmd.readByte();
                        if (boardParams.ext_sens_type > 0) {
                            String[] stateBits;
                            String bit0 = "OK";
                            String bit1 = "FAIL";
                            if (boardParams.ext_sens_type <= 7) {
                                stateBits = new String[]{"GYRO", "ACC", "TEMP", "VOLTAGE", "OTHER", "DATA_VALID", "INT_GYRO_SYNC", "INT_ACC_SYNC"};
                            } else if (boardParams.ext_sens_type == 66) {
                                stateBits = new String[]{"IMU", "MAG", "BARO", "ODOMETER", "GNSS1", "GNSS2", "POS_MOVE", "POS_STATIC"};
                                bit0 = "NO";
                                bit1 = "AVAIL";
                            } else {
                                stateBits = new String[]{null, null, null, null, null, "DATA_VALID", "INT_GYRO_SYNC", "INT_ACC_SYNC"};
                            }
                            buf.append("MAIN IMU EXTERNAL SENSOR: " + Sprav.findInArray(ParamsUIFactory.getExtSensTypeList(), boardParams.ext_sens_type) + "\n");
                            buf.append("\tInit state: " + init_state + "\n");
                            buf.append("\tHardware state: " + BoardInfo.formatStatusBits(state, stateBits, bit0, bit1) + "\n");
                            if (boardParams.ext_sens_type <= 7 || boardParams.ext_sens_type >= 33 && boardParams.ext_sens_type <= 42) {
                                int avg_err_gyro = cmd.readWordUnsigned();
                                int avg_err_acc = cmd.readWordUnsigned();
                                int crc_err_cnt = cmd.readWordUnsigned();
                                int gyro_err_cnt = cmd.readWordUnsigned();
                                int acc_err_cnt = cmd.readWordUnsigned();
                                buf.append("\tInternal sensors sync. error GYRO=" + avg_err_gyro + ", ACC=" + avg_err_acc + "\n");
                                buf.append("\tError counters: CRC=" + crc_err_cnt + ", GYRO=" + gyro_err_cnt + ", ACC=" + acc_err_cnt + "\n");
                            } else if (boardParams.ext_sens_type == 66) {
                                int nav_state = cmd.readByte();
                                int ahrs_state = cmd.readByte();
                                int[] qual = cmd.readWordArrUnsigned(3);
                                cmd.skipBytes(2);
                                buf.append("\tNavigation solution available: " + (nav_state == 0 ? "NO" : "YES") + "\n");
                                buf.append("\tAHRS status: " + (ahrs_state == 0 ? "Invalid" : "Valid") + "\n");
                                buf.append(String.format("\tQuality: Roll=%.3f\u00b0, Pitch=%.3f\u00b0, Heading=%.3f\u00b0\n", Float.valueOf((float)qual[0] * 0.065535f), Float.valueOf((float)qual[1] * 0.065535f), Float.valueOf((float)qual[2] * 0.065535f)));
                            }
                        } else {
                            cmd.skipBytes(10);
                        }
                    } else {
                        cmd.skipBytes(12);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.toString());
        }
        SimpleBGC_GUIApp.mainView.debugMessageSynced(buf.toString());
    }

    public static void formatEncoderInfo(StringBuilder buf, int type, int cfg, int[] data) {
        int frw_ver;
        buf.append("\t Encoder type: ");
        String enc_name = BoardParams.ENC_TYPE_NAMES.get(type);
        if (enc_name == null) {
            enc_name = BoardParams.CAN_DRV_ENC_TYPE_NAMES.get(type);
        }
        if (enc_name != null) {
            buf.append(enc_name);
        } else {
            buf.append("UNKNOWN (" + type + ")");
        }
        if (data.length >= 6 && (frw_ver = data[4] + data[5] * 255) > 0) {
            buf.append(", frw. ver.: " + frw_ver);
        }
        buf.append("\n");
        if (type == 2 || type == 1) {
            buf.append("\t magnitude: " + data[0] + ", auto-gain: " + data[2] + "\n");
            BoardInfo.format_AS5048_diagInfo(buf, data[1]);
        } else if (type == 13) {
            buf.append("\t magnitude: " + data[0] + "\n");
            BoardInfo.format_AS5600_diagInfo(buf, data[1]);
        } else if (type == 4) {
            buf.append("\t zero offset: " + (data[0] * 256 + data[1]) + "\n");
        } else if (type >= 8 && type <= 11) {
            buf.append("\t internal errors: " + data[0] + "\n");
            buf.append("\t I2C slave errors: " + data[1] + "\n");
            if (cfg == 1 || cfg == 1) {
                buf.append("\t magnitude: " + data[2] + "\n");
                BoardInfo.format_AS5048_diagInfo(buf, data[3]);
            } else if (cfg == 7) {
                buf.append("\t magnitude: " + data[2] + "\n");
                BoardInfo.format_AS5600_diagInfo(buf, data[3]);
            } else if (cfg == 10) {
                buf.append("\t temperature: ");
                buf.append(Integer.toString(data[2]));
                BoardInfo.format_RLS_Orbis_sub_diagInfo(buf, data[3]);
            } else if (cfg == 11) {
                BoardInfo.format_MA730_diagInfo(buf, data[2]);
            } else if (cfg == 12) {
                BoardInfo.format_AM4096_diagInfo(buf, data[2], data[3]);
            }
        } else if (type == 14) {
            BoardInfo.format_RLS_Orbis_diagInfo(buf, data);
        } else if (type == 34) {
            BoardInfo.format_AM4096_diagInfo(buf, data[0], data[1]);
        } else if (type == 38 || type == 37) {
            BoardInfo.format_A1335_diagInfo(buf, data);
        } else if (type == 39) {
            BoardInfo.format_MA730_diagInfo(buf, data[0]);
        } else if (type == 42) {
            BoardInfo.format_ICMU_diagInfo(buf, data);
        } else if (type == 43) {
            BoardInfo.format_Aksim2_diagInfo(buf, data);
        } else {
            buf.append("\t diagnostic data: " + HexUtil.toHex(data));
        }
    }

    public static void format_AS5048_diagInfo(StringBuilder buf, int data) {
        buf.append("\t diagnostic: ");
        if ((data & 2) > 0) {
            buf.append("CORDIC oferflow! ");
        }
        if ((data & 4) > 0) {
            buf.append("Magnetic field is too high! ");
        }
        if ((data & 8) > 0) {
            buf.append("Magnetic field is too low! ");
        }
        if ((data & 0xE) == 0) {
            buf.append("no problems");
        }
        buf.append("\n");
    }

    public static void format_AM4096_diagInfo(StringBuilder buf, int byte1, int byte2) {
        buf.append("\t diagnostic info is not available for this type\n");
    }

    public static void format_AS5600_diagInfo(StringBuilder buf, int data) {
        buf.append("\t diagnostic: ");
        if ((data & 8) > 0) {
            buf.append("Magnetic field is too high! ");
        }
        if ((data & 4) > 0) {
            buf.append("Magnetic field is too low! ");
        }
        if ((data & 0xE) == 0) {
            buf.append("no problems");
        }
        buf.append("\n");
    }

    public static void format_RLS_Orbis_diagInfo(StringBuilder buf, int[] data) {
        buf.append("\t temperature: ");
        buf.append(Integer.toString(((data[1] & 0xFF) + (data[0] << 8)) / 10));
        buf.append(" C\u00b0\n\t diagnostic: ");
        if ((data[2] & 8) != 0) {
            buf.append("Magnetic field is too high! Move magnet away. ");
        } else if ((data[2] & 4) != 0) {
            buf.append("Magnetic field is too low! Move magnet closer. ");
        } else {
            buf.append("magnetic field is normal. ");
        }
        if ((data[3] & 2) == 0) {
            buf.append("Position data is not valid. ");
        }
        if ((data[3] & 1) == 0) {
            buf.append("Some operating conditions are close to limits. ");
        }
        buf.append("\n");
    }

    public static void format_A1335_diagInfo(StringBuilder buf, int[] data) {
        buf.append("\t temperature: ");
        buf.append(Integer.toString(Math.round((float)((data[0] & 0xFF | data[1] << 8) & 0xFFF) / 8.0f - 273.15f)));
        buf.append(" C\u00b0\n\t magnetic field: ");
        buf.append(Integer.toString((data[2] & 0xFF | data[3] << 8) & 0xFFF));
        buf.append(" Gauss\n\t diagnostic: ");
        int strLen = buf.length();
        if ((data[3] & 0x80) != 0) {
            buf.append("Extended error; ");
        }
        if ((data[3] & 0x40) != 0) {
            buf.append("Angle processing error; ");
        }
        if ((data[1] & 0x80) != 0) {
            buf.append("Over-voltage fault; ");
        }
        if ((data[1] & 0x40) != 0) {
            buf.append("Under-voltage fault; ");
        }
        if ((data[1] & 0x20) != 0) {
            buf.append("Magnetic field too high; ");
        }
        if ((data[1] & 0x10) != 0) {
            buf.append("Magnetic field too low; ");
        }
        if (strLen == buf.length()) {
            buf.append(" no problems");
        }
        buf.append("\n");
    }

    public static void format_MA730_diagInfo(StringBuilder buf, int data) {
        buf.append("\t diagnostic: ");
        if ((data & 0x80) != 0) {
            buf.append("Magnetic field too high; ");
        } else if ((data & 0x40) != 0) {
            buf.append("Magnetic field too low; ");
        } else {
            buf.append(" no problems");
        }
        buf.append("\n");
    }

    public static void format_RLS_Orbis_sub_diagInfo(StringBuilder buf, int data) {
        buf.append("\t diagnostic: ");
        if ((data & 2) != 0) {
            buf.append("Magnetic field is too high! Move magnet away. ");
        } else if ((data & 1) != 0) {
            buf.append("Magnetic field is too low! Move magnet closer. ");
        } else {
            buf.append("magnetic field is normal. ");
        }
        if ((data & 8) == 0) {
            buf.append("Position data is not valid. ");
        }
        if ((data & 4) == 0) {
            buf.append("Some operating conditions are close to limits. ");
        }
        buf.append("\n");
    }

    public static void format_ICMU_diagInfo(StringBuilder buf, int[] data) {
        StringBuilder err = new StringBuilder();
        if ((data[0] & 1) != 0) {
            err.append("poor level (master track); ");
        }
        if ((data[0] & 2) != 0) {
            err.append("clipping (master track); ");
        }
        if ((data[0] & 4) != 0) {
            err.append("poor level (nonius track); ");
        }
        if ((data[0] & 8) != 0) {
            err.append("clipping (nonius track); ");
        }
        if ((data[1] & 2) != 0) {
            err.append("Excessive signal frequency for internal 12 Bitconverter; ");
        }
        if ((data[1] & 4) != 0) {
            err.append("Excessive signal frequency for ABZ-converte; ");
        }
        if ((data[1] & 8) != 0) {
            err.append("Period counter consistency error:counted period\u2194calculated Nonius position; ");
        }
        if ((data[1] & 0x10) != 0) {
            err.append("Multiturn data consistency error:counted multiturn\u2194external MT data; ");
        }
        if ((data[1] & 0x20) != 0) {
            err.append("Multiturn communication error; ");
        }
        if ((data[1] & 0x40) != 0) {
            err.append("I2C communication error or no EEPROM; ");
        }
        if ((data[1] & 0x80) != 0) {
            err.append("Invalid check sum internal RAM; ");
        }
        buf.append("\t errors: ");
        buf.append(err.length() > 0 ? err : "no").append("\n");
        StringBuilder status = new StringBuilder();
        if ((data[0] & 0x10) != 0) {
            status.append("startup mode; ");
        }
        if ((data[1] & 1) != 0) {
            status.append("command execution in progress; ");
        }
        if (status.length() > 0) {
            buf.append("\t status: ").append((CharSequence)status).append("\n");
        }
    }

    public static void format_Aksim2_diagInfo(StringBuilder buf, int[] data) {
        StringBuilder err = new StringBuilder();
        for (int bit = 0; bit <= 14; ++bit) {
            if ((bit >= 8 || (data[1] & 1 << bit) == 0) && (bit < 8 || (data[0] & 1 << bit - 8) == 0)) continue;
            err.append(RLS_Aksim2_Errors[bit]).append("; ");
        }
        buf.append("\t errors: ").append(err.length() > 0 ? err : "no").append("\n");
        StringBuilder calib_status = new StringBuilder();
        calib_status.append("counter: " + (data[2] & 3) + "; ");
        for (int bit = 2; bit <= 6; ++bit) {
            if ((data[2] & 1 << bit) == 0) continue;
            calib_status.append(RLS_Aksim2_CalibStatus[bit]).append("; ");
        }
        buf.append("\t calibration status: ").append((CharSequence)calib_status).append("\n");
        buf.append("\t temperature: ").append((byte)data[3]).append("\n");
    }

    public static String formatBitSetFlags(int bits, String[] names) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (String name : names) {
            buf.append(name);
            buf.append("(");
            buf.append(bits >> i & 1);
            buf.append("), ");
            ++i;
        }
        return buf.substring(0, buf.length() - 2);
    }

    public static String formatStatusBits(int bits, String[] names, String s0, String s1) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (String name : names) {
            if (name != null) {
                buf.append(name);
                buf.append(":");
                buf.append((bits >> i & 1) == 1 ? s1 : s0);
                buf.append(", ");
            }
            ++i;
        }
        return buf.substring(0, buf.length() - 2);
    }

    public static String formatBitSet(int bits, String[] names, String emptySet) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        for (String name : names) {
            if ((bits & 1 << i) != 0) {
                buf.append(name);
                buf.append(", ");
            }
            ++i;
        }
        if (buf.length() == 0) {
            return emptySet;
        }
        return buf.substring(0, buf.length() - 2);
    }

    public static String formatVector(float[] v) {
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i < 3; ++i) {
            s.append(String.format("% 6.2f", Float.valueOf(v[i])));
            s.append(i < 2 ? "," : "]");
        }
        return s.toString();
    }

    public static void parseCmdCanDrvState(SerialCommand cmd) {
        StringBuilder buf = new StringBuilder(500);
        buf.append("CAN drivers diagnostics:\n");
        try {
            int connectedCnt = 0;
            for (int drvId = 1; drvId <= 7; ++drvId) {
                int flags = cmd.readByte();
                if ((flags & 8) != 0) {
                    ++connectedCnt;
                    buf.append("CAN_DRV# " + drvId + "\n");
                    buf.append("\tCAN bus errors: " + cmd.readWordUnsigned() + "\n");
                    buf.append("\tCAN bus error flags: " + BoardInfo.formatBitSet(flags, new String[]{"err warn irq", "err passive irq", "bus off irq"}, "none") + "\n");
                    buf.append("\tMCU temperature: " + cmd.readByteSigned() + " C\u00b0\n");
                    buf.append("\tExt. sensor temperature: " + cmd.readByteSigned() + " C\u00b0\n");
                    buf.append("\tInstant current: " + new DecimalFormat("#.##").format((float)cmd.readWordUnsigned() * 0.01f) + " A\n");
                    buf.append("\tInstant voltage: " + new DecimalFormat("#.##").format((float)cmd.readWordUnsigned() * 0.01f) + " V\n");
                    buf.append("\tI/O port state: " + BoardInfo.formatBitSetFlags(cmd.readByte(), new String[]{"LIMIT PORT", "INDEX PORT", "EMERGENCY PORT", "AUX PORT", "RS422_RE", "RS422_DE", "DRV_ENABLE", "SPI_CS"}) + "\n");
                    buf.append("\tShunt currents, A: " + new DecimalFormat("#.##").format((float)cmd.readWord() * 0.01f) + ", " + new DecimalFormat("#.##").format((float)cmd.readWord() * 0.01f) + ", " + new DecimalFormat("#.##").format((float)cmd.readWord() * 0.01f) + "\n");
                    int encType = cmd.readByte();
                    BoardInfo.formatEncoderInfo(buf, encType, 0, cmd.readByteArr(4));
                    buf.append("\t Encoder read errors: " + cmd.readWordUnsigned() + "\n");
                    buf.append("\n");
                    cmd.skipBytes(36 * drvId - cmd.getBytesRead());
                    continue;
                }
                cmd.skipBytes(35);
            }
            if (connectedCnt == 0) {
                buf.append("\tnot found\n");
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.toString());
        }
        SimpleBGC_GUIApp.mainView.debugMessageSynced(buf.toString());
    }

    public static String getCANModuleName(int id) {
        if (id > 0 && id < MODULE_NAMES.length) {
            return MODULE_NAMES[id];
        }
        return MODULE_NAMES[0] + " id=" + id;
    }

    public int getFrwVer() {
        return this.frwVer;
    }

    public int getBaseFrwVer() {
        return this.frwVerBranchBase > 0 ? this.frwVerBranchBase : this.frwVer;
    }

    public void setFrwVer(int frwVer) {
        this.frwVer = frwVer;
        this.frwVerShow = frwVer;
        if (frwVer > 0) {
            try {
                this.frwVer += Integer.parseInt(Settings.get("firmware_version.shift", "0"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getFrwVerShow() {
        return this.frwVerShow;
    }

    public int getCompatibleVer() {
        return this.frwVerBranchBase > 0 ? this.frwVerBranchBase : this.frwVer;
    }

    public void setBuildNumber(int val) {
        this.buildNumber = val;
    }

    public static String wrapBold(String s) {
        return html_enabled ? "<b>" + s + "</b>" : s;
    }

    public static final String getMainIMUModelName(int model) {
        if (model >= 0 && model < IMU_MODEL_NAMES.length) {
            return IMU_MODEL_NAMES[model];
        }
        return "unknown model " + model;
    }

    public String getMainIMUModelInfo(int main) {
        int model = this.imu_ext_model[main];
        int info = this.imu_ext_info[main];
        String res = BoardInfo.getMainIMUModelName(model);
        return res;
    }

    public boolean isExtIMUStatusSupported(int main) {
        return this._hasBoardFeature(0x1000000L) && this.imu_ext_model[main] == 5;
    }

    public static boolean hasUART3() {
        return BoardInfo.hasBoardFeature(0x8000000L);
    }

    public static ArrayList<Sprav> getSerialPortList() {
        ArrayList<Sprav> list = new ArrayList<Sprav>();
        for (Sprav s : SERIAL_PORTS) {
            if (s.getId() >= 4 && (s.getId() != 4 || !BoardInfo.hasUART3())) continue;
            list.add(s);
        }
        return list;
    }

    public static String getSerialPortName(int port) {
        for (Sprav s : SERIAL_PORTS) {
            if (s.getId() != port) continue;
            return s.getName();
        }
        return "unknown port <" + port + ">";
    }

    public static String getBoardVerName(int boardVer) {
        String name = BOARD_VER_NAMES.get(boardVer);
        return VersionFactory.formatBoardVersion(boardVer) + (name != null ? " \"" + name + "\"" : "");
    }

    public static boolean canRunIntCalibEncoder(int encType, boolean connectedToCanDrv) {
        return encType == 43 || encType == 14 && BoardInfo.checkMinBaseFirmwareVer(2707) || encType == 42 && BoardInfo.checkMinBaseFirmwareVer(2709);
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public static int getScriptSlotsNum() {
        return BoardInfo.checkMinBaseFirmwareVer(2708) && BoardInfo.hasBoardFeature(32768L) ? 10 : 5;
    }

    public static String getExtLicName(int type) {
        return type < EXT_LIC_TYPE_LIST.length ? EXT_LIC_TYPE_LIST[type] : "unknown";
    }

    public static String getExtLicParseStatus(int status) {
        if (status == 0) {
            return "valid for this device";
        }
        if (status == 255) {
            return "not applicable for this device";
        }
        return "parse error code 0x" + Integer.toHexString(status);
    }

    public static boolean hasVibrationTest() {
        return BoardInfo.checkMinBaseFirmwareVer(2720);
    }

    public static boolean hasTransferTest() {
        return BoardInfo.checkMinBaseFirmwareVer(2741);
    }

    public static String formatEmergencyStopErrorInfo(byte[] data) throws Exception {
        SerialCommand cmd = new SerialCommand(0, data);
        String info = null;
        int code = cmd.readByte();
        if (code != 0) {
            String str;
            int current;
            long time_ms = cmd.readDWordUnsigned();
            int[] imu_angle = cmd.readWord3();
            int[] motor_angle = cmd.readWord3();
            StringBuilder mot_info = new StringBuilder("\n\tMotors state:");
            for (int i = 0; i < 3; ++i) {
                int power = Math.abs(cmd.readWord()) / 100;
                current = cmd.readWordUnsigned();
                byte temp = cmd.readByteSigned();
                int flags = cmd.readWordUnsigned();
                cmd.skipBytes(6);
                mot_info.append(String.format("\n\t\t%s angle %.1f\u00b0, power: %d%%, current: %dmA, temperature: %d\u00b0C, flags: %s", BoardParams.AXIS_NAME[i], Float.valueOf(MathUtils.angle14_to_deg(motor_angle[i])), power, current, (int)temp, BoardInfo.formatBitSet(flags, POWER_STATE_MOT_FLAGS_NAMES, "no")));
            }
            int power_state = cmd.readByte();
            int voltage = cmd.readWordUnsigned();
            current = cmd.readWordUnsigned();
            int flags = cmd.readWordUnsigned();
            int i2c_errors = cmd.readWordUnsigned();
            int serial_errors = cmd.readWordUnsigned();
            int CAN_errors = cmd.readWordUnsigned();
            int CAN_flags = cmd.readByte();
            if (cmd.getBytesRead() > 96) {
                throw new Exception("64-byte limit exceeded (" + cmd.getBytesRead() + ")");
            }
            cmd.skipBytes(96 - cmd.getBytesRead());
            byte[] descr = cmd.readBytes(cmd.getBytesAvailable());
            info = String.format("code %d (%s) at time %.3fs", code, ErrorInfo.getSubErrorTitle(code), Float.valueOf((float)time_ms / 1000.0f));
            if (descr[0] != 0 && (str = new String(descr, StandardCharsets.ISO_8859_1)).length() > 0) {
                info = info + ", details: " + str;
            }
            info = info + String.format("\nSystem state at error:\n\tangle ROLL: %.1f\u00b0, PITCH: %.1f\u00b0, YAW: %.1f\u00b0", Float.valueOf(MathUtils.angle14_to_deg(imu_angle[0])), Float.valueOf(MathUtils.angle14_to_deg(imu_angle[1])), Float.valueOf(MathUtils.angle14_to_deg(imu_angle[2])));
            info = info + String.format("\n\tpower state: %s, bat.voltage: %.2f V, current: %.3f A, flags: %s", BoardInfo.getHashValById(SYSTEM_POWER_STATE, power_state), Float.valueOf((float)voltage / 100.0f), Float.valueOf((float)current / 1000.0f), BoardInfo.formatBitSet(flags, POWER_STATE_SYS_FLAGS_NAMES, "no"));
            info = info + mot_info;
            info = info + String.format("\n\tCommunication errors: I2C: %d, serial: %d, CAN: %d, CAN flags: %s", i2c_errors, serial_errors, CAN_errors, BoardInfo.formatBitSet(CAN_flags, CAN_BUS_ERROR_FLAGS_NAMES, "no"));
        }
        return info;
    }

    public static String getHashValById(HashMap<Integer, String> hm, Integer id) {
        String val = hm.get(id);
        return val != null ? val : "unknown (" + id + ")";
    }

    public static boolean hasMaxErrorData() {
        return BoardInfo.checkMinBaseFirmwareVer(2741);
    }

    public static boolean hasRealtimeDataCustom2() {
        return BoardInfo.checkMinBaseFirmwareVer(2742) && !Settings.is("realtime-data-old");
    }

    static {
        BOARD_VER_NAMES.put(30, "Regular");
        BOARD_VER_NAMES.put(31, "Tiny");
        BOARD_VER_NAMES.put(34, "OEM");
        BOARD_VER_NAMES.put(36, "Extended");
        BOARD_VER_NAMES.put(40, "BeSteady Four");
        BOARD_VER_NAMES.put(41, "Basecam Pro");
        BOARD_VER_NAMES.put(42, "Basecam Pro (2017)");
        BOARD_VER_NAMES.put(50, "CAN MCU");
        BOARD_VER_NAMES.put(32, "Regular+");
        BOARD_VER_NAMES.put(33, "Tiny+");
        BOARD_VER_NAMES.put(27, "GD32 Extended");
        BOARD_VER_NAMES.put(25, "GD32 Tiny+");
        BOARD_VER_NAMES.put(110, "GPS IMU 1.0");
        BOARD_VER_NAMES.put(120, "GPS IMU 1.2");
        EXT_LIC_TYPE_LIST = new String[]{"undefined", "CAN Drv license"};
        HW_FLAGS_NAMES = new String[]{"one-wire crypto IC"};
        POWER_STATE_MOT_FLAGS_NAMES = new String[]{"software limit is violated", "current exceeds the limit", "motor energized"};
        POWER_STATE_SYS_FLAGS_NAMES = new String[]{"software limit is violated", "overheat warning (mot. temp. > 80\u00b0C)", "internal drivers OTW (over-temp.warning) signal", "internal drivers FAULT signal"};
        SYSTEM_POWER_STATE = new HashMap();
        SYSTEM_POWER_STATE.put(-2, "POWER_STATE_ON_FROM_BACKUP");
        SYSTEM_POWER_STATE.put(-1, "POWER_STATE_STARTUP");
        SYSTEM_POWER_STATE.put(0, "POWER_STATE_OFF");
        SYSTEM_POWER_STATE.put(1, "POWER_STATE_ON");
        SYSTEM_POWER_STATE.put(2, "POWER_STATE_OFF_TEMPORARY");
        SYSTEM_POWER_STATE.put(3, "POWER_STATE_OFF_PARKING");
        SYSTEM_POWER_STATE.put(4, "POWER_STATE_ON_SAFE_STOP");
        CAN_BUS_ERROR_FLAGS_NAMES = new String[]{"err warn irq", "err passive irq", "bus off irq"};
        curBoardInfo = null;
        html_enabled = false;
        INT_DRV_STATUS_BITS = new StatusBit[]{new StatusBit("OVR_TEMP_WARN", Colored.NOT_SET_IS_BAD), new StatusBit("DRV_FAULT", Colored.NOT_SET_IS_BAD)};
        RLS_Aksim2_Errors = new String[]{"Error - Acceleration error. The position data changed too fast. A stray magnetic field is present or metal particles are present between the readhead and the ring", "Error - Magnetic pattern error. A stray magnetic field is present or metal particles are present between the readhead and the ring or radial positioning between the readhead and the ring is out of tolerance", "Error - System error. Malfunction inside the circuitry or inconsistent calibration data is detected. To reset the System error bit try to cycle the power supply while the rise time is shorter than 20 ms", "Error - Power supply error. The readhead power supply voltage is out of specified rang", "Warning - Temperature.  The readhead temperature is out of specified range", "Error - Signal lost. The readhead is out of alignment with the ring or the ring is damage", "Warning - Signal amplitude low. The distance between the readhead and the ring is too large", "Warning - Signal amplitude too high. The readhead is too close to the ring or an external magnetic field is present", "Warning. If bit is set, encoder is near operational limits. Position is valid. Resolution and / or accuracy might be lower than specified.", "Error. If bit is set, position is not valid", "Error - Encoder not configured properly", "Error - Sensor reading error, probably caused by electrical interference, ground loop or RFI", "Error - Magnetic sensor. Cycle power to the encoder", "Warning - Signal amplitude too high. The readhead is too close to the ring or an external magnetic field is present", "Error - Signal amplitude too high. The readhead is too close to the ring or an external magnetic field is present."};
        RLS_Aksim2_CalibStatus = new String[]{null, null, "Timeout. Encoder ring did not make a complete turn during 10 seconds", "Calculated parameters out of range. Mechanical installation is not inside tolerances", "Arc length parameter (0x19) out of range", "No correction needed (mechanical installation is perfect)", "Calibration was successfully performed, error map is in use."};
    }
}

