/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import sbgc.object.AdjVarAnalogCfg;
import sbgc.object.AdjVarTriggerCfg;
import sbgc.object.AutoPIDCfg2;
import sbgc.object.BoardInfo;
import sbgc.object.BoardProfile;
import sbgc.object.CANDeviceScanInfo;
import sbgc.object.CanDrvSoftParams;
import sbgc.object.ExtIMU;
import sbgc.object.GeometryCfg;
import sbgc.object.Motor4;
import sbgc.object.RCInputCalib;
import sbgc.object.SerialLinkCfg;
import sbgc.object.Sprav;
import sbgc.object.StepSignalCfg;
import sbgc.object.ThermostatCfg;
import sbgc.service.SerialCommand;
import sbgc.ui.Utils;
import sbgc.utils.LogScale;
import sbgc.utils.MathUtils;

@XStreamAlias(value="board-params")
public class BoardParams
implements Cloneable {
    static final Logger logger = Logger.getLogger((String)BoardParams.class.getName());
    public static final int ROLL = 0;
    public static final int PITCH = 1;
    public static final int YAW = 2;
    public static final String[] AXIS_NAME = new String[]{"ROLL", "PITCH", "YAW"};
    public static final String[] AXIS_ABBR = new String[]{"R", "P", "Y"};
    public static final String[] XYZ_NAME = new String[]{"X", "Y", "Z"};
    public static final int NUM_PROFILES_MAX = 5;
    public static final int CMD_NO = 0;
    public static final int CMD_PROFILE1 = 1;
    public static final int CMD_PROFILE2 = 2;
    public static final int CMD_PROFILE3 = 3;
    public static final int CMD_SWAP_PITCH_ROLL = 4;
    public static final int CMD_SWAP_YAW_ROLL = 5;
    public static final int CMD_CALIB_ACC = 6;
    public static final int CMD_RESET = 7;
    public static final int CMD_SET_ANGLE = 8;
    public static final int CMD_CALIB_GYRO = 9;
    public static final int CMD_MOTOR_TOGGLE = 10;
    public static final int CMD_MOTOR_ON = 11;
    public static final int CMD_MOTOR_OFF = 12;
    public static final int CMD_FRAME_UPSIDE_DOWN = 13;
    public static final int CMD_PROFILE4 = 14;
    public static final int CMD_PROFILE5 = 15;
    public static final int CMD_AUTO_PID = 16;
    public static final int CMD_LOOK_DOWN = 17;
    public static final int CMD_HOME_POSITION = 18;
    public static final int CMD_RC_BIND = 19;
    public static final int CMD_CALIB_GYRO_TEMP = 20;
    public static final int CMD_CALIB_ACC_TEMP = 21;
    public static final int CMD_BUTTON_PRESS = 22;
    public static final int CMD_RUN_SCRIPT1 = 23;
    public static final int CMD_RUN_SCRIPT10 = 32;
    public static final int CMD_CALIB_MAG = 33;
    public static final int CMD_LEVEL_ROLL_PITCH = 34;
    public static final int CMD_CENTER_YAW = 35;
    public static final int CMD_UNTWIST_CABLES = 36;
    public static final int CMD_SET_ANGLE_NO_SAVE = 37;
    public static final int CMD_HOME_POSITION_SHORTEST = 38;
    public static final int CMD_CENTER_YAW_SHORTEST = 39;
    public static final int CMD_ROTATE_YAW_180 = 40;
    public static final int CMD_ROTATE_YAW_180_FRAME_REL = 41;
    public static final int CMD_SWITCH_YAW_180_FRAME_REL = 42;
    public static final int CMD_SWITCH_POS_ROLL_90 = 43;
    public static final int CMD_TIMELAPSE_START = 44;
    public static final int CMD_CALIB_MOMENTUM = 45;
    public static final int CMD_LEVEL_ROLL = 46;
    public static final int CMD_TIMELAPSE_REPEAT = 47;
    public static final int CMD_LOAD_PROFILE_SET1 = 48;
    public static final int CMD_LOAD_PROFILE_SET2 = 49;
    public static final int CMD_LOAD_PROFILE_SET3 = 50;
    public static final int CMD_LOAD_PROFILE_SET4 = 51;
    public static final int CMD_LOAD_PROFILE_SET5 = 52;
    public static final int CMD_LOAD_PROFILE_SET_BACKUP = 53;
    public static final int CMD_INVERT_RC_ROLL = 54;
    public static final int CMD_INVERT_RC_PITCH = 55;
    public static final int CMD_INVERT_RC_YAW = 56;
    public static final int CMD_SNAP_FIXED_ANGLE = 57;
    public static final int CMD_CAMERA_REC_PHOTO_EVENT = 58;
    public static final int CMD_CAMERA_PHOTO_EVENT = 59;
    public static final int CMD_MOTORS_SAFE_STOP = 60;
    public static final int CMD_CALIB_ACC_AUTO = 61;
    public static final int CMD_RESET_IMU = 62;
    public static final int CMD_FORCED_FOLLOW_TOGGLE = 63;
    public static final int CMD_AUTO_PID_GAIN_ONLY = 64;
    public static final int CMD_LEVEL_PITCH = 65;
    public static final int CMD_MOTORS_SAFE_TOGGLE = 66;
    public static final int CMD_TIMELAPSE_STEP1 = 67;
    public static final int CMD_EXT_GYRO_ONLINE_CALIB = 68;
    public static final int CMD_DISABLE_FOLLOW_TOGGLE = 69;
    public static final int CMD_SET_CUR_POS_AS_HOME = 70;
    public static final int CMD_STOP_SCRIPT = 71;
    public static final int CMD_TRIPOD_MODE_OFF = 72;
    public static final int CMD_TRIPOD_MODE_ON = 73;
    public static final int CMD_SET_RC_TRIM = 74;
    public static final int CMD_HOME_POSITION_MOTORS = 75;
    public static final int CMD_RETRACTED_POSITION = 76;
    public static final int CMD_SHAKE_GENERATOR_OFF = 77;
    public static final int CMD_SHAKE_GENERATOR_ON = 78;
    public static final int CMD_SERVO_MODE_ON = 79;
    public static final int CMD_SERVO_MODE_OFF = 10;
    public static final int CMD_SERVO_MODE_TOGGLE = 81;
    public static final int RC_VIRT_MODE_NORMAL = 0;
    public static final int RC_VIRT_MODE_CPPM = 1;
    public static final int RC_VIRT_MODE_SBUS = 2;
    public static final int RC_VIRT_MODE_SPEKTRUM = 3;
    public static final int RC_VIRT_MODE_EX_BUS = 4;
    public static final int RC_VIRT_MODE_API = 10;
    public static final int RC_INPUT_MODE_ANALOG = 32;
    public static final int RC_INPUT_MODE_VIRT = 64;
    public static final int RC_INPUT_MODE_VIRT2 = 96;
    public static final int RC_INPUT_MODE_API_VIRT = 128;
    public static final int RC_INPUT_MODE_STEP_SIGNAL = 160;
    public static final int INPUT_NO = 0;
    public static final int RC_INPUT_ROLL = 1;
    public static final int RC_INPUT_PITCH = 2;
    public static final int EXT_FC_INPUT_ROLL = 3;
    public static final int EXT_FC_INPUT_PITCH = 4;
    public static final int RC_INPUT_YAW = 5;
    public static final int RC_INPUT_ADC1 = 33;
    public static final int RC_INPUT_ADC2 = 34;
    public static final int RC_INPUT_ADC3 = 35;
    public static final int RC_INPUT_ADC4 = 36;
    public static final int RC_INPUT_EXTRA_BTN_0 = 6;
    public static final int EXTRA_BTN_NUM = 5;
    public static final int EXTRA_BTN_PIN_MASK = 31;
    public static final int EXTRA_BTN_FLAG_INVERT = 128;
    public static final int EXTRA_BTN_FLAG_LATCHING = 64;
    public static final int BEEPER_MODE_CALIBRATE = 1;
    public static final int BEEPER_MODE_CONFIRM = 2;
    public static final int BEEPER_MODE_ERROR = 4;
    public static final int BEEPER_MODE_ALARM = 8;
    public static final int BEEPER_MODE_MOTORS = 128;
    public static final int IMU_TYPE_MAIN = 1;
    public static final int IMU_TYPE_FRAME = 2;
    public static final int ENCODER_TYPE_MASK = 65391;
    public static final int ENCODER_FORCE_BIT = 16;
    public static final int ENCODER_GEARED_BIT = 128;
    public static final int ENC_TYPE_AS5048A = 1;
    public static final int ENC_TYPE_AS5048B = 2;
    public static final int ENC_TYPE_AS5048_PWM = 3;
    public static final int ENC_TYPE_AMT203 = 4;
    public static final int ENC_TYPE_MA3_10BIT = 5;
    public static final int ENC_TYPE_MA3_12BIT = 6;
    public static final int ENC_TYPE_ANALOG = 7;
    public static final int ENC_TYPE_I2C_DRV1 = 8;
    public static final int ENC_TYPE_I2C_DRV2 = 9;
    public static final int ENC_TYPE_I2C_DRV3 = 10;
    public static final int ENC_TYPE_I2C_DRV4 = 11;
    public static final int ENC_TYPE_AS5600_PWM = 12;
    public static final int ENC_TYPE_AS5600_I2C = 13;
    public static final int ENC_TYPE_RLS_ORBIS_SPI = 14;
    public static final int ENC_TYPE_RLS_ORBIS_PWM_549 = 15;
    public static final int ENC_TYPE_INCODER_SPI = 32;
    public static final int ENC_TYPE_CAN_DRV = 33;
    public static final int ENC_TYPE_AM4096_I2C = 34;
    public static final int ENC_TYPE_TLE5012B_SPI = 35;
    public static final int ENC_TYPE_TLE5012B_PWM = 36;
    public static final int ENC_TYPE_A1335_SPI = 37;
    public static final int ENC_TYPE_A1335_I2C = 38;
    public static final int ENC_TYPE_MA730_SPI = 39;
    public static final int ENC_TYPE_MA730_PWM = 40;
    public static final int ENC_TYPE_AEAT_8800 = 41;
    public static final int ENC_TYPE_ICMU = 42;
    public static final int ENC_TYPE_AKSIM2 = 43;
    public static final int ENC_TYPE_AMT222 = 44;
    public static final int ENC_TYPE_INCODER_SSI6 = 45;
    public static final int ENC_TYPE_NETZER_VLX60 = 46;
    public static final int ENC_TYPE_AS5600L_I2C = 47;
    public static final int ENC_TYPE_BISS_C_GENERAL = 64;
    public static final int ENC_TYPE_DUAL_IMU = 65;
    public static final int[] ENC_EXTRA_CFG = new int[]{1, 4, 14, 32, 35, 37, 39, 42, 43, 44, 45, 46, 64};
    public static final int[] ENC_EXTENDED_FAMILY = new int[]{32, 42, 43, 46, 64};
    public static final LinkedHashMap<Integer, String> ENC_TYPE_NAMES = new LinkedHashMap();
    public static final LinkedHashMap<Integer, String> CAN_DRV_ENC_TYPE_NAMES = new LinkedHashMap();
    public static final LinkedHashMap<Integer, Integer[]> ENCODER_I2C_ADDRESS_RANGE = new LinkedHashMap();
    public static final String[] ENC_TYPE_AKSIM2_TYPES;
    public static final int ENC_SUB_TYPE_AS5048A = 1;
    public static final int ENC_SUB_TYPE_AS5048B = 2;
    public static final int ENC_SUB_TYPE_AS5600 = 7;
    public static final int ENC_SUB_TYPE_RLS_ORBIS = 10;
    public static final int ENC_SUB_TYPE_MA730 = 11;
    public static final int ENC_SUB_TYPE_AM4096 = 12;
    public static final String[] ENC_SUB_TYPE_NAMES;
    public static final int FLAG1_REMEBER_LAST_USED_PROFILE = 1;
    public static final int FLAG1_UPSIDE_DOWN_AUTO = 2;
    public static final int FLAG1_SWAP_FRAME_MAIN_IMU = 4;
    public static final int FLAG1_BLINK_PROFILE = 8;
    public static final int FLAG1_EMERGENCY_STOP = 16;
    public static final int FLAG1_MAG_POS_FRAME = 32;
    public static final int FLAG1_FRAME_IMU_FF = 64;
    public static final int FLAG1_OVERHEAT_STOP_MOTORS = 128;
    public static final int FLAG1_CENTER_YAW_AT_STARTUP = 256;
    public static final int FLAG1_SWAP_RC_SERIAL_UART_B = 512;
    public static final int FLAG1_UART_B_SERIAL_API = 1024;
    public static final int FLAG1_BLINK_BAT_LEVEL = 2048;
    public static final int FLAG1_ADAPTIVE_GYRO_TRUST = 4096;
    public static final int FLAG1_IS_UPSIDE_DOWN = 8192;
    public static final int FLAG1_UART_3_SERIAL_API = 16384;
    public static final int FLAG1_FRAME_INV_RC_INV = 32768;
    public static final int FLAG2_SEARCH_LIMIT_ROLL = 1;
    public static final int FLAG2_SEARCH_LIMIT_PITCH = 2;
    public static final int FLAG2_SEARCH_LIMIT_YAW = 4;
    public static final int FLAG2_AUTO_CALIBRATE_MOMENTUM = 8;
    public static final int FLAG2_USE_MOMENTUM_FEED_FORWARD = 16;
    public static final int FLAG2_MOTORS_OFF_AT_STARTUP = 32;
    public static final int FLAG2_FC_BELOW_OUTER = 64;
    public static final int FLAG2_DO_NOT_CHECK_ENCODER_LIMITS = 128;
    public static final int FLAG2_AUTO_SAVE_BACKUP_SLOT = 256;
    public static final int FLAG2_FC_BELOW_MIDDLE = 512;
    public static final int FLAG2_ENVIRONMENT_TEMP_UNKNOWN = 1024;
    public static final int FLAG2_LPF_EXTENDED_RANGE = 2048;
    public static final int FLAG2_SAVE_SYSTEM_STAT = 4096;
    public static final int FLAG2_DISABLE_ACC = 8192;
    public static final int FLAG2_DISABLE_POWER_MANAGER = 16384;
    public static final int FLAG2_ALLOW_FRAME_IMU_AS_MAIN = 32768;
    public static final int FLAG3_ENC_LUT_ROLL = 1;
    public static final int FLAG3_MAVLINK_YAW_ABS = 8;
    public static final int FLAG3_EXT_SENS_AS_REFERENCE = 16;
    public static final int FLAG3_DISABLE_BT = 32;
    public static final int FLAG3_ALLOW_SENSOR_RECOVERY = 64;
    public static final int FLAG3_UART2_ALT = 128;
    public static final int FLAG3_PASS_LIMIT_ROLL = 256;
    public static final int FLAG3_PASS_LIMIT_YAW = 1024;
    public static final int FLAG3_DONT_PUSH_LIMITS_ROLL = 2048;
    public static final int FLAG3_DONT_PUSH_LIMITS_PITCH = 4096;
    public static final int FLAG3_DONT_PUSH_LIMITS_YAW = 8192;
    public static final int FLAG3_TRIPOD_MODE_AUTO = 16384;
    public static final int FLAG3_TRIPOD_MODE_GYRO_ONLINE_CALIB = 32768;
    public static final int FLAG3_RETRACTED_POSITON_MOTORS_OFF = 65536;
    public static final int FLAG3_CAN_IMU_THERMOSTAT_ENABLE = 131072;
    public static final int FLAG3_RETRACTED_POSITON_SHORTEST = 262144;
    public static final int FLAG3_RETRACTED_POSITON_ALLOW_CONTROL = 524288;
    public static final int FLAG3_ACC_LIMIT_EXT_RANGE = 0x100000;
    public static final int FLAG3_MOVE_SHORT_PATH_ROLL = 0x200000;
    public static final int FLAG3_MOVE_SHORT_PATH_PITCH = 0x400000;
    public static final int FLAG3_MOVE_SHORT_PATH_YAW = 0x800000;
    public static final int FLAG3_FRAME_INV_SOFT_LIMIT_MIDDLE = 0x1000000;
    public static final int FLAG3_FRAME_INV_SOFT_LIMIT_OUTER = 0x2000000;
    public static final int FLAG3_CAN_IMU_SERVO1_DUTY_MODE = 0x4000000;
    public static final int FLAG3_CAN_IMU_SERVO2_DUTY_MODE = 0x8000000;
    public static final int FLAG3_EXT_POWER_SWITCH_ENABLED = 0x10000000;
    public static final int FLAG3_WRAP_ENC_LIMITS_ROLL = 0x20000000;
    public static final int FLAG3_WRAP_ENC_LIMITS_PITCH = 0x40000000;
    public static final int FLAG3_WRAP_ENC_LIMITS_YAW = Integer.MIN_VALUE;
    public static final int FLAG4_ACC_LIMIT_BY_MOMENTUM = 1;
    public static final int FLAG4_CALIB_MOMENTUM_IN_NORMAL_POS = 2;
    public static final int FLAG4_EULER_INVERSE_INIT_BIT_SHIFT = 2;
    public static final int FLAG4_EULER_INVERSE_INIT_MASK = 12;
    public static final int FLAG4_PID_V3 = 16;
    public static final String[] RC_VIRT_CH_MOTOR_ANGLE_NAMES;
    public static final String[] RC_VIRT2_CH_NAMES;
    public static final int STARTUP_ACTION_NUM = 4;
    public static final int CAN_DRV_NUM_MAX = 7;
    public static final int EEPROM_CAN_DRV_PARAMS_ADDR = 3200;
    public static final int EEPROM_CAN_DRV_PARAMS_SIZE = 896;
    public static final int EEPROM_SERIAL_LINK_CFG_ADDR = 4352;
    public static final int EEPROM_SERIAL_LINK_CFG_SIZE = 64;
    public static final int EEPROM_EMG_STOP_ERR_INFO_ADDR = 4416;
    public static final int EEPROM_EMG_STOP_ERR_INFO_SIZE = 128;
    public static final int EEPROM_EMG_STOP_ERR_DATA_SIZE = 96;
    public static final int FORCE_POSITION_FLAG_FINE_ADJUST = 128;
    public static final int FORCE_POSITION_FLAG_IGNORE_LIMITS = 64;
    public static final int FORCE_POSITION_FLAG_STARTUP = 32;
    public static final int FORCE_POSITION_FLAG_BUTTON_PRESS = 16;
    public static final int FORCE_POSITION_SNAP_MASK = 3;
    public static final int STEP_SIGNAL_CFG_NUM = 6;
    public static final int RC_INPUT_CALIB_NUM = 5;
    public static final int[] AUX_PIN_ID;
    public static final int INTERRUPT_CFG_PIN_MASK = 31;
    public static final int INTERRUPT_CFG_FLAG_EMERGENCY = 32;
    public static final int INTERRUPT_CFG_FLAG_PARKING = 64;
    public static final int FC_POS_BELOW_OUTER = 1;
    public static final int FC_POS_ABOVE_OUTER = 2;
    public static final int FC_POS_BELOW_MIDDLE = 8;
    public static final int FC_POS_MAIN_IMU = 9;
    private static BoardParams curParams;
    public static final String PORT_FUNC_DISABLED = "disabled";
    public static final String PORT_FUNC_SERIAL_API = "Serial API";
    public static final String PORT_FUNC_MAVLINK = "MavLink";
    public static final String PORT_FUNC_SPEKTRUM = "Spektrum";
    public static final String PORT_FUNC_SBUS = "Futaba s-bus";
    public static final String PORT_FUNC_EX_BUS = "Jeti EX Bus";
    public static final String PORT_FUNC_EXT_IMU = "External IMU";
    public static final int LED_MODE_MASK = 2056;
    public static final int LED_MODE_CUR_PROFILE = 8;
    public static final int LED_MODE_BAT_LEVEL = 2048;
    public static final int LED_MODE_SERIAL_CONN = 2056;
    public static final LogScale EXT_PID_LOG_SCALE;
    public static final LogScale SERVO_OUTER_P_GAIN_LOG_SCALE;
    public static final int EXT_SENS_KVH_b = 7;
    public static final int EXT_SENS_EPSON_a = 33;
    public static final int EXT_SENS_EPSON_b = 42;
    public static final int EXT_SENS_KEBNI_AHRS = 66;
    @XStreamOmitField
    public LoadedFrom loadedFrom = LoadedFrom.NO;
    @XStreamOmitField
    public BoardProfile[] profiles;
    public int axisTop = 0;
    public int axisRight = 0;
    public int frameAxisTop = 0;
    public int frameAxisRight = 0;
    public int magAxisTop = 0;
    public int magAxisRight = 0;
    public int gyroDeadband = 0;
    public int gyroSens = 0;
    public int frame_imu_pos = 0;
    public int i2c_fast = 0;
    public int gyro_calib = 0;
    public int[] rcCmd = new int[]{0, 0, 0};
    public int[] menuCmd = new int[]{0, 0, 0, 0, 0, 0};
    @XStreamAlias(value="outputMap")
    public int[] outputMap_general = new int[]{0, 0, 0};
    public int[] followOffset = new int[]{0, 0, 0};
    public float[] followOffset_f = new float[]{0.0f, 0.0f, 0.0f};
    public int bat_threshold_alarm = 0;
    public int bat_threshold_motors = 0;
    public int bat_comp_ref = 0;
    public int beeper_modes;
    public int beeper_volume = 50;
    @XStreamAlias(value="rcMemory")
    public int[] rcMemory_deprecated = new int[]{0, 0, 0};
    public int general_flags1 = 0;
    public boolean[] invert = new boolean[]{false, false, false};
    public int[] poles = new int[]{0, 0, 0};
    public int general_flags2 = 0;
    public int general_flags3 = 0;
    public int general_flags4 = 0;
    public int[] encoder_types = new int[]{0, 0, 0};
    public int[] encoder_offset = new int[]{0, 0, 0};
    public int reserved_encoder_type;
    public int reserved_encoder_cfg;
    public int[] encoder_fld_offset = new int[]{0, 0, 0};
    public int[] manual_set_time = new int[]{0, 0, 0};
    public int[] motor_heating_factor = new int[]{0, 0, 0};
    public int[] motor_cooling_factor = new int[]{0, 0, 0};
    public int[] encoder_cfgs = new int[]{0, 0, 0};
    public int[] encoder_cfg_ext = new int[]{0, 0, 0};
    public int[] encoder_mag_link = new int[]{0, 0, 0};
    public int[] motor_mag_link = new int[]{0, 0, 0};
    public int[] motor_gear = new int[]{0, 0, 0};
    public int[] encoder_limit_min = new int[]{0, 0, 0};
    public int[] encoder_limit_max = new int[]{0, 0, 0};
    public int[] frame_cam_angle_min = new int[]{0, 0, 0};
    public int[] frame_cam_angle_max = new int[]{0, 0, 0};
    public int[] encoder_gear_ratio = new int[]{0, 0, 0};
    public int magDeclination = 0;
    public AdjVarTriggerCfg[] adj_vars_trigger = new AdjVarTriggerCfg[10];
    public AdjVarAnalogCfg[] adj_vars_analog = new AdjVarAnalogCfg[15];
    public String adj_vars_LUT = null;
    public int orderOfAxes = 0;
    public int[] mavlink_src = new int[]{0, 0};
    public int[] mavlink_sys_id = new int[]{0, 0};
    public int[] mavlink_comp_id = new int[]{0, 0};
    public int[] mavlink_flags = new int[]{0, 0};
    public int[][] mavlink_reserved = new int[][]{new int[3], new int[3]};
    public int frame_imu_lpf_freq = 10;
    public int auto_pid_cfg;
    public int auto_pid_precision;
    public int auto_pid_momentum;
    @XStreamOmitField
    public int curProfile = 0;
    @XStreamOmitField
    public int curProfileBoard = -1;
    @XStreamOmitField
    public int curIMU = 1;
    public int auto_speed = 120;
    public int auto_acc_limit = 60;
    public int auto_timeout = 10000;
    public int[] orientation_corr = new int[]{0, 0, 0};
    public int emergencyStopRestartDelay = 0;
    public int[] momentum = new int[]{0, 0, 0};
    public int[] momentum_stimulus = new int[]{0, 0, 0};
    public int[] momentum_ellipticity = new int[]{0, 0, 0};
    public int outer_motor_tilt = 0;
    public int middle_motor_tilt = 0;
    public int[] startup_action_src = new int[8];
    public int[] startup_action_thr = new int[8];
    public int[] startup_action = new int[4];
    public LinkedHashMap<String, CANDeviceScanInfo> CAN_device_id_map = null;
    public CanDrvSoftParams[] CAN_Drv_soft_params = null;
    public int[] reaction_drv_id = new int[]{0, 0, 0};
    public int[] force_position = new int[]{0, 0, 0};
    public StepSignalCfg[] step_signal_cfg = null;
    public RCInputCalib[] rc_input_calib = null;
    public int parking_cfg;
    public int ext_led_pin;
    public int ext_buzzer_pin;
    public int interrupt_cfg;
    public int overload_time;
    public int rc_serial_speed;
    public int uart2_speed;
    public int[] motor_res = new int[]{0, 0, 0};
    public int current_limit = 0;
    public Motor4 motor4 = new Motor4();
    public ExtIMU extIMU = new ExtIMU();
    public int[] limit_width = new int[]{100, 100, 100};
    public int[] limit_ret_speed = new int[]{0, 0, 0};
    public String[] custom_tunes = new String[]{"", "", "", ""};
    public int improve_mid_mot_pos;
    public int[] extra_btn_cfg = new int[5];
    public AutoPIDCfg2 auto_pid_cfg2 = null;
    public int overcurrent_protection;
    public int power_on_delay;
    public int power_off_delay;
    public int power_on_limiter;
    public byte[] power_control_reserved = new byte[4];
    public int ext_sens_type;
    public float ext_sens_calib_val;
    public byte[] ext_sens_params_reserved = new byte[12];
    public int motor_startup_delay_ms;
    public SerialLinkCfg serial_link_cfg = null;
    public int[] imu_model = new int[2];
    public int tripod_mode_auto_threshold = 20;
    public int defaultProfile;
    public int[] retracted_angle = new int[3];
    @XStreamOmitField
    public ThermostatCfg thermo_cfg = null;
    public GeometryCfg geometry_cfg = null;
    public int[] ext_motor_drv_id = new int[7];
    public int[] imu_angle_corr = new int[2];
    public int[] can_imu_servo_out = new int[2];
    public int can_imu_servo_rate;
    public int ext_switch_shunt_r;
    public int control_ff_lpf_freq;
    public static final String[] axisMapNames;

    public static final String getAxisName(int axis) {
        return AXIS_NAME[axis];
    }

    public static final String getAxisAbbr(int axis) {
        return AXIS_ABBR[axis];
    }

    public static final String getXYZName(int axis) {
        return XYZ_NAME[axis];
    }

    public BoardParams() {
        int i;
        this.profiles = new BoardProfile[5];
        for (i = 0; i < 5; ++i) {
            this.profiles[i] = new BoardProfile();
        }
        for (i = 0; i < this.adj_vars_trigger.length; ++i) {
            this.adj_vars_trigger[i] = new AdjVarTriggerCfg();
        }
        for (i = 0; i < this.adj_vars_analog.length; ++i) {
            this.adj_vars_analog[i] = new AdjVarAnalogCfg();
        }
        this.CAN_Drv_soft_params = CanDrvSoftParams.getDefaultValues();
        this.step_signal_cfg = new StepSignalCfg[6];
        for (i = 0; i < 6; ++i) {
            this.step_signal_cfg[i] = new StepSignalCfg();
        }
        this.rc_input_calib = new RCInputCalib[5];
        for (i = 0; i < this.rc_input_calib.length; ++i) {
            this.rc_input_calib[i] = new RCInputCalib();
        }
        this.geometry_cfg = new GeometryCfg();
    }

    public static int constrain(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static BoardParams getCurParams() {
        return curParams;
    }

    public static void setCurParams(BoardParams params) {
        curParams = params;
    }

    public static int getCurProfileIdx() {
        return curParams != null ? BoardParams.curParams.curProfile : -1;
    }

    public static BoardProfile getCurProfile() {
        if (curParams != null) {
            return BoardParams.curParams.profiles[BoardParams.curParams.curProfile];
        }
        return null;
    }

    public void parse(SerialCommand cmd, int profile, BoardInfo boardInfo) throws IOException {
        logger.info((Object)("Parsing cmd " + cmd.id + " for profile " + profile + ".."));
        if (profile < 0 || profile >= 5) {
            throw new IOException("Wrong profile " + profile);
        }
        BoardProfile p = this.profiles[profile];
        if (cmd.id == 33) {
            p.notchFreq1 = cmd.readByte3();
            p.notchWidth1 = cmd.readByte3();
            p.notchFreq2 = cmd.readByte3();
            p.notchWidth2 = cmd.readByte3();
            p.notchFreq3 = cmd.readByte3();
            p.notchWidth3 = cmd.readByte3();
            p.lpfFreq = cmd.readWord3();
            int i = 0;
            while (i < 3) {
                int f = cmd.readByte();
                p.notchEnabled1[i] = (f & 1) > 0;
                p.notchEnabled2[i] = (f & 2) > 0;
                p.notchEnabled3[i] = (f & 4) > 0;
                p.lpfEnabled[i] = (f & 8) > 0;
                p.lpf1[i] = (f & 0x10) > 0;
                int n = i;
                p.notchFreq1[n] = p.notchFreq1[n] * 2;
                int n2 = i;
                p.notchFreq2[n2] = p.notchFreq2[n2] * 2;
                int n3 = i++;
                p.notchFreq3[n3] = p.notchFreq3[n3] * 2;
            }
            this.encoder_offset = cmd.readWord3();
            this.encoder_fld_offset = cmd.readWord3();
            this.manual_set_time = cmd.readByte3();
            this.motor_heating_factor = cmd.readByte3();
            this.motor_cooling_factor = cmd.readByte3();
            this.reserved_encoder_type = cmd.readByte();
            this.reserved_encoder_cfg = cmd.readByte();
            p.followInsideDeadband = cmd.readByte();
            this.encoder_mag_link = cmd.readByte3();
            this.motor_gear = cmd.readWordUnsigned3();
            this.encoder_limit_min = cmd.readByteSignedArr(3);
            this.encoder_limit_max = cmd.readByteSignedArr(3);
            p.notchGain1 = cmd.readByteSignedArr(3);
            p.notchGain2 = cmd.readByteSignedArr(3);
            p.notchGain3 = cmd.readByteSignedArr(3);
            this.beeper_volume = cmd.readByte();
            for (i = 0; i < 3; ++i) {
                this.encoder_gear_ratio[i] = cmd.readWordUnsigned();
                this.motor_mag_link[i] = this.encoder_mag_link[i] * 100;
            }
            this.encoder_types = cmd.readByte3();
            this.encoder_cfgs = cmd.readByte3();
            p.outerP = cmd.readByte3();
            cmd.skipBytes(3);
            this.magAxisTop = cmd.readByteSigned();
            this.magAxisRight = cmd.readByteSigned();
            p.magTrust = cmd.readByte();
            this.magDeclination = cmd.readByteSigned();
            p.accLPFFreq = cmd.readWordUnsigned();
            for (i = 0; i < 3; ++i) {
                p.d_lpfFreq[i] = cmd.readByte() * (BoardInfo.hasExtPIDRange() ? 2 : 10);
            }
        } else if (cmd.id == 62) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.mavlink_src[i] = cmd.readByte();
                this.mavlink_sys_id[i] = cmd.readByte();
                this.mavlink_comp_id[i] = cmd.readByte();
                this.mavlink_flags[i] = cmd.readWordUnsigned();
                this.mavlink_reserved[i] = cmd.readByteArr(3);
            }
            this.motor_mag_link = cmd.readWordUnsigned3();
            p.angleAccLimit3 = cmd.readByte3();
            for (int axis = 0; axis < 3; ++axis) {
                int gain = cmd.readByte();
                if (BoardInfo.hasExtPIDRange()) {
                    p.setPIDGainLog(axis, gain);
                    continue;
                }
                p.setPIDGainCompressed(axis, gain);
            }
            this.frame_imu_lpf_freq = cmd.readByte();
            this.auto_pid_cfg = cmd.readByte();
            this.auto_pid_precision = cmd.readByte();
            this.frame_cam_angle_min = cmd.readWord3();
            this.frame_cam_angle_max = cmd.readWord3();
            this.general_flags2 = cmd.readWordUnsigned();
            this.auto_speed = cmd.readByte();
            this.auto_acc_limit = cmd.readByte();
            this.orientation_corr = cmd.readWord3();
            p.timelapseTime = cmd.readWordUnsigned();
            this.emergencyStopRestartDelay = cmd.readWordUnsigned();
            p.timelapseAccPart = cmd.readByte();
            this.momentum = cmd.readWordUnsigned3();
            this.momentum_stimulus = cmd.readByte3();
            this.momentum_ellipticity = cmd.readByte3();
            p.follow_range = cmd.readByte3();
            p.stabAxis = cmd.readByte3();
            this.outer_motor_tilt = cmd.readByteSigned();
            this.startup_action = cmd.readByteArr(4);
            this.startup_action_src = cmd.readByteArr(8);
            this.startup_action_thr = cmd.readByteSignedArr(8);
            this.force_position = cmd.readByte3();
            for (i = 0; i < this.step_signal_cfg.length; ++i) {
                this.step_signal_cfg[i].readConfig(cmd);
            }
            for (i = 0; i < 5; ++i) {
                this.rc_input_calib[i].readConfig(cmd);
            }
            this.parking_cfg = cmd.readByte();
            this.ext_led_pin = cmd.readByte();
            this.interrupt_cfg = cmd.readWordUnsigned();
            this.overload_time = cmd.readByte();
            this.auto_pid_momentum = cmd.readByte();
            p.jerk_slope_ms = cmd.readByte3();
            p.mav_ctrl_mode = cmd.readByte();
            this.rc_serial_speed = cmd.readByte();
            this.uart2_speed = cmd.readByte();
            this.motor_res = cmd.readByte3();
            this.current_limit = cmd.readWordUnsigned();
            this.middle_motor_tilt = cmd.readByteSigned();
        } else if (cmd.id == 104) {
            this.motor4.readConfig(cmd);
            this.extIMU.readConfig(cmd);
            this.limit_width = cmd.readByte3();
            p.adc_replace = cmd.readByte3();
            this.improve_mid_mot_pos = cmd.readByte();
            this.extra_btn_cfg = cmd.readByteArr(5);
            this.overcurrent_protection = cmd.readByte();
            this.power_on_delay = cmd.readByte();
            this.power_off_delay = cmd.readByte();
            this.power_on_limiter = cmd.readByte();
            cmd.read(this.power_control_reserved);
            p.lpf_Q_inv = cmd.readByte3();
            this.ext_sens_type = cmd.readByte();
            p.profile_flags2 = cmd.readWordUnsigned();
            this.reaction_drv_id = cmd.readByte3();
            this.general_flags3 = (int)cmd.readDWord();
            for (int i = 0; i < 3; ++i) {
                this.followOffset_f[i] = MathUtils.angle14_to_deg(cmd.readWord());
                if (this.followOffset_f[i] != 0.0f) continue;
                this.followOffset_f[i] = this.followOffset[i];
            }
            this.motor_startup_delay_ms = cmd.readWordUnsigned();
            this.imu_model = cmd.readByteArr(2);
            p.stabThreshold = cmd.readByte3();
            this.ext_buzzer_pin = cmd.readByte();
            this.limit_ret_speed = cmd.readByteSignedArr(3);
            this.tripod_mode_auto_threshold = cmd.readByte();
            p.rcDeadbandSplit = cmd.readByteArr(2);
            p.rcExpoRateSplit = cmd.readByteArr(2);
            p.profile_flags3 = cmd.readDWordUnsigned();
            this.defaultProfile = cmd.readByteSigned();
            this.retracted_angle = cmd.readWord3();
            p.shakeGenerator.readCmd(cmd);
            cmd.readByteArr(this.ext_motor_drv_id);
            cmd.readWordArrUnsigned(this.encoder_cfg_ext);
            this.ext_sens_calib_val = cmd.readFloat();
            cmd.read(this.ext_sens_params_reserved);
            cmd.readWordArr(this.imu_angle_corr);
            cmd.readByteArr(this.can_imu_servo_out);
            this.can_imu_servo_rate = cmd.readByte() * 10;
            p.servo_outerP_gain = SERVO_OUTER_P_GAIN_LOG_SCALE.from_log(cmd.readByte());
            p.servo_outerI = EXT_PID_LOG_SCALE.from_log(cmd.readByte());
            this.ext_switch_shunt_r = cmd.readWordUnsigned();
            this.general_flags4 = (int)cmd.readDWord();
            this.auto_timeout = cmd.readByte() * 100;
            this.control_ff_lpf_freq = cmd.readByte();
            cmd.readByteArr(p.reserved_ext3);
        } else {
            int i;
            for (i = 0; i < 3; ++i) {
                int P = cmd.readByte();
                int I = cmd.readByte();
                int D = cmd.readByte();
                if (BoardInfo.hasExtPIDRange()) {
                    p.P_f[i] = EXT_PID_LOG_SCALE.from_log(P);
                    p.I_f[i] = EXT_PID_LOG_SCALE.from_log(I);
                    p.D_f[i] = EXT_PID_LOG_SCALE.from_log(D);
                } else {
                    p.P_f[i] = P;
                    p.I_f[i] = I;
                    p.D_f[i] = D;
                }
                p.power[i] = cmd.readByte();
                this.invert[i] = cmd.readBoolean();
                this.poles[i] = cmd.readByte();
            }
            p.angleAccLimit3[0] = cmd.readByte();
            for (i = 0; i < 2; ++i) {
                p.extFCGain[i] = cmd.readByteSigned();
            }
            for (i = 0; i < 3; ++i) {
                p.rcMinAngle[i] = cmd.readWord();
                p.rcMaxAngle[i] = cmd.readWord();
                p.rcMode[i] = cmd.readByte();
                p.rcLPF[i] = cmd.readByte();
                p.rcSpeed[i] = cmd.readByte();
                p.rcFollow[i] = cmd.readByteSigned();
            }
            p.gyroTrust = cmd.readByte();
            p.accCompModel = cmd.readByte();
            p.pwmFreq = cmd.readByte();
            p.serialSpeed = cmd.readByte();
            for (i = 0; i < p.rcTrim.length; ++i) {
                p.rcTrim[i] = cmd.readByteSigned();
            }
            p.rcDeadband = cmd.readByte();
            p.rcExpoRate = cmd.readByte();
            p.rcVirtMode = cmd.readByte();
            cmd.readByteArr(p.rcMap);
            cmd.readByteArr(p.rcMix);
            p.followMode = cmd.readByte();
            p.followDeadband = cmd.readByte();
            p.followExpoRate = cmd.readByte();
            for (i = 0; i < 3; ++i) {
                this.followOffset[i] = cmd.readByteSigned();
            }
            this.axisTop = cmd.readByteSigned();
            this.axisRight = cmd.readByteSigned();
            if (cmd.id != 82) {
                this.frameAxisTop = cmd.readByteSigned();
                this.frameAxisRight = cmd.readByteSigned();
                this.frame_imu_pos = cmd.readByte();
            }
            this.gyroDeadband = cmd.readByte();
            this.gyroSens = cmd.readByte();
            this.i2c_fast = cmd.readByte();
            this.gyro_calib = cmd.readByte();
            cmd.readByteArr(this.rcCmd);
            cmd.readByteArr(this.menuCmd);
            cmd.readByteArr(p.outputMap);
            this.bat_threshold_alarm = cmd.readWord();
            this.bat_threshold_motors = cmd.readWord();
            this.bat_comp_ref = cmd.readWord();
            this.beeper_modes = cmd.readByte();
            p.follow_roll_mix_start = cmd.readByte();
            p.follow_roll_mix_range = cmd.readByte();
            cmd.readByteArr(p.boosterPower);
            cmd.readByteArr(p.followSpeed);
            p.flags4 = cmd.readByte();
            if (cmd.id != 82) {
                cmd.readWordArr(p.rcMemory);
                cmd.readByteArr(p.servoOut);
                p.servoRate = cmd.readByte() * 10;
                p.adaptivePIDEnabled = cmd.readByte();
                p.adaptivePIDThreshold = cmd.readByte();
                p.adaptivePIDRate = cmd.readByte();
                p.adaptivePIDRecoveryFactor = cmd.readByte();
                cmd.readByteArr(p.followLPF);
                this.general_flags1 = cmd.readWordUnsigned();
                p.profile_flags1 = cmd.readWordUnsigned();
                p.spektrumMode = cmd.readByte();
                this.orderOfAxes = cmd.readByte();
                p.eulerOrder = cmd.readByte();
                this.curIMU = cmd.readByte();
            }
            this.curProfileBoard = this.curProfile = BoardParams.constrain(cmd.readByte(), 0, 4);
        }
        cmd.checkFinished();
    }

    public void parseAdjVarsReadCmd(SerialCommand cmd) throws IOException {
        int i;
        logger.info((Object)"Parsing adj.vars configuration..");
        for (i = 0; i < this.adj_vars_trigger.length; ++i) {
            this.adj_vars_trigger[i].readCfgCmd(cmd);
        }
        for (i = 0; i < this.adj_vars_analog.length; ++i) {
            this.adj_vars_analog[i].readCfgCmd(cmd);
        }
    }

    public SerialCommand formatWriteCommand(int profile, int cmd_id, BoardInfo boardInfo) throws IOException {
        try {
            SerialCommand cmd = new SerialCommand(cmd_id);
            cmd.writeByte(profile);
            BoardProfile p = this.profiles[profile];
            if (cmd.id == 34) {
                int i;
                int[] freq1 = new int[3];
                int[] freq2 = new int[3];
                int[] freq3 = new int[3];
                for (i = 0; i < 3; ++i) {
                    freq1[i] = p.notchFreq1[i] / 2;
                    freq2[i] = p.notchFreq2[i] / 2;
                    freq3[i] = p.notchFreq3[i] / 2;
                }
                cmd.writeByteArr(freq1);
                cmd.writeByteArr(p.notchWidth1);
                cmd.writeByteArr(freq2);
                cmd.writeByteArr(p.notchWidth2);
                cmd.writeByteArr(freq3);
                cmd.writeByteArr(p.notchWidth3);
                cmd.writeWordArr(p.lpfFreq);
                for (i = 0; i < 3; ++i) {
                    int f = 0;
                    if (p.notchEnabled1[i]) {
                        f |= 1;
                    }
                    if (p.notchEnabled2[i]) {
                        f |= 2;
                    }
                    if (p.notchEnabled3[i]) {
                        f |= 4;
                    }
                    if (p.lpfEnabled[i]) {
                        f |= 8;
                    }
                    if (p.lpf1[i]) {
                        f |= 0x10;
                    }
                    cmd.writeByte(f);
                }
                cmd.writeWordArr(this.encoder_offset);
                cmd.writeWordArr(this.encoder_fld_offset);
                cmd.writeByteArr(this.manual_set_time);
                cmd.writeByteArr(this.motor_heating_factor);
                cmd.writeByteArr(this.motor_cooling_factor);
                cmd.writeByte(this.reserved_encoder_type);
                cmd.writeByte(this.reserved_encoder_cfg);
                cmd.writeByte(p.followInsideDeadband);
                cmd.writeByteArr(this.encoder_mag_link);
                cmd.writeWordArr(this.motor_gear);
                cmd.writeByteArr(this.encoder_limit_min);
                cmd.writeByteArr(this.encoder_limit_max);
                cmd.writeByteSignedArr(p.notchGain1);
                cmd.writeByteSignedArr(p.notchGain2);
                cmd.writeByteSignedArr(p.notchGain3);
                cmd.writeByte(this.beeper_volume);
                for (i = 0; i < 3; ++i) {
                    cmd.writeWord(this.encoder_gear_ratio[i]);
                }
                cmd.writeByteArr(this.encoder_types);
                cmd.writeByteArr(this.encoder_cfgs);
                cmd.writeByteArr(p.outerP);
                cmd.writeEmptyArr(3);
                cmd.writeByteSigned(this.magAxisTop);
                cmd.writeByteSigned(this.magAxisRight);
                cmd.writeByte(p.magTrust);
                cmd.writeByteSigned(this.magDeclination);
                cmd.writeWord(p.accLPFFreq);
                for (i = 0; i < 3; ++i) {
                    cmd.writeByte(MathUtils.constrain(p.d_lpfFreq[i] / (BoardInfo.hasExtPIDRange() ? 2 : 10), 0, 255));
                }
            } else if (cmd.id == 63) {
                int i;
                for (i = 0; i < 2; ++i) {
                    cmd.writeByte(this.mavlink_src[i]);
                    cmd.writeByte(this.mavlink_sys_id[i]);
                    cmd.writeByte(this.mavlink_comp_id[i]);
                    cmd.writeWord(this.mavlink_flags[i]);
                    cmd.writeByteArr(this.mavlink_reserved[i]);
                }
                cmd.writeWordArr(this.motor_mag_link);
                cmd.writeByteArr(p.angleAccLimit3);
                for (int axis = 0; axis < 3; ++axis) {
                    int gain = BoardInfo.hasExtPIDRange() ? p.getPIDGainLog(axis) : p.getPIDGainCompressed(axis);
                    cmd.writeByte(gain);
                }
                cmd.writeByte(this.frame_imu_lpf_freq);
                cmd.writeByte(this.auto_pid_cfg);
                cmd.writeByte(this.auto_pid_precision);
                cmd.writeWordArr(this.frame_cam_angle_min);
                cmd.writeWordArr(this.frame_cam_angle_max);
                cmd.writeWord(this.general_flags2);
                cmd.writeByte(this.auto_speed);
                cmd.writeByte(this.auto_acc_limit);
                cmd.writeWordArr(this.orientation_corr);
                cmd.writeWord(p.timelapseTime);
                cmd.writeWord(this.emergencyStopRestartDelay);
                cmd.writeByte(p.timelapseAccPart);
                cmd.writeWordArr(this.momentum);
                cmd.writeByteArr(this.momentum_stimulus);
                cmd.writeByteArr(this.momentum_ellipticity);
                cmd.writeByteArr(p.follow_range);
                cmd.writeByteArr(p.stabAxis);
                cmd.writeByteSigned(this.outer_motor_tilt);
                cmd.writeByteArr(this.startup_action);
                cmd.writeByteArr(this.startup_action_src);
                cmd.writeByteSignedArr(this.startup_action_thr);
                cmd.writeByteArr(this.force_position);
                for (i = 0; i < this.step_signal_cfg.length; ++i) {
                    this.step_signal_cfg[i].writeConfig(cmd);
                }
                for (i = 0; i < 5; ++i) {
                    this.rc_input_calib[i].writeConfig(cmd);
                }
                cmd.writeByte(this.parking_cfg);
                cmd.writeByte(this.ext_led_pin);
                cmd.writeWord(this.interrupt_cfg);
                cmd.writeByte(this.overload_time);
                cmd.writeByte(this.auto_pid_momentum);
                cmd.writeByteArr(p.jerk_slope_ms);
                cmd.writeByte(p.mav_ctrl_mode);
                cmd.writeByte(this.rc_serial_speed);
                cmd.writeByte(this.uart2_speed);
                cmd.writeByteArr(this.motor_res);
                cmd.writeWord(this.current_limit);
                cmd.writeByteSigned(this.middle_motor_tilt);
            } else if (cmd.id == 105) {
                this.motor4.writeConfig(cmd);
                this.extIMU.writeConfig(cmd);
                cmd.writeByteArr(this.limit_width);
                cmd.writeByteArr(p.adc_replace);
                cmd.writeByte(this.improve_mid_mot_pos);
                cmd.writeByteArr(this.extra_btn_cfg);
                cmd.writeByte(this.overcurrent_protection);
                cmd.writeByte(this.power_on_delay);
                cmd.writeByte(this.power_off_delay);
                cmd.writeByte(this.power_on_limiter);
                cmd.write(this.power_control_reserved);
                cmd.writeByteArr(p.lpf_Q_inv);
                cmd.writeByte(this.ext_sens_type);
                cmd.writeWord(p.profile_flags2);
                cmd.writeByteArr(this.reaction_drv_id);
                cmd.writeDWord(this.general_flags3);
                for (int i = 0; i < 3; ++i) {
                    cmd.writeWord(MathUtils.deg_to_angle14(this.followOffset_f[i]));
                }
                cmd.writeWord(this.motor_startup_delay_ms);
                cmd.writeByteArr(this.imu_model);
                cmd.writeByteArr(p.stabThreshold);
                cmd.writeByte(this.ext_buzzer_pin);
                cmd.writeByteSignedArr(this.limit_ret_speed);
                cmd.writeByte(this.tripod_mode_auto_threshold);
                cmd.writeByteArr(p.rcDeadbandSplit);
                cmd.writeByteArr(p.rcExpoRateSplit);
                cmd.writeDWord(p.profile_flags3);
                cmd.writeByteSigned(this.defaultProfile);
                cmd.writeWordArr(this.retracted_angle);
                p.shakeGenerator.writeCmd(cmd);
                cmd.writeByteArr(this.ext_motor_drv_id);
                cmd.writeWordArr(this.encoder_cfg_ext);
                cmd.writeFloat(this.ext_sens_calib_val);
                cmd.write(this.ext_sens_params_reserved);
                cmd.writeWordArr(this.imu_angle_corr);
                cmd.writeByteArr(this.can_imu_servo_out);
                cmd.writeByte(this.can_imu_servo_rate / 10);
                cmd.writeByte(SERVO_OUTER_P_GAIN_LOG_SCALE.to_log_int(p.servo_outerP_gain));
                cmd.writeByte(EXT_PID_LOG_SCALE.to_log_int(p.servo_outerI));
                cmd.writeWord(this.ext_switch_shunt_r);
                cmd.writeDWord(this.general_flags4);
                cmd.writeByte(this.auto_timeout / 100);
                cmd.writeByte(this.control_ff_lpf_freq);
                cmd.writeByteArr(p.reserved_ext3);
            } else {
                int i;
                for (i = 0; i < 3; ++i) {
                    int D;
                    int I;
                    int P;
                    if (BoardInfo.hasExtPIDRange()) {
                        P = EXT_PID_LOG_SCALE.to_log_int(p.P_f[i]);
                        I = EXT_PID_LOG_SCALE.to_log_int(p.I_f[i]);
                        D = EXT_PID_LOG_SCALE.to_log_int(p.D_f[i]);
                    } else {
                        P = Math.round(p.P_f[i]);
                        I = Math.round(p.I_f[i]);
                        D = Math.round(p.D_f[i]);
                    }
                    cmd.writeByte(P);
                    cmd.writeByte(I);
                    cmd.writeByte(D);
                    cmd.writeByte(p.power[i]);
                    cmd.writeBoolean(this.invert[i]);
                    cmd.writeByte(this.poles[i]);
                }
                cmd.writeByte(p.angleAccLimit3[0]);
                for (i = 0; i < 2; ++i) {
                    cmd.writeByteSigned(p.extFCGain[i]);
                }
                for (i = 0; i < 3; ++i) {
                    cmd.writeWord(p.rcMinAngle[i]);
                    cmd.writeWord(p.rcMaxAngle[i]);
                    cmd.writeByte(p.rcMode[i]);
                    cmd.writeByte(p.rcLPF[i]);
                    cmd.writeByte(p.rcSpeed[i]);
                    cmd.writeByteSigned(p.rcFollow[i]);
                }
                cmd.writeByte(p.gyroTrust);
                cmd.writeByte(p.accCompModel);
                cmd.writeByte(p.pwmFreq);
                cmd.writeByte(p.serialSpeed);
                for (i = 0; i < p.rcTrim.length; ++i) {
                    cmd.writeByteSigned(p.rcTrim[i]);
                }
                cmd.writeByte(p.rcDeadband);
                cmd.writeByte(p.rcExpoRate);
                cmd.writeByte(p.rcVirtMode);
                for (i = 0; i < p.rcMap.length; ++i) {
                    cmd.writeByte(p.rcMap[i]);
                }
                for (i = 0; i < p.rcMix.length; ++i) {
                    cmd.writeByte(p.rcMix[i]);
                }
                cmd.writeByte(p.followMode);
                cmd.writeByte(p.followDeadband);
                cmd.writeByte(p.followExpoRate);
                for (i = 0; i < 3; ++i) {
                    cmd.writeByteSigned(MathUtils.constrain(Math.round(this.followOffset_f[i]), -127, 127));
                }
                cmd.writeByteSigned(this.axisTop);
                cmd.writeByteSigned(this.axisRight);
                if (cmd.id != 87) {
                    cmd.writeByteSigned(this.frameAxisTop);
                    cmd.writeByteSigned(this.frameAxisRight);
                    cmd.writeByte(this.frame_imu_pos);
                }
                cmd.writeByte(this.gyroDeadband);
                cmd.writeByte(this.gyroSens);
                cmd.writeByte(this.i2c_fast);
                cmd.writeByte(this.gyro_calib);
                cmd.writeByteArr(this.rcCmd);
                cmd.writeByteArr(this.menuCmd);
                cmd.writeByteArr(p.outputMap);
                cmd.writeWord(this.bat_threshold_alarm);
                cmd.writeWord(this.bat_threshold_motors);
                cmd.writeWord(this.bat_comp_ref);
                cmd.writeByte(this.beeper_modes);
                cmd.writeByte(p.follow_roll_mix_start);
                cmd.writeByte(p.follow_roll_mix_range);
                cmd.writeByteArr(p.boosterPower);
                cmd.writeByteArr(p.followSpeed);
                cmd.writeByte(p.flags4);
                if (cmd.id != 87) {
                    cmd.writeWordArr(p.rcMemory);
                    cmd.writeByteArr(p.servoOut);
                    cmd.writeByte(p.servoRate / 10);
                    cmd.writeByte(p.adaptivePIDEnabled);
                    cmd.writeByte(p.adaptivePIDThreshold);
                    cmd.writeByte(p.adaptivePIDRate);
                    cmd.writeByte(p.adaptivePIDRecoveryFactor);
                    cmd.writeByteArr(p.followLPF);
                    cmd.writeWord(this.general_flags1);
                    cmd.writeWord(p.profile_flags1);
                    cmd.writeByte(p.spektrumMode);
                    cmd.writeByte(this.orderOfAxes);
                    cmd.writeByte(p.eulerOrder);
                    cmd.writeByte(this.curIMU);
                }
                cmd.writeByte(this.curProfile);
            }
            return cmd;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to format command from params: " + e.toString()));
            throw new IOException("Failed to format command from params", e);
        }
    }

    public SerialCommand formatAdjVarsWriteCmd() throws IOException {
        int i;
        logger.info((Object)"Formatting adj.vars configuration..");
        SerialCommand cmd = new SerialCommand(44);
        for (i = 0; i < this.adj_vars_trigger.length; ++i) {
            this.adj_vars_trigger[i].writeCfgCmd(cmd);
        }
        for (i = 0; i < this.adj_vars_analog.length; ++i) {
            this.adj_vars_analog[i].writeCfgCmd(cmd);
        }
        cmd.writeEmptyArr(128 - cmd.len);
        return cmd;
    }

    public BoardParams clone() throws CloneNotSupportedException {
        BoardParams copy = (BoardParams)super.clone();
        copy.profiles = new BoardProfile[this.profiles.length];
        copy.followOffset_f = Arrays.copyOf(this.followOffset_f, this.followOffset_f.length);
        copy.followOffset = Arrays.copyOf(this.followOffset, this.followOffset.length);
        for (int i = 0; i < this.profiles.length; ++i) {
            copy.profiles[i] = this.profiles[i].clone();
        }
        copy.rcCmd = Arrays.copyOf(this.rcCmd, this.rcCmd.length);
        copy.menuCmd = Arrays.copyOf(this.menuCmd, this.menuCmd.length);
        copy.manual_set_time = Arrays.copyOf(this.manual_set_time, this.manual_set_time.length);
        copy.motor_heating_factor = Arrays.copyOf(this.motor_heating_factor, this.motor_heating_factor.length);
        copy.motor_cooling_factor = Arrays.copyOf(this.motor_cooling_factor, this.motor_cooling_factor.length);
        copy.encoder_offset = Arrays.copyOf(this.encoder_offset, this.encoder_offset.length);
        copy.encoder_fld_offset = Arrays.copyOf(this.encoder_fld_offset, this.encoder_fld_offset.length);
        copy.encoder_mag_link = Arrays.copyOf(this.encoder_mag_link, this.encoder_mag_link.length);
        copy.motor_mag_link = Arrays.copyOf(this.motor_mag_link, this.motor_mag_link.length);
        copy.motor_gear = Arrays.copyOf(this.motor_gear, this.motor_gear.length);
        copy.encoder_limit_min = Arrays.copyOf(this.encoder_limit_min, this.encoder_limit_min.length);
        copy.encoder_limit_max = Arrays.copyOf(this.encoder_limit_max, this.encoder_limit_max.length);
        copy.frame_cam_angle_min = Arrays.copyOf(this.frame_cam_angle_min, this.frame_cam_angle_min.length);
        copy.frame_cam_angle_max = Arrays.copyOf(this.frame_cam_angle_max, this.frame_cam_angle_max.length);
        copy.encoder_types = Arrays.copyOf(this.encoder_types, this.encoder_types.length);
        copy.encoder_cfgs = Arrays.copyOf(this.encoder_cfgs, this.encoder_cfgs.length);
        copy.encoder_cfg_ext = Arrays.copyOf(this.encoder_cfg_ext, this.encoder_cfg_ext.length);
        copy.mavlink_src = Arrays.copyOf(this.mavlink_src, this.mavlink_src.length);
        copy.mavlink_sys_id = Arrays.copyOf(this.mavlink_sys_id, this.mavlink_sys_id.length);
        copy.mavlink_comp_id = Arrays.copyOf(this.mavlink_comp_id, this.mavlink_comp_id.length);
        copy.mavlink_flags = Arrays.copyOf(this.mavlink_flags, this.mavlink_flags.length);
        copy.invert = Arrays.copyOf(this.invert, this.invert.length);
        copy.poles = Arrays.copyOf(this.poles, this.poles.length);
        copy.orientation_corr = Arrays.copyOf(this.orientation_corr, 3);
        copy.momentum = Arrays.copyOf(this.momentum, 3);
        copy.momentum_stimulus = Arrays.copyOf(this.momentum_stimulus, 3);
        copy.momentum_ellipticity = Arrays.copyOf(this.momentum_ellipticity, 3);
        copy.startup_action = Arrays.copyOf(this.startup_action, this.startup_action.length);
        copy.startup_action_src = Arrays.copyOf(this.startup_action_src, this.startup_action_src.length);
        copy.startup_action_thr = Arrays.copyOf(this.startup_action, this.startup_action_thr.length);
        copy.force_position = Arrays.copyOf(this.force_position, 3);
        copy.step_signal_cfg = BoardParams.copyOf(this.step_signal_cfg);
        copy.rc_input_calib = BoardParams.copyOf(this.rc_input_calib);
        copy.adj_vars_trigger = BoardParams.copyOf(this.adj_vars_trigger);
        copy.adj_vars_analog = BoardParams.copyOf(this.adj_vars_analog);
        if (this.CAN_device_id_map != null) {
            copy.CAN_device_id_map = new LinkedHashMap<String, CANDeviceScanInfo>(this.CAN_device_id_map);
        }
        if (this.CAN_Drv_soft_params != null) {
            copy.CAN_Drv_soft_params = Arrays.copyOf(this.CAN_Drv_soft_params, this.CAN_Drv_soft_params.length);
        }
        copy.motor_res = Arrays.copyOf(this.motor_res, 3);
        copy.limit_width = Arrays.copyOf(this.limit_width, 3);
        copy.custom_tunes = BoardParams.copyOf(this.custom_tunes);
        copy.extra_btn_cfg = Arrays.copyOf(this.extra_btn_cfg, this.extra_btn_cfg.length);
        if (this.reaction_drv_id != null) {
            copy.reaction_drv_id = Arrays.copyOf(this.reaction_drv_id, this.reaction_drv_id.length);
        }
        if (this.auto_pid_cfg2 != null) {
            copy.auto_pid_cfg2 = this.auto_pid_cfg2.clone();
        }
        if (this.extIMU != null) {
            copy.extIMU = this.extIMU.clone();
        }
        copy.power_control_reserved = Arrays.copyOf(this.power_control_reserved, this.power_control_reserved.length);
        if (this.serial_link_cfg != null) {
            copy.serial_link_cfg = this.serial_link_cfg.clone();
        }
        copy.imu_model = Arrays.copyOf(this.imu_model, this.imu_model.length);
        copy.retracted_angle = Arrays.copyOf(this.retracted_angle, this.retracted_angle.length);
        copy.geometry_cfg = this.geometry_cfg.clone();
        copy.ext_motor_drv_id = Utils.copyArray(this.ext_motor_drv_id);
        copy.imu_angle_corr = Utils.copyArray(this.imu_angle_corr);
        copy.can_imu_servo_out = Utils.copyArray(this.can_imu_servo_out);
        return copy;
    }

    public boolean compare(BoardParams p, int profile) {
        boolean res = this.profiles[profile].equals(p.profiles[profile]);
        res &= this.axisTop == p.axisTop;
        res &= this.axisRight == p.axisRight;
        res &= this.frameAxisTop == p.frameAxisTop;
        res &= this.frameAxisRight == p.frameAxisRight;
        res &= this.magAxisTop == p.magAxisTop;
        res &= this.magAxisRight == p.magAxisRight;
        res &= this.gyroDeadband == p.gyroDeadband;
        res &= this.gyroSens == p.gyroSens;
        res &= this.i2c_fast == p.i2c_fast;
        res &= this.gyro_calib == p.gyro_calib;
        res &= this.frame_imu_pos == p.frame_imu_pos;
        res &= Arrays.equals(this.rcCmd, p.rcCmd);
        res &= Arrays.equals(this.menuCmd, p.menuCmd);
        res &= Arrays.equals(this.followOffset_f, p.followOffset_f);
        res &= this.bat_threshold_alarm == p.bat_threshold_alarm;
        res &= this.bat_threshold_motors == p.bat_threshold_motors;
        res &= this.bat_comp_ref == p.bat_comp_ref;
        res &= this.beeper_modes == p.beeper_modes;
        res &= Arrays.equals(this.manual_set_time, p.manual_set_time);
        res &= Arrays.equals(this.motor_heating_factor, p.motor_heating_factor);
        res &= Arrays.equals(this.motor_cooling_factor, p.motor_cooling_factor);
        res &= Arrays.equals(this.encoder_offset, p.encoder_offset);
        res &= Arrays.equals(this.encoder_fld_offset, p.encoder_fld_offset);
        res &= Arrays.equals(this.encoder_types, p.encoder_types);
        res &= Arrays.equals(this.encoder_cfgs, p.encoder_cfgs);
        res &= Arrays.equals(this.encoder_cfg_ext, p.encoder_cfg_ext);
        res &= Arrays.equals(this.encoder_mag_link, p.encoder_mag_link);
        res &= Arrays.equals(this.motor_mag_link, p.motor_mag_link);
        res &= Arrays.equals(this.adj_vars_trigger, p.adj_vars_trigger);
        res &= Arrays.equals(this.adj_vars_analog, p.adj_vars_analog);
        res &= Arrays.equals(this.motor_gear, p.motor_gear);
        res &= Arrays.equals(this.frame_cam_angle_min, p.frame_cam_angle_min);
        res &= Arrays.equals(this.frame_cam_angle_max, p.frame_cam_angle_max);
        res &= this.beeper_volume == p.beeper_volume;
        res &= this.magDeclination == p.magDeclination;
        res &= this.orderOfAxes == p.orderOfAxes;
        res &= Arrays.equals(this.mavlink_src, p.mavlink_src);
        res &= Arrays.equals(this.mavlink_sys_id, p.mavlink_sys_id);
        res &= Arrays.equals(this.mavlink_comp_id, p.mavlink_comp_id);
        res &= Arrays.equals(this.mavlink_flags, p.mavlink_flags);
        res &= this.frame_imu_lpf_freq == p.frame_imu_lpf_freq;
        res &= this.auto_pid_cfg == p.auto_pid_cfg;
        res &= this.auto_pid_precision == p.auto_pid_precision;
        res &= this.auto_pid_momentum == p.auto_pid_momentum;
        res &= Arrays.equals(this.invert, p.invert);
        res &= Arrays.equals(this.poles, p.poles);
        res &= this.general_flags1 == p.general_flags1;
        res &= this.general_flags2 == p.general_flags2;
        res &= this.auto_speed == p.auto_speed;
        res &= this.auto_acc_limit == p.auto_acc_limit;
        res &= this.emergencyStopRestartDelay == p.emergencyStopRestartDelay;
        res &= Arrays.equals(this.orientation_corr, p.orientation_corr);
        res &= Arrays.equals(this.momentum, p.momentum);
        res &= Arrays.equals(this.momentum_stimulus, p.momentum_stimulus);
        res &= Arrays.equals(this.momentum_ellipticity, p.momentum_ellipticity);
        res &= this.outer_motor_tilt == p.outer_motor_tilt;
        res &= this.middle_motor_tilt == p.middle_motor_tilt;
        res &= Arrays.equals(this.startup_action_src, p.startup_action_src);
        res &= Arrays.equals(this.startup_action_thr, p.startup_action_thr);
        res &= Arrays.equals(this.startup_action, p.startup_action);
        res &= this.CAN_device_id_map == null && p.CAN_device_id_map == null || this.CAN_device_id_map.equals(p.CAN_device_id_map);
        res &= Arrays.equals(this.CAN_Drv_soft_params, p.CAN_Drv_soft_params);
        res &= Arrays.equals(this.force_position, p.force_position);
        res &= Arrays.equals(this.step_signal_cfg, p.step_signal_cfg);
        res &= Arrays.equals(this.rc_input_calib, p.rc_input_calib);
        res &= this.parking_cfg == p.parking_cfg;
        res &= this.ext_led_pin == p.ext_led_pin;
        res &= this.ext_buzzer_pin == p.ext_buzzer_pin;
        res &= this.interrupt_cfg == p.interrupt_cfg;
        res &= this.overload_time == p.overload_time;
        res &= this.rc_serial_speed == p.rc_serial_speed;
        res &= this.uart2_speed == p.uart2_speed;
        res &= Arrays.equals(this.motor_res, p.motor_res);
        res &= this.current_limit == p.current_limit;
        res &= this.motor4.equals(p.motor4);
        res &= this.extIMU.equals(p.extIMU);
        res &= Arrays.equals(this.limit_width, p.limit_width);
        res &= Arrays.equals(this.custom_tunes, p.custom_tunes);
        res &= this.improve_mid_mot_pos == p.improve_mid_mot_pos;
        res &= Arrays.equals(this.extra_btn_cfg, p.extra_btn_cfg);
        res &= Arrays.equals(this.reaction_drv_id, p.reaction_drv_id);
        res &= this.overcurrent_protection == p.overcurrent_protection;
        res &= this.power_on_delay == p.power_on_delay;
        res &= this.power_off_delay == p.power_off_delay;
        res &= this.power_on_limiter == p.power_on_limiter;
        res &= Arrays.equals(this.power_control_reserved, p.power_control_reserved);
        res &= this.ext_sens_type == p.ext_sens_type;
        res &= this.general_flags3 == p.general_flags3;
        res &= this.serial_link_cfg != null && this.serial_link_cfg.equals(p.serial_link_cfg) || this.serial_link_cfg == null && p.serial_link_cfg == null;
        res &= Arrays.equals(this.imu_model, p.imu_model);
        res &= Arrays.equals(this.retracted_angle, p.retracted_angle);
        res &= this.geometry_cfg.equals(p.geometry_cfg);
        res &= Arrays.equals(this.ext_motor_drv_id, p.ext_motor_drv_id);
        res &= Arrays.equals(this.imu_angle_corr, p.imu_angle_corr);
        res &= Arrays.equals(this.can_imu_servo_out, p.can_imu_servo_out);
        res &= this.ext_switch_shunt_r == p.ext_switch_shunt_r;
        res &= this.general_flags4 == p.general_flags4;
        res &= this.auto_timeout == p.auto_timeout;
        return res &= this.control_ff_lpf_freq == p.control_ff_lpf_freq;
    }

    public static int axisMapToIndex(int val) {
        return val > 0 ? Math.min(val - 1, 2) : Math.min(2 - val, 5);
    }

    public static int axisIndexToMap(int index) {
        return index > 2 ? 2 - index : index + 1;
    }

    public static String axisMapToString(int val) {
        return val != 0 ? axisMapNames[BoardParams.axisMapToIndex(val)] : "?";
    }

    public static boolean encoder_has_cfg(int type) {
        return Arrays.binarySearch(ENC_EXTRA_CFG, type) >= 0;
    }

    public static boolean is_encoder_i2c_drv(int type) {
        return type >= 8 && type <= 11;
    }

    public static boolean is_encoder_supported_by_main_ctrl(int type) {
        boolean res = false;
        if (type == -1 || type == 0) {
            res = true;
        } else if (BoardInfo.hasBoardFeature(4L)) {
            boolean bl = res = BoardInfo.checkMinBaseFirmwareVer(2672) && type <= 34 || BoardInfo.checkMinBaseFirmwareVer(2612) && type <= 13 || BoardInfo.checkMinBaseFirmwareVer(2616) && type <= 15 || BoardInfo.checkMinBaseFirmwareVer(2672) && type <= 34 || BoardInfo.checkMinBaseFirmwareVer(2680) && type <= 35 || BoardInfo.checkMinBaseFirmwareVer(2681) && type <= 36 || BoardInfo.checkMinBaseFirmwareVer(2682) && type <= 38 || BoardInfo.checkMinBaseFirmwareVer(2685) && type <= 40 || BoardInfo.checkMinBaseFirmwareVer(2692) && type <= 42 || BoardInfo.checkMinBaseFirmwareVer(2701) && type <= 44 || BoardInfo.checkMinBaseFirmwareVer(2703) && type <= 46 || BoardInfo.checkMinBaseFirmwareVer(2707) && type <= 47 || BoardInfo.checkMinBaseFirmwareVer(2730) && type <= 64 || type == 65 && BoardInfo.hasBoardFeature(0x10000000000L);
            if (!BoardInfo.hasBoardFeature(32768L) && Arrays.binarySearch(ENC_EXTENDED_FAMILY, type) >= 0) {
                res = false;
            }
        } else if (BoardInfo.hasYawEncoder()) {
            res = BoardInfo.checkMinBaseFirmwareVer(2588) ? type == 7 || type == 2 || type == 3 || type == 5 || type == 6 || type == 12 || type == 13 || BoardInfo.checkMinBaseFirmwareVer(2612) && type == 15 || BoardInfo.checkMinBaseFirmwareVer(2672) && type == 34 || BoardInfo.checkMinBaseFirmwareVer(2681) && type == 36 || BoardInfo.checkMinBaseFirmwareVer(2682) && type == 38 || BoardInfo.checkMinBaseFirmwareVer(2685) && type == 40 || BoardInfo.checkMinBaseFirmwareVer(2707) && type == 47 : type == 7;
        }
        return res;
    }

    public void setProfileName(int profileId, String name) {
        if (profileId >= 0 && profileId < this.profiles.length) {
            this.profiles[profileId].profileName = name;
        }
    }

    public static int updateBit(int var, int bitMask, boolean state) {
        return var & ~bitMask | (state ? bitMask : 0);
    }

    public static long updateBitL(long var, long bitMask, boolean state) {
        return var & (bitMask ^ 0xFFFFFFFFFFFFFFFFL) | (state ? bitMask : 0L);
    }

    public void onFirmwareVersionChange(int old_ver, int cur_ver) {
        logger.info((Object)("Loaded profile is for old firmware ver=" + old_ver));
        for (int axis = 0; axis < 3; ++axis) {
            if (old_ver < 2587) {
                this.motor_mag_link[axis] = this.encoder_mag_link[axis] * 100;
            }
            if (old_ver < 2591) {
                this.general_flags1 |= 0x40;
                this.frame_imu_lpf_freq = 10;
            }
            if (old_ver >= 2610) continue;
            this.frame_cam_angle_min[axis] = this.encoder_limit_min[axis] * 3;
            this.frame_cam_angle_max[axis] = this.encoder_limit_max[axis] * 3;
        }
        if (old_ver < 2664) {
            for (int i = 0; i < 2; ++i) {
                if (this.mavlink_src[i] == 0) continue;
                this.extIMU.type = 1 + i;
                this.extIMU.orientation = 5;
                if ((this.general_flags2 & 0x40) > 0) {
                    if ((this.general_flags2 & 0x200) > 0) {
                        this.extIMU.position = 9;
                        continue;
                    }
                    this.extIMU.position = 1;
                    continue;
                }
                this.extIMU.position = (this.general_flags2 & 0x200) > 0 ? 8 : 2;
            }
        }
        if (old_ver < 2720) {
            this.general_flags3 |= 0x8000;
            this.tripod_mode_auto_threshold = 20;
        }
    }

    public void onAppVersionChange(int old_ver) {
        logger.info((Object)("Loaded profile is for old GUI ver=" + old_ver));
        BoardInfo boardInfo = BoardInfo.getBoardInfo();
        BoardProfile cur_p = null;
        if (this.profiles != null && this.curProfile >= 0 && this.curProfile < this.profiles.length) {
            cur_p = this.profiles[this.curProfile];
        }
        if (old_ver < 2598 && boardInfo != null && (boardInfo.boardVer == 30 || boardInfo.boardVer == 31) && boardInfo._hasBoardFeature(4L)) {
            this.general_flags1 |= 0x200;
        }
        if (old_ver < 2602 && cur_p != null) {
            this.poles = Arrays.copyOf(cur_p.poles_deprecated, cur_p.poles_deprecated.length);
            this.invert = Arrays.copyOf(cur_p.invert_deprecated, cur_p.invert_deprecated.length);
        }
        if (old_ver < 2610) {
            for (int axis = 0; axis < 3; ++axis) {
                this.frame_cam_angle_min[axis] = this.encoder_limit_min[axis] * 3;
                this.frame_cam_angle_max[axis] = this.encoder_limit_max[axis] * 3;
            }
        }
        if (old_ver < 2700) {
            for (int i = 0; i < 3; ++i) {
                this.followOffset_f[i] = this.followOffset[i];
            }
        }
        if (old_ver < 2732 && this.CAN_device_id_map != null) {
            LinkedHashMap<String, CANDeviceScanInfo> tmp = new LinkedHashMap<String, CANDeviceScanInfo>(this.CAN_device_id_map.size());
            for (Map.Entry<String, CANDeviceScanInfo> entry : this.CAN_device_id_map.entrySet()) {
                CANDeviceScanInfo val = entry.getValue();
                if (val.getClass() == Integer.class) {
                    tmp.put(entry.getKey(), new CANDeviceScanInfo((Integer)((Object)val)));
                    continue;
                }
                if (val.getClass() == CANDeviceScanInfo.class) {
                    tmp.put(entry.getKey(), entry.getValue());
                    continue;
                }
                logger.error((Object)("Unknown class for CAN_device_id_map entry: " + val.getClass().getName() + ", should be CANDeviceScanInfo"));
            }
            this.CAN_device_id_map = tmp;
        }
        if (this.CAN_Drv_soft_params != null) {
            for (CanDrvSoftParams p : this.CAN_Drv_soft_params) {
                p.onAppVersionChange(old_ver);
            }
        }
    }

    public void onProfileFileLoaded(int firmwareVer, int appVer) {
    }

    public static <T> T[] copyOf(T[] list) {
        if (list != null) {
            return Arrays.copyOf(list, list.length);
        }
        return null;
    }

    public static void mult_arr(int[] arr, int mult) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * mult;
        }
    }

    public static boolean isOutputCANDrv(int axis) {
        return BoardParams.isOutputCANDrv(axis, -1);
    }

    public static boolean isOutputCANDrv(int axis, int drvId) {
        BoardProfile p = BoardParams.getCurProfile();
        return p != null && p.outputMap[axis] >= 8 && p.outputMap[axis] <= 14 && (drvId < 0 || drvId == p.outputMap[axis] - 8);
    }

    public void onBeforeSaveFile() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.followOffset[i] = MathUtils.constrain(Math.round(this.followOffset_f[i]), -127, 127);
        }
        if (this.profiles != null) {
            for (BoardProfile p : this.profiles) {
                p.onBeforeSaveFile();
            }
        }
    }

    public static boolean isLoaded() {
        return curParams != null && BoardParams.curParams.loadedFrom != LoadedFrom.NO;
    }

    public String getPortFunction(int port) {
        if (port < 1 || port > 4) {
            return null;
        }
        BoardProfile p = this.profiles[this.curProfile];
        String func = port == 2 ? (p.rcVirtMode == 10 ? PORT_FUNC_SERIAL_API : (p.rcVirtMode == 2 ? PORT_FUNC_SBUS : (p.rcVirtMode == 3 ? PORT_FUNC_SPEKTRUM : (p.rcVirtMode == 4 ? PORT_FUNC_EX_BUS : PORT_FUNC_DISABLED)))) : (port == 3 ? ((this.general_flags1 & 0x400) == 0 ? PORT_FUNC_DISABLED : PORT_FUNC_SERIAL_API) : (port == 4 ? ((this.general_flags1 & 0x4000) == 0 ? PORT_FUNC_DISABLED : PORT_FUNC_SERIAL_API) : PORT_FUNC_SERIAL_API));
        if (func == PORT_FUNC_SERIAL_API) {
            if (this.mavlink_src[0] == port || this.mavlink_src[1] == port) {
                func = PORT_FUNC_MAVLINK;
            } else if (this.extIMU != null && this.extIMU.port == port && this.extIMU.type >= 3) {
                func = PORT_FUNC_EXT_IMU;
            }
        }
        return func;
    }

    public ArrayList<String> getLocalSerialPortInfo(SerialLinkCfg serial_link_cfg) {
        ArrayList<String> info = new ArrayList<String>();
        for (Sprav s : BoardInfo.getSerialPortList()) {
            ArrayList<String> portInfo;
            int port = s.getId();
            String func = this.getPortFunction(port);
            if (func == PORT_FUNC_SERIAL_API && serial_link_cfg != null && (portInfo = serial_link_cfg.getRouteInfo(1, SerialLinkCfg.sbgc32PortToPortNum(port))).size() > 0) {
                info.addAll(portInfo);
                continue;
            }
            info.add(BoardInfo.getSerialPortName(port) + " - " + func);
        }
        return info;
    }

    public static String getEncoderName(Integer id) {
        String name = ENC_TYPE_NAMES.get(id);
        if (name == null) {
            name = CAN_DRV_ENC_TYPE_NAMES.get(id);
        }
        if (name == null) {
            name = "<unknown id=" + id + ">";
        }
        return name;
    }

    public static boolean is_imu_model_CAN_IMU(int model) {
        return model == 0 || model >= 3 && model <= 6;
    }

    public void beforeApply() {
        if (this.CAN_Drv_soft_params != null) {
            for (int i = 0; i < this.CAN_Drv_soft_params.length; ++i) {
                this.CAN_Drv_soft_params[i].clearAssignment();
            }
        }
    }

    public boolean isPID_V3() {
        return (this.general_flags4 & 0x10) != 0;
    }

    public int getPIDControllerVer() {
        if (this.isPID_V3()) {
            return 4;
        }
        if (BoardInfo.hasExtPIDRange()) {
            return BoardInfo.checkMinBaseFirmwareVer(2741) ? 3 : 2;
        }
        return 1;
    }

    static {
        ENC_TYPE_NAMES.put(0, "DISABLED");
        ENC_TYPE_NAMES.put(1, "AS5048A (SPI)");
        ENC_TYPE_NAMES.put(2, "AS5048B (I2C)");
        ENC_TYPE_NAMES.put(3, "AS5048A,B (PWM)");
        ENC_TYPE_NAMES.put(4, "AMT203 (SPI)");
        ENC_TYPE_NAMES.put(5, "MA3 (10bit PWM 1kHz)");
        ENC_TYPE_NAMES.put(6, "MA3 (12bit PWM 244Hz)");
        ENC_TYPE_NAMES.put(7, "Analog");
        ENC_TYPE_NAMES.put(8, "SBGC32_I2C_drv#1");
        ENC_TYPE_NAMES.put(9, "SBGC32_I2C_drv#2");
        ENC_TYPE_NAMES.put(10, "SBGC32_I2C_drv#3");
        ENC_TYPE_NAMES.put(11, "SBGC32_I2C_drv#4");
        ENC_TYPE_NAMES.put(12, "AS5600 (PWM 460Hz)");
        ENC_TYPE_NAMES.put(13, "AS5600 (I2C)");
        ENC_TYPE_NAMES.put(47, "AS5600L (I2C)");
        ENC_TYPE_NAMES.put(14, "RLS Orbis (SPI)");
        ENC_TYPE_NAMES.put(15, "RLS Orbis (PWM D 549Hz)");
        ENC_TYPE_NAMES.put(32, "Zettlex IncOder (SPI)");
        ENC_TYPE_NAMES.put(34, "RLS AM4096 (I2C)");
        ENC_TYPE_NAMES.put(35, "TLE5012B (SPI)");
        ENC_TYPE_NAMES.put(36, "TLE5012B (PWM E5000)");
        ENC_TYPE_NAMES.put(37, "A1335 (SPI)");
        ENC_TYPE_NAMES.put(38, "A1335 (I2C)");
        ENC_TYPE_NAMES.put(39, "MA730 (SPI)");
        ENC_TYPE_NAMES.put(40, "MA730 (PWM)");
        ENC_TYPE_NAMES.put(42, "iC-MU (SPI)");
        ENC_TYPE_NAMES.put(43, "RLS Aksim-2");
        ENC_TYPE_NAMES.put(44, "AMT222/223");
        ENC_TYPE_NAMES.put(46, "Netzer (Biss-C)");
        ENC_TYPE_NAMES.put(64, "Biss-C general");
        ENC_TYPE_NAMES.put(65, "Dual-IMU Encoder");
        CAN_DRV_ENC_TYPE_NAMES.put(0, "DISABLED");
        CAN_DRV_ENC_TYPE_NAMES.put(1, "AS5048A (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(2, "AS5048B (I2C, 0x40)");
        CAN_DRV_ENC_TYPE_NAMES.put(3, "AS5048A,B (PWM)");
        CAN_DRV_ENC_TYPE_NAMES.put(4, "AMT203 (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(5, "MA3 (10bit PWM 1kHz)");
        CAN_DRV_ENC_TYPE_NAMES.put(6, "MA3 (12bit PWM 244Hz)");
        CAN_DRV_ENC_TYPE_NAMES.put(12, "AS5600 (PWM 460Hz)");
        CAN_DRV_ENC_TYPE_NAMES.put(13, "AS5600 (I2C)");
        CAN_DRV_ENC_TYPE_NAMES.put(14, "RLS Orbis (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(15, "RLS Orbis (PWM D 549Hz)");
        CAN_DRV_ENC_TYPE_NAMES.put(32, "Zettlex IncOder (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(34, "RLS AM4096 (I2C)");
        CAN_DRV_ENC_TYPE_NAMES.put(35, "TLE5012B (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(36, "TLE5012B (PWM E5000)");
        CAN_DRV_ENC_TYPE_NAMES.put(37, "A1335 (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(38, "A1335 (I2C)");
        CAN_DRV_ENC_TYPE_NAMES.put(39, "MA730 (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(40, "MA730 (PWM)");
        CAN_DRV_ENC_TYPE_NAMES.put(41, "AEAT-8800-Q24 (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(42, "iC-MU (SPI)");
        CAN_DRV_ENC_TYPE_NAMES.put(43, "RLS Aksim-2");
        CAN_DRV_ENC_TYPE_NAMES.put(44, "AMT222/223");
        CAN_DRV_ENC_TYPE_NAMES.put(46, "Netzer (Biss-C)");
        CAN_DRV_ENC_TYPE_NAMES.put(64, "Biss-C general");
        ENCODER_I2C_ADDRESS_RANGE.put(34, new Integer[]{48, 49, 50, 51, 52, 53, 54});
        ENCODER_I2C_ADDRESS_RANGE.put(13, new Integer[]{54});
        ENCODER_I2C_ADDRESS_RANGE.put(47, new Integer[]{67, 68, 69, 70, 71, 72, 73});
        ENC_TYPE_AKSIM2_TYPES = new String[]{"SPI", "Biss-C"};
        ENC_SUB_TYPE_NAMES = new String[]{"DISABLED", "AS5048A", "AS5048B", "AMT203", "MA3 (10bit 1kHz)", "MA3 (12bit 244Hz)", "Analog", "AS5600 (I2C)", "AS5050A (SPI)", "AS5055A (SPI)", "RLS Orbis (SPI)", "MA730 (SPI)", "AM4096 (I2C)"};
        RC_VIRT_CH_MOTOR_ANGLE_NAMES = new String[]{"COS_INNER_MOTOR", "ABS_COS_INNER_MOTOR", "SIN_INNER_MOTOR", "ABS_SIN_INNER_MOTOR", "COS_MIDDLE_MOTOR", "ABS_COS_MIDDLE_MOTOR", "SIN_MIDDLE_MOTOR", "ABS_SIN_MIDDLE_MOTOR", "COS_OUTER_MOTOR", "ABS_COS_OUTER_MOTOR", "SIN_OUTER_MOTOR", "ABS_SIN_OUTER_MOTOR"};
        RC_VIRT2_CH_NAMES = new String[]{"INNER_MOTOR_ANGLE", "MIDDLE_MOTOR_ANGLE", "OUTER_MOTOR_ANGLE"};
        AUX_PIN_ID = new int[]{16, 17, 18};
        curParams = new BoardParams();
        EXT_PID_LOG_SCALE = new LogScale(255.0f, 0.0f, 255.0f, 5.0f);
        SERVO_OUTER_P_GAIN_LOG_SCALE = new LogScale(255.0f, 0.1f, 50.0f, 0.0f);
        axisMapNames = new String[]{"X", "Y", "Z", "-X", "-Y", "-Z"};
    }

    public static enum LoadedFrom {
        NO,
        BOARD,
        BOARD_INCOMPLETE,
        FILE;

    }
}

