/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Arrays;
import sbgc.object.BoardParams;
import sbgc.object.ShakeGeneratorCfg;
import sbgc.utils.LogScale;
import sbgc.utils.MathUtils;

@XStreamAlias(value="profile")
public class BoardProfile
implements Cloneable {
    public static final int RC_MODE_MASK = 7;
    public static final int RC_INVERSE_MASK = 8;
    public static final int RC_PROTECT_INIT_ANGLE_FLAG = 16;
    public static final int RC_MODE_ANGLE_OFFSET_FLAG = 32;
    public static final int RC_MODE_ANGLE = 0;
    public static final int RC_MODE_SPEED = 1;
    public static final int RC_MODE_ANGLE_AUTO_SPEED = 2;
    public static final int PWM_FREQ_LOW = 0;
    public static final int PWM_FREQ_HIGH = 1;
    public static final int FOLLOW_MODE_DISABLED = 0;
    public static final int FOLLOW_MODE_FC = 1;
    public static final int FOLLOW_MODE_PITCH = 2;
    public static final int FLAG1_ADC1_AUTO_DETECTION = 1;
    public static final int FLAG1_ADC2_AUTO_DETECTION = 2;
    public static final int FLAG1_ADC3_AUTO_DETECTION = 4;
    public static final int FLAG1_MENU_BUTTON_FORCE_FOLLOW = 8;
    public static final int FLAG1_FOLLOW_FRAME_IMU = 16;
    public static final int FLAG1_BRIEFCASE_AUTO = 32;
    public static final int FLAG1_UPSIDE_DOWN_AUTO_ROTATE = 64;
    public static final int FLAG1_FOLLOW_LOCK_OFFSET = 128;
    public static final int FLAG1_START_NEUTRAL_POSITION = 256;
    public static final int FLAG1_MENU_BUTTON_DISABLE_FOLLOW = 512;
    public static final int FLAG1_TIMELAPSE_FRAME_FIXED = 1024;
    public static final int FLAG1_RC_KEEP_MIX_RATE = 2048;
    public static final int FLAG1_RC_KEEP_CUR_POS_ON_INIT = 4096;
    public static final int FLAG1_OUTER_MOTOR_LIMIT_FREE_ROTATION = 8192;
    public static final int FLAG1_EULER_LOCK_FREEZE = 16384;
    public static final int FLAG1_CAM_UPSIDE_DOWN_WORKING = 32768;
    public static final int FLAG2_FOLLOW_PITCH_DISABLED = 1;
    public static final int FLAG2_LOW_ANGLE_PRIOR_ROLL = 2;
    public static final int FLAG2_LOW_ANGLE_PRIOR_PITCH = 4;
    public static final int FLAG2_LOW_ANGLE_PRIOR_YAW = 8;
    public static final int FLAG2_HEADING_CORR_TRIPOD_MODE = 16;
    public static final int FLAG2_MOT_ROLL_DISABLE = 32;
    public static final int FLAG2_MOT_PITCH_DISABLE = 64;
    public static final int FLAG2_MOT_YAW_DISABLE = 128;
    public static final int FLAG2_RC_OUT_DUTY1 = 256;
    public static final int FLAG2_RC_OUT_DUTY2 = 512;
    public static final int FLAG2_RC_OUT_DUTY3 = 1024;
    public static final int FLAG2_RC_OUT_DUTY4 = 2048;
    public static final int FLAG2_DISABLE_FOLLOW_STATUP = 4096;
    public static final int FLAG2_SERVO_MODE = 8192;
    public static final int FLAG2_RC_EXPO_DEADBAND_SPLIT = 16384;
    public static final int FLAG2_SERVO_MODE_ENCODERS = 32768;
    public static final long FLAG3_ACC_LIMIT_AUTO_R = 1L;
    public static final long FLAG3_ACC_LIMIT_AUTO_P = 2L;
    public static final long FLAG3_ACC_LIMIT_AUTO_Y = 4L;
    public static final long FLAG3_SHAKE_GENERATOR_ENABLE = 8L;
    public static final long FLAG3_ERR_CORR_LONG_R = 16L;
    public static final long FLAG3_ERR_CORR_LONG_Y = 64L;
    public static final int FLAG4_MOT_ANGLE_FROM_EL_FLD = 1;
    public static final int STAB_AXIS_MASK = 3;
    public static final int STAB_AXIS_ROLL_BIT = 4;
    public static final int STAB_AXIS_PITCH_BIT = 8;
    public static final int STAB_AXIS_YAW_BIT = 16;
    public static final int STAB_AXIS_SWITCH_RUNTIME = 32;
    public static final int STAB_AXIS_RESET_TARGET_ON_CHANGE = 64;
    public static final int MAV_CTRL_MODE_DISABLED = 0;
    public static final int MAV_CTRL_MODE_ROLL_PITCH = 1;
    public static final int MAV_CTRL_MODE_ALL = 2;
    public static final float PID_GAIN_MIN = 0.12f;
    public static final float PID_GAIN_STEP = 0.02f;
    public static final float PID_GAIN_MAX = 5.2f;
    public static final float LPF_Q_INV_MIN = 0.2f;
    public static final float LPF_Q_INV_MAX = 5.2999997f;
    public static final float LPF_Q_INV_DEFAULT = 1.4142f;
    public static final float EXT_PID_RANGE_MAX = 255.0f;
    public static final float EXT_PID_RANGE_OFFSET = 5.0f;
    public static final float EXT_PID_GAIN_MIN = 0.02f;
    public static final float EXT_PID_GAIN_MAX = 50.0f;
    public static final float SERVO_OUTER_P_GAIN_MIN = 0.1f;
    public static final float SERVO_OUTER_P_GAIN_MAX = 50.0f;
    public static final int EULER_ORDER_LOCAL_BIT = 2;
    public static final int EULER_ORDER_MASK = 7;
    public static final int EULER_ORDER_STAB_AXES_MASK = 24;
    @XStreamOmitField
    public String profileName = null;
    public int[] P = new int[]{0, 0, 0};
    public int[] I = new int[]{0, 0, 0};
    public int[] D = new int[]{0, 0, 0};
    public float[] P_f = new float[]{0.0f, 0.0f, 0.0f};
    public float[] I_f = new float[]{0.0f, 0.0f, 0.0f};
    public float[] D_f = new float[]{0.0f, 0.0f, 0.0f};
    public int[] pid_gain = new int[]{0, 0, 0};
    public float[] pid_gain_f = new float[]{0.0f, 0.0f, 0.0f};
    public int angleAccLimit = 0;
    public int[] angleAccLimit3 = new int[]{0, 0, 0};
    public int[] power = new int[]{0, 0, 0};
    public int[] boosterPower = new int[]{0, 0, 0};
    @XStreamAlias(value="invert")
    public boolean[] invert_deprecated = new boolean[]{false, false, false};
    @XStreamAlias(value="poles")
    public int[] poles_deprecated = new int[]{0, 0, 0};
    public int[] extFCGain = new int[]{0, 0};
    public int[] rcMinAngle = new int[]{0, 0, 0};
    public int[] rcMaxAngle = new int[]{0, 0, 0};
    public int[] rcMode = new int[]{0, 0, 0};
    public int[] rcLPF = new int[]{0, 0, 0};
    public int[] rcSpeed = new int[]{0, 0, 0};
    public int[] rcFollow = new int[]{0, 0, 0};
    public boolean[] rcInverse = new boolean[]{false, false, false};
    public int gyroTrust = 0;
    public int accLPFFreq = 0;
    public int accCompModel = 0;
    public int pwmFreq = 0;
    public int serialSpeed = 0;
    public int[] rcTrim = new int[]{0, 0, 0};
    public int rcDeadband = 10;
    public int[] rcDeadbandSplit = new int[]{0, 0};
    public int rcExpoRate = 0;
    public int[] rcExpoRateSplit = new int[]{0, 0};
    public int spektrumMode = 0;
    public int rcVirtMode = 0;
    public int[] rcMap = new int[]{0, 0, 0, 0, 0, 0};
    public int[] rcMix = new int[]{0, 0};
    public int followMode = 0;
    public int followDeadband = 50;
    public int followExpoRate = 0;
    public int follow_roll_mix_start = 0;
    public int follow_roll_mix_range = 0;
    public int[] followSpeed = new int[]{0, 0, 0};
    public int[] followLPF = new int[]{0, 0, 0};
    public int followInsideDeadband = 0;
    public int flags4 = 0;
    public int[] notchFreq1 = new int[]{0, 0, 0};
    public int[] notchFreq2 = new int[]{0, 0, 0};
    public int[] notchFreq3 = new int[]{0, 0, 0};
    public int[] notchWidth1 = new int[]{0, 0, 0};
    public int[] notchWidth2 = new int[]{0, 0, 0};
    public int[] notchWidth3 = new int[]{0, 0, 0};
    public int[] notchGain1 = new int[]{100, 100, 100};
    public int[] notchGain2 = new int[]{100, 100, 100};
    public int[] notchGain3 = new int[]{100, 100, 100};
    public boolean[] notchEnabled1 = new boolean[]{false, false, false};
    public boolean[] notchEnabled2 = new boolean[]{false, false, false};
    public boolean[] notchEnabled3 = new boolean[]{false, false, false};
    public int[] lpfFreq = new int[]{0, 0, 0};
    public int[] lpf_Q_inv = new int[]{0, 0, 0};
    public boolean[] lpfEnabled = new boolean[]{false, false, false};
    public boolean[] lpf1 = new boolean[]{false, false, false};
    public int[] d_lpfFreq = new int[]{0, 0, 0};
    public int adaptivePIDEnabled = 0;
    public int adaptivePIDThreshold = 0;
    public int adaptivePIDRate = 0;
    public int adaptivePIDRecoveryFactor = 0;
    public int[] servoOut = new int[]{0, 0, 0, 0};
    public int servoRate = 0;
    public int profile_flags1 = 0;
    public int profile_flags2 = 0;
    public long profile_flags3 = 0L;
    public int[] outerP = new int[]{100, 100, 100};
    public int[] outputMap = new int[]{0, 0, 0};
    public int magTrust = 0;
    public int[] reserved_ext3 = new int[47];
    public int eulerOrder = 0;
    public int[] rcMemory = new int[]{0, 0, 0};
    public int timelapseTime = 0;
    public int timelapseAccPart = 0;
    public int[] follow_range = new int[]{0, 0, 0};
    public int[] stabAxis = new int[]{0, 0, 0};
    public int[] jerk_slope_ms = new int[]{0, 0, 0};
    public int mav_ctrl_mode;
    public int[] adc_replace = new int[]{0, 0, 0};
    public int[] stabThreshold = new int[]{0, 0, 0};
    public ShakeGeneratorCfg shakeGenerator = new ShakeGeneratorCfg();
    public float servo_outerP_gain;
    public float servo_outerI;

    public void setPIDGain(int axis, float gain) {
        this.pid_gain_f[axis] = gain;
        this.pid_gain[axis] = Math.min(255, Math.max(0, Math.round((gain - 0.1f) / 0.02f)));
    }

    public void setPIDGainCompressed(int axis, int gain) {
        this.pid_gain[axis] = gain;
        this.pid_gain_f[axis] = BoardProfile.PIDGainUncompressed(gain);
    }

    public int getPIDGainCompressed(int axis) {
        return this.pid_gain[axis];
    }

    public void setPIDGainLog(int axis, int gain) {
        if (gain > 0) {
            this.setPIDGain(axis, LogScale.param_log_to_linear(gain - 1, 254, 0.02f, 50.0f, 0.0f));
        } else {
            this.setPIDGain(axis, 1.0f);
        }
    }

    public int getPIDGainLog(int axis) {
        return LogScale.param_linear_to_log(this.getPIDGain(axis), 254, 0.02f, 50.0f, 0.0f) + 1;
    }

    public static float PIDGainUncompressed(int gain) {
        return gain > 0 ? (float)gain * 0.02f + 0.1f : 1.0f;
    }

    public float getPIDGain(int axis) {
        if (this.pid_gain_f[axis] != 0.0f) {
            return this.pid_gain_f[axis];
        }
        return BoardProfile.PIDGainUncompressed(this.pid_gain[axis]);
    }

    public void set_LPF_Q_inv(int axis, float Q_inv) {
        this.lpf_Q_inv[axis] = Math.min(255, Math.max(0, Math.round((Q_inv - 0.2f) * 255.0f / 5.1f)));
    }

    public float get_LPF_Q_inv(int axis) {
        return (float)this.lpf_Q_inv[axis] * 5.1f / 255.0f + 0.2f;
    }

    public int getNotchFreq(int axis, int idx) {
        return idx == 2 ? this.notchFreq3[axis] : (idx == 1 ? this.notchFreq2[axis] : this.notchFreq1[axis]);
    }

    public void setNotchFreq(int axis, int idx, int val) {
        if (idx == 2) {
            this.notchFreq3[axis] = val;
        } else if (idx == 1) {
            this.notchFreq2[axis] = val;
        } else {
            this.notchFreq1[axis] = val;
        }
    }

    public int getNotchWidth(int axis, int idx) {
        return idx == 2 ? this.notchWidth3[axis] : (idx == 1 ? this.notchWidth2[axis] : this.notchWidth1[axis]);
    }

    public void setNotchWidth(int axis, int idx, int val) {
        if (idx == 2) {
            this.notchWidth3[axis] = val;
        } else if (idx == 1) {
            this.notchWidth2[axis] = val;
        } else {
            this.notchWidth1[axis] = val;
        }
    }

    public int getNotchGain(int axis, int idx) {
        return idx == 2 ? this.notchGain3[axis] : (idx == 1 ? this.notchGain2[axis] : this.notchGain1[axis]);
    }

    public void setNotchGain(int axis, int idx, int val) {
        if (idx == 2) {
            this.notchGain3[axis] = val;
        } else if (idx == 1) {
            this.notchGain2[axis] = val;
        } else {
            this.notchGain1[axis] = val;
        }
    }

    public boolean isNotchEnabled(int axis, int idx) {
        return idx == 2 ? this.notchEnabled3[axis] : (idx == 1 ? this.notchEnabled2[axis] : this.notchEnabled1[axis]);
    }

    public void setNotchEnabled(int axis, int idx, boolean val) {
        if (idx == 2) {
            this.notchEnabled3[axis] = val;
        } else if (idx == 1) {
            this.notchEnabled2[axis] = val;
        } else {
            this.notchEnabled1[axis] = val;
        }
    }

    public BoardProfile clone() throws CloneNotSupportedException {
        BoardProfile copy = (BoardProfile)super.clone();
        copy.P = Arrays.copyOf(this.P, 3);
        copy.I = Arrays.copyOf(this.I, 3);
        copy.D = Arrays.copyOf(this.D, 3);
        copy.P_f = Arrays.copyOf(this.P_f, 3);
        copy.I_f = Arrays.copyOf(this.I_f, 3);
        copy.D_f = Arrays.copyOf(this.D_f, 3);
        copy.pid_gain = Arrays.copyOf(this.pid_gain, this.pid_gain.length);
        copy.pid_gain_f = Arrays.copyOf(this.pid_gain_f, this.pid_gain_f.length);
        copy.power = Arrays.copyOf(this.power, this.power.length);
        copy.boosterPower = Arrays.copyOf(this.boosterPower, this.boosterPower.length);
        copy.extFCGain = Arrays.copyOf(this.extFCGain, this.extFCGain.length);
        copy.rcMinAngle = Arrays.copyOf(this.rcMinAngle, this.rcMinAngle.length);
        copy.rcMaxAngle = Arrays.copyOf(this.rcMaxAngle, this.rcMaxAngle.length);
        copy.rcMode = Arrays.copyOf(this.rcMode, this.rcMode.length);
        copy.rcLPF = Arrays.copyOf(this.rcLPF, this.rcLPF.length);
        copy.rcSpeed = Arrays.copyOf(this.rcSpeed, this.rcSpeed.length);
        copy.rcFollow = Arrays.copyOf(this.rcFollow, this.rcFollow.length);
        copy.rcTrim = Arrays.copyOf(this.rcTrim, this.rcTrim.length);
        copy.rcMap = Arrays.copyOf(this.rcMap, this.rcMap.length);
        copy.rcMix = Arrays.copyOf(this.rcMix, this.rcMix.length);
        copy.followSpeed = Arrays.copyOf(this.followSpeed, this.followSpeed.length);
        copy.notchFreq1 = Arrays.copyOf(this.notchFreq1, this.notchFreq1.length);
        copy.notchFreq2 = Arrays.copyOf(this.notchFreq2, this.notchFreq2.length);
        copy.notchFreq3 = Arrays.copyOf(this.notchFreq3, this.notchFreq3.length);
        copy.notchWidth1 = Arrays.copyOf(this.notchWidth1, this.notchWidth1.length);
        copy.notchWidth2 = Arrays.copyOf(this.notchWidth2, this.notchWidth2.length);
        copy.notchWidth3 = Arrays.copyOf(this.notchWidth3, this.notchWidth3.length);
        copy.notchGain1 = Arrays.copyOf(this.notchGain1, this.notchGain1.length);
        copy.notchGain2 = Arrays.copyOf(this.notchGain2, this.notchGain2.length);
        copy.notchGain3 = Arrays.copyOf(this.notchGain3, this.notchGain3.length);
        copy.notchEnabled1 = Arrays.copyOf(this.notchEnabled1, this.notchEnabled1.length);
        copy.notchEnabled2 = Arrays.copyOf(this.notchEnabled2, this.notchEnabled2.length);
        copy.notchEnabled3 = Arrays.copyOf(this.notchEnabled3, this.notchEnabled3.length);
        copy.lpfFreq = Arrays.copyOf(this.lpfFreq, this.lpfFreq.length);
        copy.lpf_Q_inv = Arrays.copyOf(this.lpf_Q_inv, this.lpf_Q_inv.length);
        copy.lpfEnabled = Arrays.copyOf(this.lpfEnabled, this.lpfEnabled.length);
        copy.lpf1 = Arrays.copyOf(this.lpf1, this.lpf1.length);
        copy.d_lpfFreq = Arrays.copyOf(this.d_lpfFreq, this.d_lpfFreq.length);
        copy.servoOut = Arrays.copyOf(this.servoOut, this.servoOut.length);
        copy.rcInverse = Arrays.copyOf(this.rcInverse, this.rcInverse.length);
        copy.followLPF = Arrays.copyOf(this.followLPF, this.followLPF.length);
        copy.outerP = Arrays.copyOf(this.outerP, this.outerP.length);
        copy.outputMap = Arrays.copyOf(this.outputMap, this.outputMap.length);
        copy.angleAccLimit3 = Arrays.copyOf(this.angleAccLimit3, 3);
        copy.rcMemory = Arrays.copyOf(this.rcMemory, this.rcMemory.length);
        copy.follow_range = Arrays.copyOf(this.follow_range, this.follow_range.length);
        copy.stabAxis = Arrays.copyOf(this.stabAxis, this.stabAxis.length);
        copy.jerk_slope_ms = Arrays.copyOf(this.jerk_slope_ms, 3);
        copy.reserved_ext3 = Arrays.copyOf(this.reserved_ext3, this.reserved_ext3.length);
        copy.adc_replace = Arrays.copyOf(this.adc_replace, this.adc_replace.length);
        copy.stabThreshold = Arrays.copyOf(this.stabThreshold, this.stabThreshold.length);
        copy.rcDeadbandSplit = Arrays.copyOf(this.rcDeadbandSplit, this.rcDeadbandSplit.length);
        copy.rcExpoRateSplit = Arrays.copyOf(this.rcExpoRateSplit, this.rcExpoRateSplit.length);
        copy.shakeGenerator = this.shakeGenerator.clone();
        return copy;
    }

    public boolean equals(Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other == null || !(other instanceof BoardProfile)) {
            return false;
        }
        BoardProfile p = (BoardProfile)other;
        return Arrays.equals(this.P, p.P) && Arrays.equals(this.I, p.I) && Arrays.equals(this.D, p.D) && Arrays.equals(this.P_f, p.P_f) && Arrays.equals(this.I_f, p.I_f) && Arrays.equals(this.D_f, p.D_f) && Arrays.equals(this.pid_gain, p.pid_gain) && Arrays.equals(this.pid_gain_f, p.pid_gain_f) && Arrays.equals(this.angleAccLimit3, p.angleAccLimit3) && Arrays.equals(this.power, p.power) && Arrays.equals(this.boosterPower, p.boosterPower) && Arrays.equals(this.extFCGain, p.extFCGain) && Arrays.equals(this.rcMinAngle, p.rcMinAngle) && Arrays.equals(this.rcMaxAngle, p.rcMaxAngle) && Arrays.equals(this.rcMode, p.rcMode) && Arrays.equals(this.rcLPF, p.rcLPF) && Arrays.equals(this.rcSpeed, p.rcSpeed) && Arrays.equals(this.rcFollow, p.rcFollow) && Arrays.equals(this.rcTrim, p.rcTrim) && this.rcDeadband == p.rcDeadband && Arrays.equals(this.rcDeadbandSplit, p.rcDeadbandSplit) && this.gyroTrust == p.gyroTrust && this.accLPFFreq == p.accLPFFreq && this.accCompModel == p.accCompModel && this.pwmFreq == p.pwmFreq && this.serialSpeed == p.serialSpeed && this.rcExpoRate == p.rcExpoRate && Arrays.equals(this.rcExpoRateSplit, p.rcExpoRateSplit) && this.rcVirtMode == p.rcVirtMode && Arrays.equals(this.rcMap, p.rcMap) && Arrays.equals(this.rcMix, p.rcMix) && this.followMode == p.followMode && this.followExpoRate == p.followExpoRate && this.followDeadband == p.followDeadband && this.followInsideDeadband == p.followInsideDeadband && this.follow_roll_mix_start == p.follow_roll_mix_start && this.follow_roll_mix_range == p.follow_roll_mix_range && Arrays.equals(this.followSpeed, p.followSpeed) && this.flags4 == p.flags4 && Arrays.equals(this.notchFreq1, p.notchFreq1) && Arrays.equals(this.notchFreq2, p.notchFreq2) && Arrays.equals(this.notchFreq3, p.notchFreq3) && Arrays.equals(this.notchWidth1, p.notchWidth1) && Arrays.equals(this.notchWidth2, p.notchWidth2) && Arrays.equals(this.notchWidth3, p.notchWidth3) && Arrays.equals(this.notchGain1, p.notchGain1) && Arrays.equals(this.notchGain2, p.notchGain2) && Arrays.equals(this.notchGain3, p.notchGain3) && Arrays.equals(this.notchEnabled1, p.notchEnabled1) && Arrays.equals(this.notchEnabled2, p.notchEnabled2) && Arrays.equals(this.notchEnabled3, p.notchEnabled3) && Arrays.equals(this.lpfFreq, p.lpfFreq) && Arrays.equals(this.lpf_Q_inv, p.lpf_Q_inv) && Arrays.equals(this.lpfEnabled, p.lpfEnabled) && Arrays.equals(this.lpf1, p.lpf1) && Arrays.equals(this.d_lpfFreq, p.d_lpfFreq) && this.adaptivePIDEnabled == p.adaptivePIDEnabled && this.adaptivePIDThreshold == p.adaptivePIDThreshold && this.adaptivePIDRate == p.adaptivePIDRate && this.adaptivePIDRecoveryFactor == p.adaptivePIDRecoveryFactor && Arrays.equals(this.servoOut, p.servoOut) && this.servoRate == p.servoRate && Arrays.equals(this.rcInverse, p.rcInverse) && Arrays.equals(this.followLPF, p.followLPF) && Arrays.equals(this.outerP, p.outerP) && Arrays.equals(this.outputMap, p.outputMap) && this.profile_flags1 == p.profile_flags1 && this.profile_flags2 == p.profile_flags2 && this.spektrumMode == p.spektrumMode && this.magTrust == p.magTrust && this.eulerOrder == p.eulerOrder && Arrays.equals(this.rcMemory, p.rcMemory) && this.timelapseTime == p.timelapseTime && this.timelapseAccPart == p.timelapseAccPart && Arrays.equals(this.follow_range, p.follow_range) && Arrays.equals(this.stabAxis, p.stabAxis) && Arrays.equals(this.jerk_slope_ms, p.jerk_slope_ms) && this.mav_ctrl_mode == p.mav_ctrl_mode && Arrays.equals(this.adc_replace, p.adc_replace) && Arrays.equals(this.stabThreshold, p.stabThreshold) && this.profile_flags3 == p.profile_flags3 && this.shakeGenerator.equals(p.shakeGenerator) && this.servo_outerP_gain == p.servo_outerP_gain && this.servo_outerI == p.servo_outerI;
    }

    public void onFirmwareVersionChange(BoardParams params, int old_ver, int cur_ver) {
        for (int axis = 0; axis < 3; ++axis) {
            if (old_ver < 2560) {
                this.profile_flags1 |= 0x80;
                this.accLPFFreq = 20;
            }
            if (old_ver < 2580) {
                this.angleAccLimit3[axis] = this.angleAccLimit;
                this.d_lpfFreq[axis] = 20;
            }
            if (old_ver < 2589) {
                this.setPIDGain(axis, params.gyroSens > 0 ? 2.0f : 1.0f);
            }
            if (old_ver < 2592) {
                this.rcMemory[axis] = params.rcMemory_deprecated[axis];
            }
            if (old_ver < 2616) {
                this.timelapseTime = 600;
                this.timelapseAccPart = 50;
            }
            if (old_ver < 2662) {
                this.mav_ctrl_mode = 2;
            }
            if (old_ver < 2694) {
                this.profile_flags1 |= 0x4000;
            }
            if (old_ver < 2731 && cur_ver >= 2731) {
                this.set_LPF_Q_inv(axis, 1.4142f);
            }
            if (old_ver >= 2736) continue;
            this.servo_outerP_gain = 5.0f;
            this.servo_outerI = 50.0f;
        }
    }

    public void onAppVersionChange(BoardParams params, int old_ver) {
        if (old_ver < 2449) {
            this.outputMap = Arrays.copyOf(params.outputMap_general, params.outputMap_general.length);
        }
        for (int axis = 0; axis < 3; ++axis) {
            if (old_ver < 2686) {
                int n = axis;
                this.d_lpfFreq[n] = this.d_lpfFreq[n] * 10;
            }
            if (old_ver >= 2701) continue;
            this.P_f[axis] = this.P[axis];
            this.I_f[axis] = this.I[axis];
            this.D_f[axis] = this.D[axis];
        }
    }

    public void onProfileFileLoaded(int firmwareVer, int appVer) {
    }

    public boolean isOutputCANDrv(int axis) {
        return this.outputMap[axis] >= 8 && this.outputMap[axis] <= 14;
    }

    public int getOutputCANDrvIdx(int axis) {
        return this.isOutputCANDrv(axis) ? this.outputMap[axis] - 8 : -1;
    }

    public void onBeforeSaveFile() throws Exception {
        for (int axis = 0; axis < 3; ++axis) {
            this.P[axis] = MathUtils.constrain(Math.round(this.P_f[axis]), 0, 255);
            this.I[axis] = MathUtils.constrain(Math.round(this.I_f[axis]), 0, 255);
            this.D[axis] = MathUtils.constrain(Math.round(this.D_f[axis]), 0, 255);
        }
    }
}

