/*
 * Decompiled with CFR 0.152.
 */
package sbgc.object;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.log4j.Logger;
import sbgc.object.BoardInfo;
import sbgc.object.ErrorInfo;
import sbgc.object.Sprav;
import sbgc.service.CommandResponseListener;
import sbgc.service.SerialCommand;
import sbgc.service.SerialCommandProcessor;
import sbgc.service.upgrade.IProgressListener;
import sbgc.utils.DataLogger;

public class BodeTest {
    static final Logger logger = Logger.getLogger((String)BodeTest.class.getName());
    public static final long TEST_DURATION_CNT = 12500L;
    public static final int STIMULUS_WHITE_NOISE = 1;
    public static final int STIMULUS_SINE_SWEEP_LINEAR_GAIN = 2;
    public static final int STIMULUS_SINE_SWEEP_EXP_GAIN = 3;
    public static final int OLD_SYS_CTRL_PLANT = 1;
    public static final int OLD_SYS_CTRL_PLANT_CLOSED_LOOP = 2;
    public static final int OLD_SYS_CTRL = 3;
    public static final int OLD_SYS_PLANT_NO_FILTERS = 4;
    public static final int OLD_SYS_OVERALL = 5;
    public static final int OLD_SYS_PLANT = 6;
    public static final int OLD_SYS_PLANT_CLOSED_LOOP = 7;
    public static final int OLD_SYS_PLANT_FILTERS_CLOSED_LOOP = 8;
    public static final int BT_SYS_FLAG_CTRL = 1;
    public static final int BT_SYS_FLAG_PLANT = 4;
    public static final int BT_SYS_FLAG_OVERALL = 8;
    public static final int BT_SYS_FLAG_NO_FILTERS = 64;
    public static final int BT_SYS_FLAG_CLOSED_LOOP = 128;
    public static final int BT_SYS_FLAG_NEW = 2;
    public static final int SYS_PLANT_FILTERS_OPEN = 6;
    public static final int SYS_PLANT_OPEN = 70;
    public static final int SYS_PLANT_FILTERS_CLOSED = 134;
    public static final int SYS_PLANT_CLOSED = 198;
    public static final int SYS_CTRL = 3;
    public static final int SYS_CTRL_PLANT_OPEN = 7;
    public static final int SYS_CTRL_PLANT_CLOSED = 135;
    public static final int SYS_OVERALL = 11;
    public static final int SYS_VECTOR_AMPLITUDE = 32768;
    public static final int SYS_TRANSFER_FUNC = 32769;
    public static final SystemType[] SYSTEM_TYPES = new SystemType[]{new SystemType(70, "Plant (open loop)", 4), new SystemType(6, "Plant + notch filters (open loop)", 6), new SystemType(198, "Plant (closed loop)", 7), new SystemType(134, "Plant + notch filters (closed loop)", 8), new SystemType(3, "Controller", 3), new SystemType(7, "Controller + Plant (open loop)", 1), new SystemType(135, "Controller + Plant (closed loop)", 2), new SystemType(11, "Overall system response", 5)};
    public static final int MODE_BODE_TEST = 0;
    public static final int MODE_NOTCH_AUTO_TUNE = 1;
    public static final int MODE_AUTO_GAIN_TUNE = 2;
    DataLogger dataLogger = null;
    long data_cnt = 0L;
    int prev_cnt = -1;
    int missed_cnt = 0;
    long duration = 12500L;
    public static final BodeTest instance = new BodeTest();
    private static final DecimalFormat floatFormatter = new DecimalFormat("0.#####E0", new DecimalFormatSymbols(Locale.ENGLISH));
    private int next_progress = 0;
    IProgressListener progressListener = null;

    public static ArrayList<Sprav> getSystemTypes() {
        ArrayList<Sprav> list = new ArrayList<Sprav>(SYSTEM_TYPES.length);
        for (SystemType st : SYSTEM_TYPES) {
            list.add(new Sprav(st.id, st.name));
        }
        return list;
    }

    public boolean isActive() {
        return this.dataLogger != null;
    }

    public synchronized void start(int axis, int stimulus, int gain, int startFreq, int endFreq, int system, String filename, IProgressListener _progressListener) throws Exception {
        this.duration = system == 3 ? 6250L : 12500L;
        int system_in_cmd = system;
        if (!BoardInfo.autoPID2() && (system_in_cmd = BodeTest.getLegacySystem(system)) == 0) {
            throw new Exception("This type of system is not supported in the firmware");
        }
        try {
            if (this.dataLogger != null) {
                this.dataLogger.finish();
            }
            this.dataLogger = new DataLogger(filename, false);
            this.dataLogger.setHeader(Arrays.asList("%sbgc_test_data", Integer.toString(system), Integer.toString(axis), Integer.toString(stimulus), Integer.toString(gain), Integer.toString(startFreq), Integer.toString(endFreq)));
        }
        catch (Exception e) {
            throw new Exception("Can't open log file for writing: " + e.toString());
        }
        this.progressListener = _progressListener;
        this.data_cnt = 0L;
        this.prev_cnt = 0;
        this.missed_cnt = 0;
        SerialCommand cmd = new SerialCommand(37);
        cmd.writeByte(axis);
        cmd.writeByte(stimulus);
        cmd.writeWord(gain);
        cmd.writeWord(endFreq);
        cmd.writeByte(system_in_cmd);
        cmd.writeDWord(this.duration);
        cmd.writeByte(0);
        cmd.writeWord(startFreq);
        cmd.writeEmptyArr(16);
        if (BoardInfo.hasExtPIDRange()) {
            SerialCommand resp = CommandResponseListener.sendCommandAndWaitAnswer(cmd, 3000L);
            if (resp == null || resp.id != 67) {
                if (this.dataLogger != null) {
                    this.dataLogger.finish();
                    this.dataLogger = null;
                }
                if (resp == null) {
                    throw new Exception("No response on the CMD_BODE_TEST_START_STOP command");
                }
                if (resp.getId() == 255) {
                    throw new Exception(ErrorInfo.formatCmdErrorInfo(resp));
                }
                throw new Exception("Unknown response");
            }
        } else {
            SerialCommandProcessor.sendCommand(cmd);
        }
        if (this.progressListener != null) {
            this.progressListener.onProgressStart("System test started.", false);
        }
        this.next_progress = 5;
    }

    public synchronized void sendStopCmd() {
        try {
            SerialCommand cmd = new SerialCommand(37);
            cmd.writeEmptyArr(30);
            if (!CommandResponseListener.sendCommandAndWaitConfirm(cmd, 3000L) && this.dataLogger != null) {
                this.dataLogger.finish();
                this.dataLogger = null;
                if (this.progressListener != null) {
                    this.progressListener.onProgressFinish(false);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error sending stop command: " + e.toString()));
        }
    }

    public void parse_data(SerialCommand cmd) {
        try {
            int cnt = cmd.readByte();
            int got_cnt = 0;
            if (cmd.getBytesAvailable() == 80) {
                for (int i = 0; i < 10; ++i) {
                    float in = cmd.readFloat();
                    float out = cmd.readFloat();
                    this.logData(in, out);
                }
                got_cnt = 10;
            } else if (cmd.getBytesAvailable() == 96) {
                float[][] min_max = new float[][]{{cmd.readFloat(), cmd.readFloat()}, {cmd.readFloat(), cmd.readFloat()}};
                if (Float.isNaN(min_max[0][0]) || Float.isNaN(min_max[0][1]) || Float.isNaN(min_max[1][0]) || Float.isNaN(min_max[1][1])) {
                    throw new Exception("Invalid data: NaN");
                }
                for (int i = 0; i < 20; ++i) {
                    float in = (float)cmd.readWordUnsigned() * (min_max[1][0] - min_max[0][0]) / 65534.0f + min_max[0][0];
                    float out = (float)cmd.readWordUnsigned() * (min_max[1][1] - min_max[0][1]) / 65534.0f + min_max[0][1];
                    this.logData(in, out);
                }
                got_cnt = 20;
            }
            cmd.checkFinished();
            int delta = cnt - this.prev_cnt & 0xFF;
            if (delta > got_cnt) {
                this.missed_cnt += delta;
                ErrorInfo.setErrorText("Missed data: " + this.missed_cnt);
            }
            this.data_cnt += (long)delta;
            this.prev_cnt = cnt;
            int progress = (int)(this.data_cnt * 100L / this.duration);
            if (progress >= this.next_progress && this.progressListener != null) {
                this.progressListener.onProgressChange(progress);
                this.next_progress = progress + 1;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error parsing CMD_BODE_TEST_DATA: " + e.toString()));
        }
    }

    void logData(float in, float out) {
        if (this.dataLogger != null) {
            this.dataLogger.logData(floatFormatter.format(in) + ";" + floatFormatter.format(out));
        }
    }

    public void on_stop_cmd(SerialCommand cmd) {
        try {
            long cnt = cmd.readDWordUnsigned();
            int error = cmd.readWordUnsigned();
            int mode = cmd.readByte();
            cmd.startReading();
            if (this.dataLogger != null) {
                this.dataLogger.finish();
                ErrorInfo.updateStatus("Test result successfuly stored to " + this.dataLogger.getLogFileName());
                if (error == 0) {
                    if (cnt == this.data_cnt) {
                        ErrorInfo.setErrorText(null);
                    } else {
                        ErrorInfo.setErrorText("Missed data during test: " + (cnt - this.data_cnt));
                        logger.debug((Object)("cnt: " + cnt + ", data_cnt: " + this.data_cnt));
                    }
                    if (this.progressListener != null) {
                        this.progressListener.onProgressFinish(true);
                    }
                } else {
                    ErrorInfo.setBoardError(error);
                    if (this.progressListener != null) {
                        this.progressListener.onProgressFinish(false);
                    }
                }
                this.dataLogger = null;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public File getFile() {
        return this.dataLogger != null ? this.dataLogger.getLogFile() : null;
    }

    public static int getLegacySystem(int systemId) {
        for (SystemType st : SYSTEM_TYPES) {
            if (st.id != systemId) continue;
            return st.old_id;
        }
        return 0;
    }

    public static int fromLegacySystem(int oldSystemId) {
        for (SystemType st : SYSTEM_TYPES) {
            if (st.old_id != oldSystemId) continue;
            return st.id;
        }
        return 0;
    }

    public static class SystemType {
        public int id;
        public String name;
        public int old_id;

        private SystemType(int id, String name, int old_id) {
            this.id = id;
            this.name = name;
            this.old_id = old_id;
        }
    }
}

